/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonStringException;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class AddConcatExpression
extends Expression {
    private final Expression left;
    private final Expression right;

    AddConcatExpression(Expression expression, Expression expression2) {
        this.left = expression;
        this.right = expression2;
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        TemplateModel templateModel = this.left.getAsTemplateModel(environment);
        TemplateModel templateModel2 = this.right.getAsTemplateModel(environment);
        if (templateModel instanceof TemplateNumberModel && templateModel2 instanceof TemplateNumberModel) {
            Number number = EvaluationUtil.getNumber((TemplateNumberModel)templateModel, this.left, environment);
            Number number2 = EvaluationUtil.getNumber((TemplateNumberModel)templateModel2, this.right, environment);
            ArithmeticEngine arithmeticEngine = environment != null ? environment.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
            return new SimpleNumber(arithmeticEngine.add(number, number2));
        }
        if (templateModel instanceof TemplateSequenceModel && templateModel2 instanceof TemplateSequenceModel) {
            return new ConcatenatedSequence((TemplateSequenceModel)templateModel, (TemplateSequenceModel)templateModel2);
        }
        try {
            String string;
            String string2 = AddConcatExpression.getStringValue(templateModel, this.left, environment);
            if (string2 == null) {
                string2 = "null";
            }
            if ((string = AddConcatExpression.getStringValue(templateModel2, this.right, environment)) == null) {
                string = "null";
            }
            return new SimpleScalar(string2.concat(string));
        }
        catch (NonStringException nonStringException) {
            if (templateModel instanceof TemplateHashModel && templateModel2 instanceof TemplateHashModel) {
                if (templateModel instanceof TemplateHashModelEx && templateModel2 instanceof TemplateHashModelEx) {
                    TemplateHashModelEx templateHashModelEx = (TemplateHashModelEx)templateModel;
                    TemplateHashModelEx templateHashModelEx2 = (TemplateHashModelEx)templateModel2;
                    if (templateHashModelEx.size() == 0) {
                        return templateHashModelEx2;
                    }
                    if (templateHashModelEx2.size() == 0) {
                        return templateHashModelEx;
                    }
                    return new ConcatenatedHashEx(templateHashModelEx, templateHashModelEx2);
                }
                return new ConcatenatedHash((TemplateHashModel)templateModel, (TemplateHashModel)templateModel2);
            }
            throw nonStringException;
        }
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String string, Expression expression) {
        return new AddConcatExpression(this.left.deepClone(string, expression), this.right.deepClone(string, expression));
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + " + " + this.right.getCanonicalForm();
    }

    private static class ConcatenatedHash
    implements TemplateHashModel {
        protected final TemplateHashModel left;
        protected final TemplateHashModel right;

        ConcatenatedHash(TemplateHashModel templateHashModel, TemplateHashModel templateHashModel2) {
            this.left = templateHashModel;
            this.right = templateHashModel2;
        }

        public TemplateModel get(String string) throws TemplateModelException {
            TemplateModel templateModel = this.right.get(string);
            return templateModel != null ? templateModel : this.left.get(string);
        }

        public boolean isEmpty() throws TemplateModelException {
            return this.left.isEmpty() && this.right.isEmpty();
        }
    }

    private static final class ConcatenatedHashEx
    extends ConcatenatedHash
    implements TemplateHashModelEx {
        private Set keySet;
        private TemplateCollectionModel keys;
        private TemplateCollectionModel values;
        private int size;

        ConcatenatedHashEx(TemplateHashModelEx templateHashModelEx, TemplateHashModelEx templateHashModelEx2) {
            super(templateHashModelEx, templateHashModelEx2);
        }

        public int size() throws TemplateModelException {
            this.initKeys();
            return this.size;
        }

        public TemplateCollectionModel keys() throws TemplateModelException {
            this.initKeys();
            return this.keys;
        }

        public TemplateCollectionModel values() throws TemplateModelException {
            this.initValues();
            return this.values;
        }

        private void initKeys() throws TemplateModelException {
            if (this.keys == null) {
                this.keySet = new HashSet();
                ConcatenatedHashEx.addKeys(this.keySet, (TemplateHashModelEx)this.left);
                ConcatenatedHashEx.addKeys(this.keySet, (TemplateHashModelEx)this.right);
                this.size = this.keySet.size();
                this.keys = new CollectionAndSequence(new SimpleSequence(this.keySet));
            }
        }

        private static void addKeys(Set set, TemplateHashModelEx templateHashModelEx) throws TemplateModelException {
            TemplateModelIterator templateModelIterator = templateHashModelEx.keys().iterator();
            while (templateModelIterator.hasNext()) {
                set.add(((TemplateScalarModel)templateModelIterator.next()).getAsString());
            }
        }

        private void initValues() throws TemplateModelException {
            if (this.values == null) {
                ArrayList<TemplateModel> arrayList = new ArrayList<TemplateModel>(this.size());
                Iterator iterator = this.keySet.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(this.get((String)iterator.next()));
                }
                this.values = new CollectionAndSequence(new SimpleSequence(arrayList));
            }
        }
    }

    private static final class ConcatenatedSequence
    implements TemplateSequenceModel {
        private final TemplateSequenceModel left;
        private final TemplateSequenceModel right;

        ConcatenatedSequence(TemplateSequenceModel templateSequenceModel, TemplateSequenceModel templateSequenceModel2) {
            this.left = templateSequenceModel;
            this.right = templateSequenceModel2;
        }

        public int size() throws TemplateModelException {
            return this.left.size() + this.right.size();
        }

        public TemplateModel get(int n) throws TemplateModelException {
            int n2 = this.left.size();
            return n < n2 ? this.left.get(n) : this.right.get(n - n2);
        }
    }
}

