/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateSource;
import freemarker.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;

public class WebappTemplateLoader
implements TemplateLoader {
    private static final Logger logger = Logger.getLogger("freemarker.cache");
    private final ServletContext servletContext;
    private final String path;

    public WebappTemplateLoader(ServletContext servletContext) {
        this(servletContext, "/");
    }

    public WebappTemplateLoader(ServletContext servletContext, String string) {
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext == null");
        }
        if (string == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (!(string = string.replace('\\', '/')).endsWith("/")) {
            string = string + "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        this.path = string;
        this.servletContext = servletContext;
    }

    public Object findTemplateSource(String string) throws IOException {
        Object object;
        String string2 = this.path + string;
        try {
            object = this.servletContext.getRealPath(string2);
            if (object != null) {
                File file = new File((String)object);
                if (!file.isFile()) {
                    return null;
                }
                if (file.canRead()) {
                    return file;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object = null;
        try {
            object = this.servletContext.getResource(string2);
        }
        catch (MalformedURLException malformedURLException) {
            logger.warn("Could not retrieve resource " + string2, malformedURLException);
            return null;
        }
        return object == null ? null : new URLTemplateSource((URL)object);
    }

    public long getLastModified(Object object) {
        if (object instanceof File) {
            return ((File)object).lastModified();
        }
        return ((URLTemplateSource)object).lastModified();
    }

    public Reader getReader(Object object, String string) throws IOException {
        if (object instanceof File) {
            return new InputStreamReader((InputStream)new FileInputStream((File)object), string);
        }
        return new InputStreamReader(((URLTemplateSource)object).getInputStream(), string);
    }

    public void closeTemplateSource(Object object) throws IOException {
        if (!(object instanceof File)) {
            ((URLTemplateSource)object).close();
        }
    }
}

