/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class URLTemplateSource {
    private final URL url;
    private URLConnection conn;
    private InputStream inputStream;

    URLTemplateSource(URL uRL) throws IOException {
        this.url = uRL;
        this.conn = uRL.openConnection();
    }

    public boolean equals(Object object) {
        if (object instanceof URLTemplateSource) {
            return this.url.equals(((URLTemplateSource)object).url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url.toString();
    }

    long lastModified() {
        long l = this.conn.getLastModified();
        if (l == -1L && this.url.getProtocol().equals("file")) {
            return new File(this.url.getFile()).lastModified();
        }
        return l;
    }

    InputStream getInputStream() throws IOException {
        this.inputStream = this.conn.getInputStream();
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
            this.conn = null;
        }
    }
}

