/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorage;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.StatefulTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class TemplateCache {
    private static final String ASTERISKSTR = "*";
    private static final String LOCALE_SEPARATOR = "_";
    private static final char ASTERISK = '*';
    private static final String CURRENT_DIR_PATH_PREFIX = "./";
    private static final String CURRENT_DIR_PATH = "/./";
    private static final String PARENT_DIR_PATH_PREFIX = "../";
    private static final String PARENT_DIR_PATH = "/../";
    private static final char SLASH = '/';
    private static final Logger logger = Logger.getLogger("freemarker.cache");
    private final TemplateLoader mainLoader;
    private final CacheStorage storage;
    private long delay = 5000L;
    private boolean localizedLookup = true;
    private Configuration config;

    public TemplateCache() {
        this(TemplateCache.createDefaultTemplateLoader());
    }

    private static TemplateLoader createDefaultTemplateLoader() {
        try {
            return new FileTemplateLoader();
        }
        catch (Exception exception) {
            logger.warn("Could not create a file template loader for current directory", exception);
            return null;
        }
    }

    public TemplateCache(TemplateLoader templateLoader) {
        this(templateLoader, new MruCacheStorage(0, Integer.MAX_VALUE));
    }

    public TemplateCache(TemplateLoader templateLoader, CacheStorage cacheStorage) {
        this.mainLoader = templateLoader;
        this.storage = cacheStorage;
        if (cacheStorage == null) {
            throw new IllegalArgumentException("storage == null");
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.clear();
    }

    public TemplateLoader getTemplateLoader() {
        return this.mainLoader;
    }

    public CacheStorage getCacheStorage() {
        return this.storage;
    }

    public Template getTemplate(String string, Locale locale, String string2, boolean bl) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Argument \"name\" can't be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Argument \"locale\" can't be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Argument \"encoding\" can't be null");
        }
        if ((string = TemplateCache.normalizeName(string)) == null) {
            return null;
        }
        Template template = null;
        if (this.mainLoader != null) {
            template = this.getTemplate(this.mainLoader, string, locale, string2, bl);
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Template getTemplate(TemplateLoader var1_1, String var2_2, Locale var3_3, String var4_4, boolean var5_5) throws IOException {
        var6_6 = TemplateCache.logger.isDebugEnabled();
        var7_7 = var6_6 != false ? var2_2 + "[" + var3_3 + "," + var4_4 + (var5_5 != false ? ",parsed] " : ",unparsed] ") : null;
        var8_8 = new TemplateKey(var2_2, var3_3, var4_4, var5_5);
        var9_9 = this.storage;
        synchronized (var9_9) {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                var10_10 = (CachedTemplate)this.storage.get(var8_8);
                                var11_11 = System.currentTimeMillis();
                                var13_12 = -1L;
                                var15_13 = null;
                                try {
                                    if (var10_10 == null) ** GOTO lbl55
                                    if (var11_11 - var10_10.lastChecked < this.delay) {
                                        if (var6_6) {
                                            TemplateCache.logger.debug(var7_7 + "cached copy not yet stale; using cached.");
                                        }
                                        var16_14 = var10_10.template;
                                        if (var15_13 == null) break block17;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Throwable var19_22) {
                                    if (var15_13 != null) {
                                        var1_1.closeTemplateSource(var15_13);
                                    }
                                    throw var19_22;
                                }
                                var1_1.closeTemplateSource(var15_13);
                            }
                            return var16_14;
lbl-1000:
                            // 1 sources

                            {
                                var10_10.lastChecked = var11_11;
                                var15_13 = this.findTemplateSource(var2_2, var3_3);
                                if (var15_13 != null) ** GOTO lbl-1000
                                if (var6_6) {
                                    TemplateCache.logger.debug(var7_7 + "no source found (removing from cache if it was cached).");
                                }
                                this.storage.remove(var8_8);
                                var16_15 = null;
                                if (var15_13 == null) break block18;
                            }
                            var1_1.closeTemplateSource(var15_13);
                        }
                        return var16_15;
lbl-1000:
                        // 1 sources

                        {
                            var13_12 = var1_1.getLastModified(var15_13);
                            var16_16 = var13_12 == var10_10.lastModified;
                            var17_19 = var15_13.equals(var10_10.source);
                            if (!var16_16 || !var17_19) ** GOTO lbl-1000
                            if (var6_6) {
                                TemplateCache.logger.debug(var7_7 + "using cached since " + var15_13 + " didn't change.");
                            }
                            var10_10.lastChecked = var11_11;
                            var18_21 = var10_10.template;
                            if (var15_13 == null) break block19;
                        }
                        var1_1.closeTemplateSource(var15_13);
                    }
                    return var18_21;
lbl-1000:
                    // 1 sources

                    {
                        if (var6_6 && !var17_19) {
                            TemplateCache.logger.debug("Updating source, info for cause: sourceEquals=" + var17_19 + ", newlyFoundSource=" + var15_13 + ", cachedTemplate.source=" + var10_10.source);
                        }
                        if (var6_6 && !var16_16) {
                            TemplateCache.logger.debug("Updating source, info for cause: lastModifiedNotChanged=" + var16_16 + ", cache lastModified=" + var10_10.lastModified + " != file lastModified=" + var13_12);
                        }
                        var10_10.source = var15_13;
                        ** GOTO lbl69
lbl55:
                        // 1 sources

                        if (var6_6) {
                            TemplateCache.logger.debug("Could not find template in cache, creating new one; id=[" + TemplateKey.access$000(var8_8) + "[" + TemplateKey.access$100(var8_8) + "," + TemplateKey.access$200(var8_8) + (TemplateKey.access$300(var8_8) != false ? ",parsed] " : ",unparsed] ") + "]");
                        }
                        if ((var15_13 = this.findTemplateSource(var2_2, var3_3)) != null) ** GOTO lbl-1000
                        var16_17 = null;
                        if (var15_13 == null) break block20;
                    }
                    var1_1.closeTemplateSource(var15_13);
                }
                return var16_17;
lbl-1000:
                // 1 sources

                {
                    var10_10 = new CachedTemplate();
                    var10_10.source = var15_13;
                    var10_10.lastChecked = var11_11;
                    var13_12 = -9223372036854775808L;
                    var10_10.lastModified = -9223372036854775808L;
                    this.storage.put(var8_8, var10_10);
lbl69:
                    // 2 sources

                    if (var6_6) {
                        TemplateCache.logger.debug("Compiling FreeMarker template " + var7_7 + " from " + var15_13);
                    }
                    var16_18 = var10_10.source;
                    var10_10.template = this.loadTemplate(var1_1, var2_2, var3_3, var4_4, var5_5, var16_18);
                    var10_10.lastModified = var13_12 == -9223372036854775808L ? var1_1.getLastModified(var16_18) : var13_12;
                    var17_20 = var10_10.template;
                    if (var15_13 == null) break block21;
                }
                var1_1.closeTemplateSource(var15_13);
            }
            return var17_20;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template loadTemplate(TemplateLoader templateLoader, String string, Locale locale, String string2, boolean bl, Object object) throws IOException {
        Template template;
        Reader reader = templateLoader.getReader(object, string2);
        try {
            if (bl) {
                try {
                    template = new Template(string, reader, this.config, string2);
                }
                catch (Template.WrongEncodingException wrongEncodingException) {
                    string2 = wrongEncodingException.specifiedEncoding;
                    reader = templateLoader.getReader(object, string2);
                    template = new Template(string, reader, this.config, string2);
                }
                template.setLocale(locale);
            } else {
                StringWriter stringWriter = new StringWriter();
                char[] cArray = new char[4096];
                while (true) {
                    int n;
                    if ((n = reader.read(cArray)) > 0) {
                        stringWriter.write(cArray, 0, n);
                        continue;
                    }
                    if (n == -1) break;
                }
                template = Template.getPlainTextTemplate(string, stringWriter.toString(), this.config);
                template.setLocale(locale);
            }
            template.setEncoding(string2);
        }
        finally {
            reader.close();
        }
        return template;
    }

    public synchronized long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long l) {
        this.delay = l;
    }

    public synchronized boolean getLocalizedLookup() {
        return this.localizedLookup;
    }

    public synchronized void setLocalizedLookup(boolean bl) {
        this.localizedLookup = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CacheStorage cacheStorage = this.storage;
        synchronized (cacheStorage) {
            this.storage.clear();
            if (this.mainLoader instanceof StatefulTemplateLoader) {
                ((StatefulTemplateLoader)this.mainLoader).resetState();
            }
        }
    }

    public static String getFullTemplatePath(Environment environment, String string, String string2) {
        if (!environment.isClassicCompatible() && string2.indexOf("://") <= 0) {
            int n;
            string2 = string2.length() > 0 && string2.charAt(0) == '/' ? ((n = string.indexOf("://")) > 0 ? string.substring(0, n + 2) + string2 : string2.substring(1)) : string + string2;
        }
        return string2;
    }

    private Object findTemplateSource(String string, Locale locale) throws IOException {
        if (this.localizedLookup) {
            int n = string.lastIndexOf(46);
            String string2 = n == -1 ? string : string.substring(0, n);
            String string3 = n == -1 ? "" : string.substring(n);
            String string4 = LOCALE_SEPARATOR + locale.toString();
            StringBuffer stringBuffer = new StringBuffer(string.length() + string4.length());
            stringBuffer.append(string2);
            while (true) {
                stringBuffer.setLength(string2.length());
                String string5 = stringBuffer.append(string4).append(string3).toString();
                Object object = this.acquireTemplateSource(string5);
                if (object != null) {
                    return object;
                }
                int n2 = string4.lastIndexOf(95);
                if (n2 == -1) break;
                string4 = string4.substring(0, n2);
            }
            return null;
        }
        return this.acquireTemplateSource(string);
    }

    private Object acquireTemplateSource(String string) throws IOException {
        String string2;
        int n = string.indexOf(42);
        if (n == -1) {
            return this.mainLoader.findTemplateSource(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n2 = -1;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(ASTERISKSTR)) {
                if (n2 != -1) {
                    arrayList.remove(n2);
                }
                n2 = arrayList.size();
            }
            arrayList.add(string2);
        }
        string2 = this.concatPath(arrayList, 0, n2);
        String string3 = this.concatPath(arrayList, n2 + 1, arrayList.size());
        if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length()).append(string2);
        int n3 = string2.length();
        boolean bl = logger.isDebugEnabled();
        while (true) {
            Object object;
            String string4 = stringBuffer.append(string3).toString();
            if (bl) {
                logger.debug("Trying to find template source " + string4);
            }
            if ((object = this.mainLoader.findTemplateSource(string4)) != null) {
                return object;
            }
            if (n3 == 0) {
                return null;
            }
            n3 = string2.lastIndexOf(47, n3 - 2) + 1;
            stringBuffer.setLength(n3);
        }
    }

    private String concatPath(List list, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer((n2 - n) * 16);
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(list.get(i)).append('/');
        }
        return stringBuffer.toString();
    }

    private static String normalizeName(String string) {
        int n;
        if (string.indexOf("://") > 0) {
            return string;
        }
        while (true) {
            if ((n = string.indexOf(PARENT_DIR_PATH)) == 0) {
                return null;
            }
            if (n == -1) {
                if (!string.startsWith(PARENT_DIR_PATH_PREFIX)) break;
                return null;
            }
            int n2 = string.lastIndexOf(47, n - 1);
            string = string.substring(0, n2 + 1) + string.substring(n + PARENT_DIR_PATH.length());
        }
        while (true) {
            if ((n = string.indexOf(CURRENT_DIR_PATH)) == -1) {
                if (!string.startsWith(CURRENT_DIR_PATH_PREFIX)) break;
                string = string.substring(CURRENT_DIR_PATH_PREFIX.length());
                break;
            }
            string = string.substring(0, n) + string.substring(n + CURRENT_DIR_PATH.length() - 1);
        }
        if (string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    private static final class CachedTemplate {
        Template template;
        Object source;
        long lastChecked;
        long lastModified;

        private CachedTemplate() {
        }
    }

    private static final class TemplateKey {
        private final String name;
        private final Locale locale;
        private final String encoding;
        private final boolean parse;

        TemplateKey(String string, Locale locale, String string2, boolean bl) {
            this.name = string;
            this.locale = locale;
            this.encoding = string2;
            this.parse = bl;
        }

        public boolean equals(Object object) {
            if (object instanceof TemplateKey) {
                TemplateKey templateKey = (TemplateKey)object;
                return this.parse == templateKey.parse && this.name.equals(templateKey.name) && this.locale.equals(templateKey.locale) && this.encoding.equals(templateKey.encoding);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.locale.hashCode() ^ this.encoding.hashCode() ^ (this.parse ? Boolean.FALSE : Boolean.TRUE).hashCode();
        }

        static /* synthetic */ String access$000(TemplateKey templateKey) {
            return templateKey.name;
        }

        static /* synthetic */ Locale access$100(TemplateKey templateKey) {
            return templateKey.locale;
        }

        static /* synthetic */ String access$200(TemplateKey templateKey) {
            return templateKey.encoding;
        }

        static /* synthetic */ boolean access$300(TemplateKey templateKey) {
            return templateKey.parse;
        }
    }
}

