/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class StringTemplateLoader
implements TemplateLoader {
    private final Map templates = new HashMap();

    public void putTemplate(String string, String string2) {
        this.putTemplate(string, string2, System.currentTimeMillis());
    }

    public void putTemplate(String string, String string2, long l) {
        this.templates.put(string, new StringTemplateSource(string, string2, l));
    }

    public void closeTemplateSource(Object object) {
    }

    public Object findTemplateSource(String string) {
        return this.templates.get(string);
    }

    public long getLastModified(Object object) {
        return ((StringTemplateSource)object).lastModified;
    }

    public Reader getReader(Object object, String string) {
        return new StringReader(((StringTemplateSource)object).source);
    }

    private static class StringTemplateSource {
        private final String name;
        private final String source;
        private final long lastModified;

        StringTemplateSource(String string, String string2, long l) {
            if (string == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("source == null");
            }
            if (l < -1L) {
                throw new IllegalArgumentException("lastModified < -1L");
            }
            this.name = string;
            this.source = string2;
            this.lastModified = l;
        }

        public boolean equals(Object object) {
            if (object instanceof StringTemplateSource) {
                return this.name.equals(((StringTemplateSource)object).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

