/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SoftCacheStorage
implements CacheStorage {
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Map map;

    public SoftCacheStorage() {
        this(new HashMap());
    }

    public SoftCacheStorage(Map map) {
        this.map = map;
    }

    public Object get(Object object) {
        this.processQueue();
        Reference reference = (Reference)this.map.get(object);
        return reference == null ? null : reference.get();
    }

    public void put(Object object, Object object2) {
        this.processQueue();
        this.map.put(object, new SoftValueReference(object, object2, this.queue));
    }

    public void remove(Object object) {
        this.processQueue();
        this.map.remove(object);
    }

    public void clear() {
        this.map.clear();
        this.processQueue();
    }

    private void processQueue() {
        SoftValueReference softValueReference;
        while ((softValueReference = (SoftValueReference)this.queue.poll()) != null) {
            Object object = softValueReference.getKey();
            if (this.map.get(object) != softValueReference) continue;
            this.map.remove(object);
        }
        return;
    }

    private static final class SoftValueReference
    extends SoftReference {
        private final Object key;

        SoftValueReference(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        Object getKey() {
            return this.key;
        }
    }
}

