/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.StatefulTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MultiTemplateLoader
implements StatefulTemplateLoader {
    private final TemplateLoader[] loaders;
    private final Map lastLoaderForName = Collections.synchronizedMap(new HashMap());

    public MultiTemplateLoader(TemplateLoader[] templateLoaderArray) {
        this.loaders = (TemplateLoader[])templateLoaderArray.clone();
    }

    public Object findTemplateSource(String string) throws IOException {
        Object object;
        TemplateLoader templateLoader = (TemplateLoader)this.lastLoaderForName.get(string);
        if (templateLoader != null && (object = templateLoader.findTemplateSource(string)) != null) {
            return new MultiSource(object, templateLoader);
        }
        for (int i = 0; i < this.loaders.length; ++i) {
            TemplateLoader templateLoader2 = this.loaders[i];
            Object object2 = templateLoader2.findTemplateSource(string);
            if (object2 == null) continue;
            this.lastLoaderForName.put(string, templateLoader2);
            return new MultiSource(object2, templateLoader2);
        }
        this.lastLoaderForName.remove(string);
        return null;
    }

    public long getLastModified(Object object) {
        return ((MultiSource)object).getLastModified();
    }

    public Reader getReader(Object object, String string) throws IOException {
        return ((MultiSource)object).getReader(string);
    }

    public void closeTemplateSource(Object object) throws IOException {
        ((MultiSource)object).close();
    }

    public void resetState() {
        this.lastLoaderForName.clear();
        for (int i = 0; i < this.loaders.length; ++i) {
            TemplateLoader templateLoader = this.loaders[i];
            if (!(templateLoader instanceof StatefulTemplateLoader)) continue;
            ((StatefulTemplateLoader)templateLoader).resetState();
        }
    }

    private static final class MultiSource {
        private final Object source;
        private final TemplateLoader loader;

        MultiSource(Object object, TemplateLoader templateLoader) {
            this.source = object;
            this.loader = templateLoader;
        }

        long getLastModified() {
            return this.loader.getLastModified(this.source);
        }

        Reader getReader(String string) throws IOException {
            return this.loader.getReader(this.source, string);
        }

        void close() throws IOException {
            this.loader.closeTemplateSource(this.source);
        }

        public boolean equals(Object object) {
            if (object instanceof MultiSource) {
                MultiSource multiSource = (MultiSource)object;
                return multiSource.loader.equals(this.loader) && multiSource.source.equals(this.source);
            }
            return false;
        }

        public int hashCode() {
            return this.loader.hashCode() + 31 * this.source.hashCode();
        }

        public String toString() {
            return this.source.toString();
        }
    }
}

