/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorage;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class MruCacheStorage
implements CacheStorage {
    private final MruEntry strongHead = new MruEntry();
    private final MruEntry softHead = new MruEntry();
    private final Map map;
    private final ReferenceQueue refQueue;
    private final int maxStrongSize;
    private final int maxSoftSize;
    private int strongSize;
    private int softSize;

    public MruCacheStorage(int n, int n2) {
        this.softHead.linkAfter(this.strongHead);
        this.map = new HashMap();
        this.refQueue = new ReferenceQueue();
        this.strongSize = 0;
        this.softSize = 0;
        if (n < 0) {
            throw new IllegalArgumentException("maxStrongSize < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("maxSoftSize < 0");
        }
        this.maxStrongSize = n;
        this.maxSoftSize = n2;
    }

    public Object get(Object object) {
        this.removeClearedReferences();
        MruEntry mruEntry = (MruEntry)this.map.get(object);
        if (mruEntry == null) {
            return null;
        }
        this.relinkEntryAfterStrongHead(mruEntry, null);
        Object object2 = mruEntry.getValue();
        if (object2 instanceof MruReference) {
            return ((MruReference)object2).get();
        }
        return object2;
    }

    public void put(Object object, Object object2) {
        this.removeClearedReferences();
        MruEntry mruEntry = (MruEntry)this.map.get(object);
        if (mruEntry == null) {
            mruEntry = new MruEntry(object, object2);
            this.map.put(object, mruEntry);
            this.linkAfterStrongHead(mruEntry);
        } else {
            this.relinkEntryAfterStrongHead(mruEntry, object2);
        }
    }

    public void remove(Object object) {
        this.removeClearedReferences();
        this.removeInternal(object);
    }

    private void removeInternal(Object object) {
        MruEntry mruEntry = (MruEntry)this.map.remove(object);
        if (mruEntry != null) {
            this.unlinkEntryAndInspectIfSoft(mruEntry);
        }
    }

    public void clear() {
        this.strongHead.makeHead();
        this.softHead.linkAfter(this.strongHead);
        this.map.clear();
        this.softSize = 0;
        this.strongSize = 0;
        while (this.refQueue.poll() != null) {
        }
    }

    private void relinkEntryAfterStrongHead(MruEntry mruEntry, Object object) {
        if (this.unlinkEntryAndInspectIfSoft(mruEntry) && object == null) {
            MruReference mruReference = (MruReference)mruEntry.getValue();
            Object t = mruReference.get();
            if (t != null) {
                mruEntry.setValue(t);
                this.linkAfterStrongHead(mruEntry);
            } else {
                this.map.remove(mruReference.getKey());
            }
        } else {
            if (object != null) {
                mruEntry.setValue(object);
            }
            this.linkAfterStrongHead(mruEntry);
        }
    }

    private void linkAfterStrongHead(MruEntry mruEntry) {
        mruEntry.linkAfter(this.strongHead);
        if (this.strongSize == this.maxStrongSize) {
            MruEntry mruEntry2 = this.softHead.getPrevious();
            if (mruEntry2 != this.strongHead) {
                mruEntry2.unlink();
                if (this.maxSoftSize > 0) {
                    mruEntry2.linkAfter(this.softHead);
                    mruEntry2.setValue(new MruReference(mruEntry2, this.refQueue));
                    if (this.softSize == this.maxSoftSize) {
                        MruEntry mruEntry3 = this.strongHead.getPrevious();
                        mruEntry3.unlink();
                        this.map.remove(mruEntry3.getKey());
                    } else {
                        ++this.softSize;
                    }
                } else {
                    this.map.remove(mruEntry2.getKey());
                }
            }
        } else {
            ++this.strongSize;
        }
    }

    private boolean unlinkEntryAndInspectIfSoft(MruEntry mruEntry) {
        mruEntry.unlink();
        if (mruEntry.getValue() instanceof MruReference) {
            --this.softSize;
            return true;
        }
        --this.strongSize;
        return false;
    }

    private void removeClearedReferences() {
        MruReference mruReference;
        while ((mruReference = (MruReference)this.refQueue.poll()) != null) {
            this.removeInternal(mruReference.getKey());
        }
    }

    private static final class MruEntry {
        private MruEntry prev;
        private MruEntry next;
        private final Object key;
        private Object value;

        MruEntry() {
            this.makeHead();
            this.value = null;
            this.key = null;
        }

        MruEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        Object getKey() {
            return this.key;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object object) {
            this.value = object;
        }

        MruEntry getPrevious() {
            return this.prev;
        }

        void linkAfter(MruEntry mruEntry) {
            this.next = mruEntry.next;
            mruEntry.next = this;
            this.prev = mruEntry;
            this.next.prev = this;
        }

        void unlink() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.prev = null;
            this.next = null;
        }

        void makeHead() {
            this.prev = this.next = this;
        }
    }

    private static class MruReference
    extends SoftReference {
        private final Object key;

        MruReference(MruEntry mruEntry, ReferenceQueue referenceQueue) {
            super(mruEntry.getValue(), referenceQueue);
            this.key = mruEntry.getKey();
        }

        Object getKey() {
            return this.key;
        }
    }
}

