/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import freemarker.template.utility.SecurityUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class FileTemplateLoader
implements TemplateLoader {
    private static final boolean SEP_IS_SLASH = File.separatorChar == '/';
    public final File baseDir;
    private final String canonicalPath;

    public FileTemplateLoader() throws IOException {
        this(new File(SecurityUtilities.getSystemProperty("user.dir")));
    }

    public FileTemplateLoader(final File file) throws IOException {
        try {
            Object[] objectArray = (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Object[] objectArray;
                    if (!file.exists()) {
                        throw new FileNotFoundException(file + " does not exist.");
                    }
                    if (!file.isDirectory()) {
                        throw new IOException(file + " is not a directory.");
                    }
                    objectArray = new Object[]{file.getCanonicalFile(), ((File)objectArray[0]).getPath() + File.separatorChar};
                    return objectArray;
                }
            });
            this.baseDir = (File)objectArray[0];
            this.canonicalPath = (String)objectArray[1];
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public Object findTemplateSource(final String string) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = new File(FileTemplateLoader.this.baseDir, SEP_IS_SLASH ? string : string.replace('/', File.separatorChar));
                    if (!file.isFile()) {
                        return null;
                    }
                    String string2 = file.getCanonicalPath();
                    if (string2.startsWith(FileTemplateLoader.this.canonicalPath)) {
                        return file;
                    }
                    throw new SecurityException(string2 + " doesn't start with " + FileTemplateLoader.this.canonicalPath);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public long getLastModified(final Object object) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(((File)object).lastModified());
            }
        });
    }

    public Reader getReader(final Object object, final String string) throws IOException {
        try {
            return (Reader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (!(object instanceof File)) {
                        throw new IllegalArgumentException("templateSource is a: " + object.getClass().getName());
                    }
                    return new InputStreamReader((InputStream)new FileInputStream((File)object), string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void closeTemplateSource(Object object) {
    }
}

