/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.ots;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.ots.OTSInterceptor;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class OTSServerTransactionInterceptor
extends OTSInterceptor
implements ServerRequestInterceptor {
    private static Current current = null;
    private Map contexts = Collections.synchronizedMap(new HashMap());
    private String interceptorName = "OTSServerTransactionInteceptor";

    public OTSServerTransactionInterceptor(ORBInitInfo oRBInitInfo) {
        super(oRBInitInfo);
    }

    public String name() {
        return this.interceptorName;
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        try {
            TransactionContext transactionContext = this.decodeCorbaPropagationContext(serverRequestInfo.get_request_service_context(0));
            if (transactionContext != null) {
                Integer n = new Integer(serverRequestInfo.request_id());
                this.contexts.put(n, transactionContext);
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
        }
        catch (Exception exception) {
            throw new ForwardRequest();
        }
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            Integer n = new Integer(serverRequestInfo.request_id());
            InternalTransactionContext internalTransactionContext = (InternalTransactionContext)this.contexts.remove(n);
            current.setPropagationContext(internalTransactionContext, false);
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext transactionContext = current.getPropagationContext(true);
                ServiceContext serviceContext = null;
                if (transactionContext != null) {
                    serviceContext = this.buildCorbaPropagationContext(transactionContext);
                    serverRequestInfo.add_reply_service_context(serviceContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext transactionContext = current.getPropagationContext(true);
                ServiceContext serviceContext = null;
                if (transactionContext != null) {
                    serviceContext = this.buildCorbaPropagationContext(transactionContext);
                    serverRequestInfo.add_reply_service_context(serviceContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void destroy() {
    }
}

