/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.jta.jeremie;

import org.objectweb.jeremie.services.handler.api.Service;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.helpers.MessageHelpers;
import org.objectweb.jonathan.presentation.api.Marshaller;
import org.objectweb.jonathan.presentation.api.MarshallerFactory;
import org.objectweb.jonathan.presentation.api.UnMarshaller;
import org.objectweb.jonathan.resources.api.Chunk;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.jta.jeremie.JotmTransactionReceiver;
import org.objectweb.jotm.jta.jeremie.JotmTransactionSender;
import org.omg.IOP.ServiceContext;

public class TSHandler
implements Service {
    private JotmTransactionSender sender = null;
    private JotmTransactionReceiver receiver = null;
    private MarshallerFactory mf;
    private int service_id = 0;

    public TSHandler(Context context, Object[] objectArray) throws JonathanException {
        int n = (Integer)objectArray[0];
        if (n != Integer.MAX_VALUE) {
            this.service_id = n;
        }
        try {
            this.sender = (JotmTransactionSender)objectArray[1];
            this.receiver = (JotmTransactionReceiver)objectArray[2];
            this.mf = (MarshallerFactory)objectArray[3];
        }
        catch (Exception exception) {
            throw new JonathanException(exception);
        }
    }

    public ServiceContext getRequestContext(int n, boolean bl, byte[] byArray, Context context) {
        if (this.sender == null) {
            return null;
        }
        TransactionContext transactionContext = this.sender.sending_request();
        return this.encodeContext(transactionContext);
    }

    public ServiceContext getReplyContext(int n, Context context) {
        if (this.receiver == null) {
            return null;
        }
        TransactionContext transactionContext = this.receiver.sending_reply();
        return this.encodeContext(transactionContext);
    }

    public void handleRequestContext(ServiceContext serviceContext, int n, boolean bl, byte[] byArray, Context context) {
        if (this.receiver == null || serviceContext == null) {
            return;
        }
        TransactionContext transactionContext = this.decodeContext(serviceContext);
        if (transactionContext != null) {
            this.receiver.received_request(transactionContext);
        }
    }

    public void handleReplyContext(ServiceContext serviceContext, int n, Context context) {
        if (this.sender == null || serviceContext == null) {
            return;
        }
        TransactionContext transactionContext = this.decodeContext(serviceContext);
        if (transactionContext != null) {
            this.sender.received_reply(transactionContext);
        }
    }

    private ServiceContext encodeContext(TransactionContext transactionContext) {
        if (transactionContext == null) {
            return null;
        }
        Marshaller marshaller = this.mf.newMarshaller();
        byte[] byArray = null;
        try {
            marshaller.writeValue((Object)transactionContext);
            byArray = MessageHelpers.copy((Marshaller)marshaller);
            marshaller.close();
        }
        catch (Exception exception) {
            System.err.println("TSHandler.encodeContext: exception");
        }
        return new ServiceContext(this.service_id, byArray);
    }

    private TransactionContext decodeContext(ServiceContext serviceContext) {
        if (serviceContext == null || serviceContext.context_data == null || serviceContext.context_data.length == 0) {
            return null;
        }
        TransactionContext transactionContext = null;
        byte[] byArray = serviceContext.context_data;
        UnMarshaller unMarshaller = this.mf.newUnMarshaller(new Chunk(byArray, 0, byArray.length), 0);
        try {
            transactionContext = (TransactionContext)unMarshaller.readValue();
            unMarshaller.close();
        }
        catch (Exception exception) {
            System.err.println("TSHandler.decodeContext: exception");
            System.err.println(exception.toString() + "\n");
        }
        return transactionContext;
    }
}

