/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.Xid;

public class XidImpl
implements Xid,
Serializable {
    public static final int JOTM_FORMAT_ID = 47892;
    private static SecureRandom rand = null;
    private final byte internalVersId = 1;
    private static int count = 1;
    private static long uuid0;
    private static long uuid1;
    private static boolean uuidsRecovered;
    private static byte[] gtrid_base;
    private static String host;
    private static String server;
    private String fullString = "";
    private String shortString = "";
    private boolean hashcodevalid = false;
    private int myhashcode;
    static String[] HexDigits;
    private int formatId;
    private int gtrid_length;
    private int bqual_length;
    private byte[] gtrid;
    private byte[] bqual;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XidImpl(String string, int n) {
        long l;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("serverName=" + string + ", ipAddr=" + n));
        }
        this.formatId = 47892;
        int n2 = 0;
        Object object = this.getClass();
        synchronized (object) {
            l = System.currentTimeMillis() * 1024L + (long)count;
            ++count;
        }
        object = Long.toHexString(n2) + Long.toHexString(l) + "_" + Long.toHexString(n) + "_" + string;
        if (((String)object).length() > 64) {
            object = ((String)object).substring(0, 64);
        }
        this.gtrid = ((String)object).getBytes();
        this.gtrid_length = this.gtrid.length;
        this.bqual = ((String)object).getBytes();
        this.bqual_length = this.bqual.length;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("Xid (uuid= " + Long.toHexString(l) + ")"));
        }
    }

    public XidImpl(int n, int n2, byte[] byArray) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"constructor from otid_t");
        }
        this.formatId = n;
        int n3 = byArray.length - n2;
        this.gtrid = new byte[n3];
        System.arraycopy(byArray, n2, this.gtrid, 0, n3);
        this.bqual = new byte[n2];
        System.arraycopy(byArray, 0, this.bqual, 0, n2);
        this.gtrid_length = n3;
        this.bqual_length = n2;
    }

    public XidImpl(int n, byte[] byArray, byte[] byArray2) {
        this.formatId = n;
        this.gtrid = byArray;
        this.bqual = byArray2;
        this.gtrid_length = byArray.length;
        this.bqual_length = byArray2.length;
    }

    public XidImpl() {
        this.formatId = 47892;
        this.gtrid = this.makeGtrid();
        this.gtrid_length = this.gtrid.length;
        this.bqual = new byte[0];
        this.bqual_length = this.bqual.length;
    }

    public XidImpl(Xid xid, int n) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("old XID= " + xid));
            TraceTm.jotm.debug((Object)("index= " + n));
        }
        this.formatId = xid.getFormatId();
        this.gtrid = xid.getGlobalTransactionId();
        this.makeGtridBase();
        this.gtrid_length = this.gtrid.length;
        this.bqual = new byte[64];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bqual);
        byteBuffer.put(gtrid_base);
        byteBuffer.putLong(0L);
        byteBuffer.putLong((long)n + 0L);
        this.bqual_length = this.bqual.length;
    }

    public XidImpl(ByteBuffer byteBuffer) {
        byte by;
        byte by2;
        int n;
        byte by3 = byteBuffer.get();
        while (by3 != 58) {
            this.formatId = this.formatId * 16 + (by3 - (by3 > 96 ? 87 : 48));
            by3 = byteBuffer.get();
        }
        by3 = byteBuffer.get();
        while (by3 != 58) {
            this.gtrid_length = this.gtrid_length * 16 + (by3 - (by3 > 96 ? 87 : 48));
            by3 = byteBuffer.get();
        }
        by3 = byteBuffer.get();
        while (by3 != 58) {
            this.bqual_length = this.bqual_length * 16 + (by3 - (by3 > 96 ? 87 : 48));
            by3 = byteBuffer.get();
        }
        this.gtrid = new byte[this.gtrid_length];
        this.bqual = new byte[this.bqual_length];
        for (n = 0; n <= this.gtrid_length - 1; ++n) {
            by2 = byteBuffer.get();
            by = byteBuffer.get();
            this.gtrid[n] = (byte)(16 * (by2 - (by2 > 96 ? 87 : 48)) + (by - (by > 96 ? 87 : 48)));
        }
        if (byteBuffer.get() != 58 && TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)" XXXX  XidByteArray alignment is bad! XXX ");
        }
        for (n = 0; n <= this.bqual_length - 1; ++n) {
            by2 = byteBuffer.get();
            by = byteBuffer.get();
            this.bqual[n] = (byte)(16 * (by2 - (by2 > 96 ? 87 : 48)) + (by - (by > 96 ? 87 : 48)));
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Rebuilt Xid: " + this.toString(true)));
        }
    }

    public XidImpl(byte[] byArray) {
        byte by;
        byte by2;
        int n;
        int n2 = 0;
        byte by3 = byArray[n2];
        while (by3 != 58) {
            this.formatId = this.formatId * 16 + (by3 - (by3 > 96 ? 87 : 48));
            by3 = byArray[++n2];
        }
        by3 = byArray[++n2];
        while (by3 != 58) {
            this.gtrid_length = this.gtrid_length * 16 + (by3 - (by3 > 96 ? 87 : 48));
            by3 = byArray[++n2];
        }
        by3 = byArray[++n2];
        while (by3 != 58) {
            this.bqual_length = this.bqual_length * 16 + (by3 - (by3 > 96 ? 87 : 48));
            by3 = byArray[++n2];
        }
        this.gtrid = new byte[this.gtrid_length];
        this.bqual = new byte[this.bqual_length];
        for (n = 0; n <= this.gtrid_length - 1; ++n) {
            by2 = byArray[++n2];
            by = byArray[++n2];
            this.gtrid[n] = (byte)(16 * (by2 - (by2 > 96 ? 87 : 48)) + (by - (by > 96 ? 87 : 48)));
        }
        if ((by3 = byArray[++n2]) != 58 && TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)" XXXX  XidByteArray alignment is bad! XXX ");
        }
        for (n = 0; n <= this.bqual_length - 1; ++n) {
            by2 = byArray[++n2];
            by = byArray[++n2];
            this.bqual[n] = (byte)(16 * (by2 - (by2 > 96 ? 87 : 48)) + (by - (by > 96 ? 87 : 48)));
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Rebuilt Xid: " + this.toString(true)));
        }
    }

    public XidImpl(javax.transaction.xa.Xid xid) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("passed XID= " + xid));
        }
        this.formatId = xid.getFormatId();
        this.gtrid = xid.getGlobalTransactionId();
        this.gtrid_length = this.gtrid.length;
        this.bqual = xid.getBranchQualifier();
        this.bqual_length = this.bqual.length;
    }

    public static void setUuids(long l, long l2) {
        uuid0 = l;
        uuid1 = l2;
        uuidsRecovered = true;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("uuids recovered; uuid0:" + uuid0 + " uuid1:" + uuid1));
        }
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    static final void byteToHex(byte by, StringBuffer stringBuffer) {
        int n = 0xFF & by;
        stringBuffer.append(HexDigits[n]);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (bl && this.fullString.length() != 0) {
            return this.fullString;
        }
        if (!bl && this.shortString.length() != 0) {
            return this.shortString;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        byArray = new byte[64];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        System.arraycopy(this.gtrid, 0, byArray, 0, this.gtrid_length);
        for (int i = 0; i < this.gtrid_length; ++i) {
            XidImpl.byteToHex(byteBuffer.get(), stringBuffer);
        }
        byArray2 = new byte[64];
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        if (this.bqual != null) {
            System.arraycopy(this.bqual, 0, byArray2, 0, this.bqual_length);
            for (n = 0; n < this.bqual_length; ++n) {
                XidImpl.byteToHex(byteBuffer2.get(), stringBuffer2);
            }
        }
        if (this.gtrid_length > 30 && !bl) {
            n = stringBuffer.length();
            stringBuffer.replace(n / 6, n / 6 + 2, "...");
            stringBuffer.delete(n / 6 + 3, n - 5);
        }
        if (this.bqual_length > 30 && !bl) {
            n = stringBuffer2.length();
            stringBuffer2.replace(n / 6, n / 6 + 2, "...");
            stringBuffer2.delete(n / 6 + 3, n - 5);
        }
        if (bl) {
            this.fullString = Long.toHexString(this.formatId) + ":" + Long.toHexString(this.gtrid_length) + ":" + Long.toHexString(this.bqual_length) + ":" + stringBuffer.toString() + ":" + stringBuffer2.toString();
            return this.fullString;
        }
        this.shortString = Long.toHexString(this.formatId) + ":" + Long.toHexString(this.gtrid_length) + ":" + Long.toHexString(this.bqual_length) + ":" + stringBuffer.toString() + ":" + stringBuffer2.toString();
        return this.shortString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] makeGtrid() {
        long l;
        this.makeGtridBase();
        Object object = this.getClass();
        synchronized (object) {
            l = System.currentTimeMillis() * 1024L + (long)count;
            ++count;
        }
        object = ByteBuffer.allocate(gtrid_base.length + 8);
        ((ByteBuffer)object).put(gtrid_base);
        ((ByteBuffer)object).putLong(l);
        return ((ByteBuffer)object).array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeGtridBase() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (rand == null) {
                ByteBuffer byteBuffer;
                rand = new SecureRandom();
                if (!uuidsRecovered) {
                    uuid0 = rand.nextLong();
                    uuid1 = rand.nextLong();
                    byteBuffer = null;
                    byte[] byArray = new byte[19];
                    byte[][] byArray2 = new byte[1][19];
                    String string = "RU1";
                    ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
                    byteBuffer2.put(string.getBytes());
                    byteBuffer2.putLong(uuid0);
                    byteBuffer2.putLong(uuid1);
                    byArray2[0] = byArray;
                    if (Current.getDefaultRecovery()) {
                        try {
                            byteBuffer = TransactionRecoveryImpl.getTransactionRecovery().howlCommitLog(byArray2);
                        }
                        catch (Exception exception) {
                            String string2 = "Cannot howlCommitLog:" + exception + " --" + exception.getMessage();
                            TraceTm.recovery.error((Object)("Got LogException from howlCommitLog writing UniqueIDRecord: " + string2));
                        }
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug((Object)("Wrote UniqueIDRecord; at:" + byteBuffer.getLogKey() + " uuid0:" + uuid0 + " uuid1:" + uuid1));
                        }
                    }
                }
                host = "";
                server = "";
                host = (host + "                ").substring(0, 15);
                server = (server + "               ").substring(0, 14);
                gtrid_base = new byte[48];
                byteBuffer = ByteBuffer.wrap(gtrid_base);
                byteBuffer.put((byte)1);
                byteBuffer.putLong(uuid0);
                byteBuffer.putLong(uuid1);
                byteBuffer.put(host.getBytes());
                byteBuffer.put(server.getBytes());
            }
        }
    }

    public boolean IsThisOneOfOurs(byte[] byArray) {
        if (rand == null) {
            this.makeGtrid();
        }
        boolean bl = false;
        if (byArray != null && byArray.length >= gtrid_base.length) {
            byte[] byArray2;
            if (byArray.length == gtrid_base.length) {
                byArray2 = gtrid_base;
            } else {
                byArray2 = new byte[gtrid_base.length];
                System.arraycopy(gtrid_base, 0, byArray2, 0, gtrid_base.length);
            }
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            StringBuffer stringBuffer = new StringBuffer(gtrid_base.length * 2);
            StringBuffer stringBuffer2 = new StringBuffer(gtrid_base.length * 2);
            byArray3 = new byte[gtrid_base.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
            System.arraycopy(gtrid_base, 0, byArray3, 0, gtrid_base.length);
            for (int i = 0; i < gtrid_base.length; ++i) {
                XidImpl.byteToHex(byteBuffer.get(), stringBuffer2);
            }
            byArray4 = new byte[gtrid_base.length];
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray3);
            System.arraycopy(byArray, 0, byArray4, 0, gtrid_base.length);
            for (int i = 0; i < gtrid_base.length; ++i) {
                XidImpl.byteToHex(byteBuffer2.get(), stringBuffer);
            }
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)("gtrid_or_bqual= " + stringBuffer));
                TraceTm.jotm.debug((Object)("gbase=          " + stringBuffer2));
            }
            if (stringBuffer.toString().equals(stringBuffer2.toString())) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        XidImpl xidImpl = (XidImpl)object;
        return this.formatId == xidImpl.getFormatId() && Arrays.equals(this.bqual, xidImpl.getBranchQualifier()) && Arrays.equals(this.gtrid, xidImpl.getGlobalTransactionId());
    }

    public int hashCode() {
        int n = 0;
        if (!this.hashcodevalid) {
            int n2;
            for (n2 = 0; n2 < this.gtrid.length; ++n2) {
                n = n * 37 + this.gtrid[n2];
            }
            for (n2 = 0; n2 < this.bqual.length; ++n2) {
                n = n * 37 + this.bqual[n2];
            }
            this.myhashcode = n;
            this.hashcodevalid = true;
        }
        return this.myhashcode;
    }

    static {
        uuidsRecovered = false;
        gtrid_base = null;
        HexDigits = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};
    }
}

