/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.howl.log.xa.XALogger;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.JotmRecovery;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionResourceManager;

public class TransactionRecoveryImpl
implements TransactionRecovery {
    private static transient TransactionRecoveryImpl unique = null;
    private static transient Map nameResourceManager = Collections.synchronizedMap(new HashMap());
    private static transient Map nameXAResource = Collections.synchronizedMap(new HashMap());
    private static transient JotmRecovery tmrecovery = null;
    private static transient boolean startrecoverycalled = false;
    private static transient XALogger xaLog = null;
    private static transient XACommittingTx rmCommitTx = null;
    private static transient Vector vRmRegistration = new Vector();
    private RmRegistration myrmRegistration = null;
    private static final String JOTM_BASE = "jotm.base";
    private static final String JONAS_BASE = "jonas.base";
    private static final String CONFIG_DIR = "conf";
    private static Properties systEnv = System.getProperties();
    private static String jonasBase = systEnv.getProperty("jonas.base");
    private static String jotmBase = systEnv.getProperty("jotm.base");
    private static String fileSeparator = systEnv.getProperty("file.separator");

    public TransactionRecoveryImpl() throws LogException, IOException, Exception {
        Object object;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"TransactionRecoveryImpl constructor");
        }
        unique = this;
        String string = null;
        if (jonasBase == null) {
            if (jotmBase == null) {
                if (!Current.getDefaultRecovery()) {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
                    }
                    return;
                }
            } else {
                string = jotmBase;
            }
        } else {
            string = jonasBase;
        }
        string = string.trim();
        String string2 = string + fileSeparator + CONFIG_DIR + fileSeparator + "jotm.properties";
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("JOTM properties file= " + string2));
        }
        Properties properties = new Properties();
        try {
            object = new FileInputStream(string2);
            systEnv.load((InputStream)object);
        }
        catch (Exception exception) {
            Current.setDefaultRecovery(false);
            return;
        }
        if (systEnv.getProperty("jotm.recovery.Enabled").trim().equalsIgnoreCase("true")) {
            Current.setDefaultRecovery(true);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is enabled");
            }
        } else {
            Current.setDefaultRecovery(false);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
            }
            return;
        }
        object = null;
        object = systEnv.getProperty("howl.log.ListConfiguration", "false");
        properties.put("listConfig", object);
        object = systEnv.getProperty("howl.log.BufferSize", "4");
        properties.put("bufferSize", object);
        object = systEnv.getProperty("howl.log.MinimumBuffers", "16");
        properties.put("minBuffers", object);
        object = systEnv.getProperty("howl.log.MaximumBuffers", "16");
        properties.put("maxBuffers", object);
        object = systEnv.getProperty("howl.log.MaximumBlocksPerFile", "200");
        properties.put("maxBlocksPerFile", object);
        object = systEnv.getProperty("howl.log.FileDirectory", systEnv.getProperty("basedir", "."));
        properties.put("logFileDir", object);
        object = systEnv.getProperty("howl.log.FileName", "howl");
        properties.put("logFileName", object);
        object = systEnv.getProperty("howl.log.MaximumFiles", "2");
        properties.put("maxLogFiles", object);
        try {
            this.howlOpenLog(properties);
        }
        catch (Exception exception) {
            TraceTm.jotm.warn((Object)("howlOpenLog: LogException occured in howlOpenLog() " + exception.getMessage()));
            Current.setDefaultRecovery(false);
            TraceTm.recovery.warn((Object)"JOTM Recovery is disabled");
            return;
        }
    }

    public static TransactionRecoveryImpl getTransactionRecovery() {
        return unique;
    }

    public JotmRecovery getJotmRecovery() {
        return tmrecovery;
    }

    public Vector getRmRegistration() {
        return vRmRegistration;
    }

    public void registerResourceManager(String string, XAResource xAResource, String string2, Properties properties, TransactionResourceManager transactionResourceManager) throws XAException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Register Resource Manager Properties " + string + properties + " to Connection " + xAResource));
        }
        this.registerResourceManager(string, xAResource, string2, transactionResourceManager);
    }

    public void registerResourceManager(String string, XAResource xAResource, String string2, TransactionResourceManager transactionResourceManager) throws XAException {
        if (transactionResourceManager != null) {
            transactionResourceManager.returnXAResource(string, xAResource);
        }
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Register Resource Manager " + string + " to Connection " + xAResource));
        }
        XAResource xAResource2 = null;
        String string3 = new String(string);
        Object v = nameResourceManager.get(string3);
        if (v == null) {
            nameResourceManager.put(string3, xAResource);
        } else {
            xAResource2 = (XAResource)v;
            if (xAResource2.equals(xAResource)) {
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)(string + " already registered"));
                    return;
                }
            } else {
                nameResourceManager.put(string3, xAResource);
            }
        }
        this.myrmRegistration = new RmRegistration();
        this.myrmRegistration.rmAddRegistration(string, xAResource, xAResource.getClass().getName());
        vRmRegistration.addElement(this.myrmRegistration);
        if (startrecoverycalled) {
            try {
                this.startResourceManagerRecovery();
            }
            catch (XAException xAException) {
                throw new XAException("startResourceManagerRecovery failed" + xAException.getMessage());
            }
        }
    }

    public XAResource reportResourceManager(String string) throws XAException {
        String string2;
        XAResource xAResource;
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
            }
            return null;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("get Connection from Resource Manager " + string));
        }
        if ((xAResource = (XAResource)nameResourceManager.get(string2 = new String(string))) == null) {
            throw new XAException("Named Resource Manager " + string + " does not exist");
        }
        return xAResource;
    }

    public void unregisterResourceManager(String string, XAResource xAResource) throws XAException {
        String string2;
        XAResource xAResource2;
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Remove Resource Manager " + string + " from Connection " + xAResource));
        }
        if (!(xAResource2 = (XAResource)nameResourceManager.get(string2 = new String(string))).equals(xAResource)) {
            throw new XAException("Resource Manager " + string + " not associated to " + xAResource);
        }
        nameResourceManager.remove(string2);
    }

    public void startResourceManagerRecovery() throws XAException {
        String string;
        Object object;
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
            }
            return;
        }
        int n = vRmRegistration.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("LogResourceManager count= " + n));
        }
        if (n == 0) {
            return;
        }
        XACommittingTx xACommittingTx = null;
        byte[][] byArrayArray = new byte[n + 1][];
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string2 = "RM1";
        String string3 = "RM2";
        long l = System.currentTimeMillis();
        byArray = new byte[15];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.put(string2.getBytes());
        byteBuffer.putLong(l);
        byteBuffer.putInt(n);
        byArrayArray[0] = byteBuffer.array();
        for (int i = 0; i < n; ++i) {
            this.myrmRegistration = (RmRegistration)vRmRegistration.elementAt(i);
            object = this.myrmRegistration.rmGetName();
            XAResource xAResource = this.myrmRegistration.rmGetXaRes();
            string = this.myrmRegistration.rmGetXaResName();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("LogResourceManager rmName= " + (String)object));
                TraceTm.recovery.debug((Object)("    xaRes= " + string));
                TraceTm.recovery.debug((Object)("    rmIndex= " + i));
            }
            int n2 = ((String)object).length();
            int n3 = xAResource.toString().length();
            int n4 = string.length();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("rm length=" + n2));
                TraceTm.recovery.debug((Object)("xaRes length= " + n3));
            }
            byArray2 = new byte[7 + n2 + 4 + n3 + 4 + n4 + 4];
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
            byteBuffer2.put(string3.getBytes());
            byteBuffer2.putInt(n2);
            byteBuffer2.put(((String)object).getBytes());
            byteBuffer2.putInt(n3);
            byteBuffer2.put(xAResource.toString().getBytes());
            byteBuffer2.putInt(n4);
            byteBuffer2.put(string.getBytes());
            byteBuffer2.putInt(i);
            byArrayArray[i + 1] = byteBuffer2.array();
        }
        try {
            xACommittingTx = this.howlCommitLog(byArrayArray);
        }
        catch (Exception exception) {
            object = "Cannot howlCommitLog:" + exception + " --" + exception.getMessage();
            TraceTm.jotm.error((Object)("Got LogException from howlCommitLog: " + (String)object));
            rmCommitTx = null;
            throw new XAException((String)object);
        }
        if (rmCommitTx != null) {
            byte[] byArray3 = new byte[11];
            object = new byte[1][11];
            byArray3 = "RM3JOTMDONE".getBytes();
            try {
                object[0] = byArray3;
                this.howlDoneLog((byte[][])object, rmCommitTx);
            }
            catch (Exception exception) {
                string = "Cannot howlDoneLog:" + exception + "--" + exception.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + string));
            }
        }
        rmCommitTx = xACommittingTx;
        try {
            this.recoverResourceManager();
        }
        catch (XAException xAException) {
            throw new XAException("Cannot perform recovery " + xAException.getMessage());
        }
        startrecoverycalled = true;
    }

    public void recoverResourceManager() throws XAException {
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"recoverResourceManager");
        }
        if (vRmRegistration.size() == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Nothing to recover");
            }
            return;
        }
        try {
            tmrecovery.recoverTransactions(vRmRegistration);
        }
        catch (XAException xAException) {
            throw new XAException("Unable to recover transactions" + xAException.getMessage());
        }
    }

    synchronized void howlOpenLog(Properties properties) throws SystemException {
        Object object;
        if (xaLog != null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Howl Log already opened");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"Open howl log");
        }
        try {
            object = new Configuration(properties);
            xaLog = new XALogger(object);
        }
        catch (LogConfigurationException logConfigurationException) {
            TraceTm.jotm.error((Object)"XALogger: LogConfigurationException");
            throw new SystemException("LogConfigurationException occured in XALogger() " + logConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            TraceTm.jotm.error((Object)"XALogger: IOException");
            throw new SystemException("IOException occured in XALogger() " + iOException.getMessage());
        }
        catch (Exception exception) {
            TraceTm.jotm.error((Object)"XALogger: Exception");
            throw new SystemException("Exeception occurred in XALogger() " + exception.getMessage());
        }
        tmrecovery = new JotmRecovery();
        object = new xaReplayListener();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"xaLog.open");
        }
        try {
            xaLog.open(null);
        }
        catch (LogException logException) {
            TraceTm.jotm.error((Object)"xaLog.open: LogException");
            throw new SystemException("LogException occured in xaLog.open() " + logException.getMessage());
        }
        catch (IOException iOException) {
            TraceTm.jotm.error((Object)"xaLog.open: IOException");
            throw new SystemException("IOException occured in xaLog.open() " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            TraceTm.jotm.error((Object)"xaLog.open: InterruptedException");
            throw new SystemException("InterruptedException occured in xaLog.open() " + interruptedException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            TraceTm.jotm.error((Object)"xaLog.open: ClassNotFoundException");
            throw new SystemException("ClassNotFoundException occured in xaLog.open() " + classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            TraceTm.jotm.error((Object)("xaLog.open: Exception " + exception.getMessage()));
            throw new SystemException("Exception occurred in xaLog.open() " + exception.getMessage());
        }
        xaLog.replayActiveTx((ReplayListener)object);
    }

    void howlCloseLog() throws SystemException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"Close howl log");
        }
        if (xaLog == null) {
            return;
        }
        try {
            xaLog.close();
        }
        catch (IOException iOException) {
            TraceTm.jotm.error((Object)"xaLog.close: IOException");
            throw new SystemException("IOException occured in xaLog.close() " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            TraceTm.jotm.error((Object)"xaLog.close: InterruptedException");
            throw new SystemException("InterruptedException occured in xaLog.close() " + interruptedException.getMessage());
        }
        xaLog = null;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"Howl log closed");
        }
    }

    public XACommittingTx howlCommitLog(byte[][] byArray) throws LogException, Exception {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"Commit howl log");
        }
        return xaLog.putCommit(byArray);
    }

    public void howlDoneLog(byte[][] byArray, XACommittingTx xACommittingTx) throws LogException, Exception {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"Done howl log");
        }
        xaLog.putDone(byArray, xACommittingTx);
    }

    public void forget() throws LogException, Exception {
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"JOTM Recovery is disabled");
            }
        } else {
            this.howlCloseLog();
        }
    }

    private class xaReplayListener
    implements ReplayListener {
        private xaReplayListener() {
        }

        public void onRecord(LogRecord logRecord) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("LogRecord type= " + logRecord.type));
            }
            switch (logRecord.type) {
                case 19979: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug((Object)"Howl End of Buffer Record");
                    break;
                }
                case 19983: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug((Object)"Howl End of Log Record");
                    break;
                }
                case 16512: {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"Howl XA Commit Record");
                    }
                    tmrecovery.rebuildTransaction((XALogRecord)logRecord);
                    break;
                }
                case 16448: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug((Object)"Howl XA Done Record");
                    break;
                }
                case 0: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug((Object)"Howl User Record");
                    break;
                }
                default: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug((Object)"Unknown Howl LogRecord");
                }
            }
        }

        public void onError(LogException logException) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"onError");
            }
        }

        public LogRecord getLogRecord() {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"getLogRecord");
            }
            return new XALogRecord(120);
        }
    }
}

