/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicMixed;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.JavaXidImpl;
import org.objectweb.jotm.RecoveryCoordinator;
import org.objectweb.jotm.SubCoordinator;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.XAResourceHelper;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class TransactionImpl
implements Transaction,
TimerEventListener {
    private SubCoordinator subcoord = null;
    private TransactionContext myCtx = null;
    private Xid myXid = null;
    private boolean genXidhashcode = false;
    private boolean genXidtostring = false;
    private int myXidhashcode = 0;
    private String myXidtostring = null;
    private String txDate = null;
    private boolean interpose = false;
    private int ucount = 0;
    private TimerEvent timer = null;
    private RecoveryCoordinator recoveryCoord = null;
    private List enlistedXARes = Collections.synchronizedList(new ArrayList());
    private List delistedXARes = null;
    private boolean propagateCtx = true;
    private List enlistedJavaxXid = Collections.synchronizedList(new ArrayList());
    static /* synthetic */ Class class$org$objectweb$jotm$Coordinator;

    public TransactionImpl(Xid xid, int n) throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xid= " + xid));
            TraceTm.jta.debug((Object)("timeout= " + n));
        }
        this.myXid = xid;
        this.myCtx = new InternalTransactionContext(n, null, xid);
    }

    public TransactionImpl(TransactionContext transactionContext) {
        if (transactionContext == null) {
            TraceTm.jotm.error((Object)"TransactionImpl: null PropagationContext");
        }
        this.myCtx = transactionContext;
        this.myXid = transactionContext.getXid();
        this.interpose = true;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        Terminator terminator;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.commit (tx= " + this + ")"));
        }
        if ((terminator = this.myCtx.getTerminator()) != null) {
            try {
                this.propagateCtx = false;
                terminator.commit(true);
                this.propagateCtx = true;
            }
            catch (TransactionRolledbackException transactionRolledbackException) {
                Current.getCurrent().forgetTx(this.getXid());
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!");
                }
                throw new RollbackException();
            }
            catch (RemoteException remoteException) {
                if (TraceTm.jta.isWarnEnabled()) {
                    TraceTm.jta.warn((Object)"got a RemoteException", (Throwable)remoteException);
                }
                if (remoteException.detail instanceof TransactionRolledbackException) {
                    Current.getCurrent().forgetTx(this.getXid());
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!");
                    }
                    throw new RollbackException();
                }
                if (remoteException.detail instanceof HeuristicMixed) {
                    TraceTm.jotm.info((Object)"Commit distributed transaction -> Heuristic mixed!");
                    throw new HeuristicMixedException();
                }
                throw new SystemException("Unexpected RemoteException on commit:" + remoteException.detail.getMessage());
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit:", (Throwable)exception);
                throw new SystemException("Unexpected Exception on commit");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.commit_one_phase();
            }
            catch (TransactionRolledbackException transactionRolledbackException) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"Commit local transaction -> rolled back!");
                }
                Current.getCurrent().forgetTx(this.getXid());
                throw new RollbackException();
            }
            catch (RemoteException remoteException) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit_one_phase:", (Throwable)remoteException);
                Current.getCurrent().forgetTx(this.getXid());
                throw new SystemException("Unexpected Exception on commit_one_phase");
            }
        } else {
            this.unsetTimer();
            Current.getCurrent().forgetTx(this.getXid());
        }
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.delistResource");
            TraceTm.jta.debug((Object)("xares= " + xAResource + ", flag= " + n));
        }
        if (this.enlistedXARes == null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)"No XA resources enlisted by JOTM");
            }
            return false;
        }
        if (!this.enlistedXARes.contains(xAResource)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)("XAResouce " + xAResource + " not enlisted by JOTM"));
            }
            return false;
        }
        XidImpl xidImpl = new XidImpl(this.getXid(), this.subcoord.getXaresIndex(xAResource));
        javax.transaction.xa.Xid xid = this.subcoord.getJavaxXid(this.subcoord.getXaresIndex(xAResource));
        if (!this.enlistedJavaxXid.contains(xid)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)("XAResouce " + xAResource + " not enlisted by JOTM"));
            }
            return false;
        }
        int n2 = this.enlistedJavaxXid.indexOf(xid);
        javax.transaction.xa.Xid xid2 = (javax.transaction.xa.Xid)this.enlistedJavaxXid.get(n2);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("resXid= " + xidImpl));
            TraceTm.jta.debug((Object)("delisted with resource= " + xAResource));
            TraceTm.jta.debug((Object)("end myjavaxxid= " + xid2));
        }
        try {
            xAResource.end(xid2, n);
        }
        catch (XAException xAException) {
            String string = "Cannot send XA end:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
            TraceTm.jotm.error((Object)string);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)("xares.end= " + xAResource));
            }
            throw new SystemException(string);
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("enlistedXAres.remove xares= " + xAResource));
        }
        this.enlistedXARes.remove(xAResource);
        this.enlistedJavaxXid.remove(xid);
        return true;
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        int n;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.enlistResource");
            TraceTm.jta.debug((Object)("xares= " + xAResource));
        }
        if (xAResource == null) {
            TraceTm.jotm.error((Object)"enlistResource: null argument");
            throw new SystemException("enlistResource: null argument");
        }
        if (this.myCtx == null) {
            throw new SystemException("enlistResource: no Transactional Context");
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
            if (this.subcoord == null) {
                TraceTm.jotm.error((Object)"enlistResource: could not create subcoordinator");
                throw new SystemException("enlistResource: could not create subcoordinator");
            }
        }
        boolean bl = false;
        try {
            bl = this.subcoord.addResource(xAResource);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("enlistResource: could not addResource " + xAResource);
        }
        boolean bl2 = false;
        int n2 = n = bl ? 0x200000 : 0;
        if (this.delistedXARes != null && this.delistedXARes.contains(xAResource)) {
            n = 0x8000000;
        }
        XidImpl xidImpl = new XidImpl(this.getXid(), this.subcoord.getXaresIndex(xAResource));
        JavaXidImpl javaXidImpl = new JavaXidImpl(xidImpl);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("resXid= " + xidImpl));
            TraceTm.jta.debug((Object)("enlisted with resource= " + xAResource));
            TraceTm.jta.debug((Object)("start javaxxid= " + javaXidImpl));
        }
        if (!bl) {
            this.subcoord.addJavaxXid(javaXidImpl);
        }
        try {
            xAResource.start(javaXidImpl, n);
        }
        catch (XAException xAException) {
            String string = "Cannot send XA(" + xAResource + ") start:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
            TraceTm.jotm.error((Object)string);
            throw new SystemException(string);
        }
        if (bl2) {
            throw new RollbackException();
        }
        if (!this.enlistedXARes.contains(xAResource)) {
            this.enlistedXARes.add(xAResource);
            this.enlistedJavaxXid.add(javaXidImpl);
        }
        int n3 = this.getStatus();
        switch (n3) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Transaction already prepared.");
            }
            case 8: {
                break;
            }
            case 3: {
                throw new IllegalStateException("Transaction already committed.");
            }
            case 1: {
                throw new RollbackException("Transaction already marked for rollback");
            }
            case 9: {
                throw new RollbackException("Transaction already started rolling back.");
            }
            case 4: {
                throw new RollbackException("Transaction already rolled back.");
            }
            case 6: {
                throw new IllegalStateException("No current transaction.");
            }
            case 5: {
                throw new IllegalStateException("Unknown transaction status");
            }
            default: {
                throw new IllegalStateException("Illegal transaction status: " + n3);
            }
        }
        return true;
    }

    public void doDetach(int n) throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.doDetach flag= " + XAResourceHelper.getFlagName(n)));
            TraceTm.jta.debug((Object)("number of enlisted= " + this.enlistedXARes.size()));
        }
        this.delistedXARes = new ArrayList(this.enlistedXARes);
        for (int i = 0; i < this.delistedXARes.size(); ++i) {
            this.delistResource((XAResource)this.delistedXARes.get(i), n);
        }
    }

    public void doAttach(int n) throws SystemException, RollbackException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.doAttach flag= " + XAResourceHelper.getFlagName(n)));
            TraceTm.jta.debug((Object)("number of enlisted= " + this.enlistedXARes.size()));
        }
        if (n == 0x8000000) {
            for (int i = 0; this.delistedXARes != null && i < this.delistedXARes.size(); ++i) {
                this.enlistResource((XAResource)this.delistedXARes.get(i));
            }
        }
        this.delistedXARes = null;
    }

    public List getEnlistedXAResource() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("getEnlistedXAResource size= " + this.enlistedXARes.size()));
        }
        return new ArrayList(this.enlistedXARes);
    }

    public int getStatus() throws SystemException {
        Coordinator coordinator;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.getStatus()");
        }
        if ((coordinator = this.myCtx.getCoordinator()) != null) {
            int n;
            try {
                n = coordinator.get_status();
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"cannot reach JTM:", (Throwable)exception);
                return 6;
            }
            return n;
        }
        if (this.subcoord == null) {
            return 0;
        }
        return this.subcoord.getStatus();
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.registerSynchronization(Synchronization sync)");
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
        }
        this.subcoord.addSynchronization(synchronization);
    }

    public void rollback() throws IllegalStateException, SystemException {
        Terminator terminator;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.rollback(tx= " + this + ")"));
        }
        if ((terminator = this.myCtx.getTerminator()) != null) {
            try {
                this.propagateCtx = false;
                terminator.rollback();
                this.propagateCtx = true;
            }
            catch (ServerException serverException) {
                throw new IllegalStateException("Exception on rollback:" + serverException.detail);
            }
            catch (Exception exception) {
                Current.getCurrent().forgetTx(this.getXid());
                throw new SystemException("Unexpected Exception on rollback");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.rollback();
            }
            catch (RemoteException remoteException) {
                Current.getCurrent().forgetTx(this.getXid());
                throw new IllegalStateException("Exception on rollback:" + remoteException);
            }
        } else {
            this.unsetTimer();
        }
        Current.getCurrent().forgetTx(this.getXid());
    }

    public int prepare() throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.prepare(tx= " + this + ")"));
        }
        int n = 0;
        if (this.subcoord != null) {
            try {
                n = this.subcoord.prepare();
            }
            catch (RemoteException remoteException) {
                TraceTm.jotm.error((Object)"Unexpected Exception on prepare:", (Throwable)remoteException);
                throw new SystemException("Unexpected Exception on prepare");
            }
        }
        return n;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Coordinator coordinator;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.setRollbackOnly(tx= " + this + ")"));
        }
        if ((coordinator = this.myCtx.getCoordinator()) != null) {
            try {
                coordinator.rollback_only();
            }
            catch (RemoteException remoteException) {
                TraceTm.jotm.error((Object)"Cannot perform coordinator rollback only", (Throwable)remoteException);
            }
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
        }
        this.subcoord.setRollbackOnly();
    }

    public void timeoutExpired(Object object) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.timeoutExpired");
        }
        Current.getCurrent().incrementExpiredCounter();
        if (this.subcoord == null) {
            Terminator terminator = this.myCtx.getTerminator();
            if (terminator != null) {
                TraceTm.jotm.info((Object)("forget tx (tx=" + this + ")"));
                Current.getCurrent().forgetTx(this.getXid());
                return;
            }
            this.makeSubCoord();
        }
        TraceTm.jotm.info((Object)("set rollback only (tx=" + this + ")"));
        try {
            this.subcoord.setRollbackOnly();
        }
        catch (Exception exception) {
            TraceTm.jotm.error((Object)("cannot rollbackonly:" + exception));
            return;
        }
    }

    public boolean equals(Object object) {
        TransactionImpl transactionImpl = (TransactionImpl)object;
        if (transactionImpl == this) {
            return true;
        }
        if (transactionImpl == null) {
            return false;
        }
        return this.getXid().equals(transactionImpl.getXid());
    }

    public int hashCode() {
        if (!this.genXidhashcode) {
            this.genXidhashcode = true;
            this.myXidhashcode = this.getXid().hashCode();
        }
        return this.myXidhashcode;
    }

    public String toString() {
        if (!this.genXidtostring) {
            this.genXidtostring = true;
            this.myXidtostring = ((Object)this.getXid()).toString();
        }
        return this.myXidtostring;
    }

    public synchronized TransactionContext getPropagationContext(boolean bl) {
        if (this.propagateCtx) {
            if (bl) {
                ++this.ucount;
            }
            return this.myCtx;
        }
        return null;
    }

    public void setTimer(TimerEvent timerEvent) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("set timer for tx (timer=" + timerEvent + ", tx=" + this + ")"));
        }
        this.timer = timerEvent;
    }

    public void unsetTimer() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("unset timer for tx (timer=" + this.timer + ", tx=" + this + ")"));
        }
        if (this.timer != null) {
            this.timer.unset();
            this.timer = null;
        }
    }

    public void setTxDate(String string) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("set date for tx (data=" + string + ", tx=" + this + ")"));
        }
        this.txDate = string;
    }

    public String getTxDate() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("get date for tx (date=" + this.txDate + ", tx=" + this + ")"));
        }
        return this.txDate;
    }

    public synchronized void updatePropagationContext(TransactionContext transactionContext) {
        Coordinator coordinator;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.updatePropagationContext");
        }
        if ((coordinator = transactionContext.getCoordinator()) == null && this.myCtx.getCoordinator() != null) {
            TraceTm.jotm.error((Object)"setPropagationContext: Bad Coordinator");
            TraceTm.jotm.error((Object)("remoteCoord = " + coordinator));
            TraceTm.jotm.error((Object)("myCtx.getCoordinator()= " + this.myCtx.getCoordinator()));
            return;
        }
        --this.ucount;
        if (coordinator != null && this.myCtx.getCoordinator() == null) {
            this.myCtx.setCoordinator(transactionContext.getCoordinator());
            if (this.subcoord != null) {
                try {
                    this.recoveryCoord = coordinator.register_resource(this.subcoord);
                }
                catch (RemoteException remoteException) {
                    TraceTm.jotm.error((Object)"Cannot make interposition:", (Throwable)remoteException);
                    return;
                }
            }
        }
        if (transactionContext.getTerminator() != null) {
            this.myCtx.setTerminator(transactionContext.getTerminator());
        }
    }

    public Xid getXid() {
        return this.myXid;
    }

    private void makeSubCoord() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"make subcoordinator");
        }
        try {
            this.subcoord = new SubCoordinator(this, this.getXid());
        }
        catch (RemoteException remoteException) {
            TraceTm.jotm.error((Object)"new SubCoordinator raised exception: ", (Throwable)remoteException);
            return;
        }
        Coordinator coordinator = this.myCtx.getCoordinator();
        if (this.interpose && coordinator == null) {
            try {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"Creating a remote Control on JTM for a distributed transaction");
                }
                coordinator = (Coordinator)PortableRemoteObject.narrow((Object)Current.getJTM().create(this.myCtx.getTimeout()), (Class)(class$org$objectweb$jotm$Coordinator == null ? (class$org$objectweb$jotm$Coordinator = TransactionImpl.class$("org.objectweb.jotm.Coordinator")) : class$org$objectweb$jotm$Coordinator));
            }
            catch (RemoteException remoteException) {
                TraceTm.jotm.error((Object)"Cannot create distributed transaction:", (Throwable)remoteException);
                return;
            }
            this.myCtx.setCoordinator(coordinator);
            if (this.myCtx.getTerminator() == null) {
                this.myCtx.setTerminator((Terminator)((Object)coordinator));
            }
        }
        if (coordinator != null && this.recoveryCoord == null) {
            try {
                this.recoveryCoord = coordinator.register_resource(this.subcoord);
            }
            catch (RemoteException remoteException) {
                TraceTm.jotm.error((Object)"Cannot make interposition:", (Throwable)remoteException);
                return;
            }
        }
    }

    public boolean isRemovable() {
        return this.ucount == 0 && this.subcoord == null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

