/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.ControlImpl;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.XidImpl;

public class TransactionFactoryImpl
extends PortableRemoteObject
implements TransactionFactory {
    int timeoutMax = 3600;
    private Vector coordinatorList = new Vector();

    public TransactionFactoryImpl() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"default constructor");
        }
    }

    public synchronized Control create(int n) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("timeout=" + n));
        }
        ControlImpl controlImpl = null;
        if (n == 0 || n > this.timeoutMax) {
            n = this.timeoutMax;
        }
        XidImpl xidImpl = new XidImpl("TMServer", 0);
        try {
            controlImpl = new ControlImpl(n, xidImpl, null);
        }
        catch (Exception exception) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", (Throwable)exception);
        }
        return controlImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Control recreate(TransactionContext transactionContext) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("TransactionContext=" + transactionContext));
        }
        ControlImpl controlImpl = null;
        Object object = this.coordinatorList;
        synchronized (object) {
            for (int i = 0; i < this.coordinatorList.size(); ++i) {
                Coordinator coordinator = (Coordinator)this.coordinatorList.elementAt(i);
                if (!coordinator.equals(transactionContext.getCoordinator())) continue;
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"recreate: Control already in the list");
                }
                controlImpl = (ControlImpl)coordinator;
                break;
            }
        }
        if (controlImpl != null) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"recreate twice");
            }
            return controlImpl;
        }
        object = transactionContext.getXid();
        try {
            controlImpl = new ControlImpl(transactionContext.getTimeout(), (Xid)object, transactionContext.getCoordinator());
        }
        catch (Exception exception) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", (Throwable)exception);
        }
        return controlImpl;
    }

    public int getPortNumber() throws RemoteException {
        return 0;
    }

    public String getHostName() throws RemoteException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            throw new RemoteException("" + exception);
        }
    }
}

