/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.util.Vector;
import org.objectweb.jotm.Batch;
import org.objectweb.jotm.Clock;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TraceTm;

public class TimerManager {
    private static Batch batchThread;
    private static Clock clockThread;
    private Vector timerList = new Vector();
    private Vector expiredList = new Vector();
    private static TimerManager unique;
    private static boolean shuttingdown;

    private TimerManager() {
        batchThread = new Batch(this);
        batchThread.setDaemon(true);
        batchThread.start();
        clockThread = new Clock(this);
        clockThread.setDaemon(true);
        clockThread.start();
    }

    public static TimerManager getInstance() {
        if (unique == null) {
            unique = new TimerManager();
        }
        return unique;
    }

    public static void stop(boolean bl) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Stop TimerManager");
        }
        TimerManager timerManager = TimerManager.getInstance();
        shuttingdown = true;
        while (clockThread.isAlive() || batchThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TimerManager has stopped");
        }
    }

    public static void stop() {
        TimerManager.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clock() {
        Vector vector;
        block6: while (true) {
            try {
                while (true) {
                    Thread.sleep(shuttingdown ? 1L : 1000L);
                    vector = this.timerList;
                    synchronized (vector) {
                        int n = 0;
                        boolean bl = true;
                        for (int i = 0; i < this.timerList.size(); ++i) {
                            TimerEvent timerEvent = (TimerEvent)this.timerList.elementAt(i);
                            if (!timerEvent.isStopped()) {
                                bl = false;
                            }
                            if (timerEvent.update() <= 0L) {
                                this.timerList.removeElementAt(i--);
                                if (timerEvent.valid()) {
                                    this.expiredList.addElement(timerEvent);
                                    ++n;
                                    if (timerEvent.ispermanent() && !shuttingdown) {
                                        timerEvent.restart();
                                        this.timerList.addElement(timerEvent);
                                    }
                                }
                            }
                            timerEvent = null;
                        }
                        if (n > 0) {
                            this.timerList.notify();
                        } else if (bl && shuttingdown) {
                            break block6;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                TraceTm.jta.error((Object)"Timer interrupted");
                continue;
            }
            break;
        }
        vector = this.timerList;
        synchronized (vector) {
            this.timerList.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch() {
        while (!(shuttingdown && this.timerList.isEmpty() && this.expiredList.isEmpty())) {
            TimerEvent timerEvent;
            Vector vector = this.timerList;
            synchronized (vector) {
                while (this.expiredList.isEmpty()) {
                    if (shuttingdown) {
                        return;
                    }
                    try {
                        this.timerList.wait();
                    }
                    catch (Exception exception) {
                        TraceTm.jta.error((Object)"Exception in Batch: ", (Throwable)exception);
                    }
                }
                timerEvent = (TimerEvent)this.expiredList.elementAt(0);
                this.expiredList.removeElementAt(0);
            }
            timerEvent.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerEvent addTimer(TimerEventListener timerEventListener, long l, Object object, boolean bl) {
        TimerEvent timerEvent = new TimerEvent(timerEventListener, l, object, bl);
        Vector vector = this.timerList;
        synchronized (vector) {
            this.timerList.addElement(timerEvent);
        }
        return timerEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimer(TimerEvent timerEvent) {
        Vector vector = this.timerList;
        synchronized (vector) {
            this.timerList.removeElement(timerEvent);
        }
    }

    static {
        unique = null;
        shuttingdown = false;
    }
}

