/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicRollback;
import org.objectweb.jotm.Resource;
import org.objectweb.jotm.SLog;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class SubCoordinator
extends PortableRemoteObject
implements Resource {
    private TransactionImpl tx = null;
    private Vector synchroList = new Vector();
    private Vector resourceList = new Vector();
    private Vector javaxxidList = new Vector();
    private TransactionManager tm;
    private Xid xid = null;
    private SLog log = null;
    private int status = 0;
    private boolean beforeCompletionDone = false;

    SubCoordinator(TransactionImpl transactionImpl, Xid xid) throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + transactionImpl + ",  xid=" + xid));
        }
        this.tx = transactionImpl;
        this.xid = xid;
        this.tm = Current.getTransactionManager();
        Current.getCurrent().incrementBeginCounter();
        this.beforeCompletionDone = false;
    }

    public int prepare() throws RemoteException {
        block10: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException systemException) {
                if (!TraceTm.jta.isDebugEnabled()) break block10;
                String string = "Error when detaching XAResource:" + (Object)((Object)systemException) + "--" + systemException.getMessage();
                TraceTm.jta.debug((Object)string);
            }
        }
        switch (this.status) {
            case 1: {
                this.doBeforeCompletion(false);
                this.doRollback();
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        this.doBeforeCompletion(true);
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.prepare");
            this.doRollback();
            return 1;
        }
        int n = this.doPrepare();
        if (n == 2) {
            this.doAfterCompletion();
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("vote = " + n));
        }
        return n;
    }

    public void rollback() throws RemoteException {
        block9: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException systemException) {
                if (!TraceTm.jta.isDebugEnabled()) break block9;
                String string = "Error when detaching XAResource:" + (Object)((Object)systemException) + "--" + systemException.getMessage();
                TraceTm.jta.debug((Object)string);
            }
        }
        switch (this.status) {
            case 0: 
            case 1: 
            case 9: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"transaction rolling back");
                break;
            }
            case 2: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"should not rollback a prepared transaction");
                break;
            }
            case 4: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"already rolledback");
                }
                return;
            }
            default: {
                TraceTm.jotm.error((Object)("rollback: bad status: " + StatusHelper.getStatusName(this.status)));
                return;
            }
        }
        this.doBeforeCompletion(false);
        this.doRollback();
    }

    public void commit() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        switch (this.status) {
            case 2: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("commit: bad status: " + StatusHelper.getStatusName(this.status)));
                return;
            }
        }
        this.doCommit();
    }

    /*
     * Unable to fully structure code
     */
    public void commit_one_phase() throws RemoteException {
        block22: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            switch (this.status) {
                case 4: {
                    try {
                        this.tx.doDetach(0x4000000);
                    }
                    catch (SystemException var1_1) {
                        if (!TraceTm.jta.isDebugEnabled()) ** GOTO lbl12
                        var2_6 = "Error when detaching XAResource:" + (Object)var1_1 + "--" + var1_1.getMessage();
                        TraceTm.jta.debug((Object)var2_6);
                    }
lbl12:
                    // 3 sources

                    throw new TransactionRolledbackException();
                }
                case 1: {
                    this.doBeforeCompletion(false);
                    try {
                        this.tx.doDetach(0x4000000);
                    }
                    catch (SystemException var1_2) {
                        if (!TraceTm.jta.isDebugEnabled()) ** GOTO lbl22
                        var2_7 = "Error when detaching XAResource:" + (Object)var1_2 + "--" + var1_2.getMessage();
                        TraceTm.jta.debug((Object)var2_7);
                    }
lbl22:
                    // 3 sources

                    this.doRollback();
                    throw new TransactionRolledbackException();
                }
                case 3: {
                    try {
                        this.tx.doDetach(0x4000000);
                    }
                    catch (SystemException var1_3) {
                        if (!TraceTm.jta.isDebugEnabled()) ** GOTO lbl32
                        var2_8 = "Error when detaching XAResource:" + (Object)var1_3 + "--" + var1_3.getMessage();
                        TraceTm.jta.debug((Object)var2_8);
                    }
lbl32:
                    // 3 sources

                    return;
                }
            }
            this.doBeforeCompletion(true);
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException var1_4) {
                if (!TraceTm.jta.isDebugEnabled()) break block22;
                var2_9 = "Error when detaching XAResource:" + (Object)var1_4 + "--" + var1_4.getMessage();
                TraceTm.jta.debug((Object)var2_9);
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.commit_one_phase");
            this.doRollback();
            throw new TransactionRolledbackException();
        }
        if (this.resourceList.size() == 1) {
            this.doOnePhaseCommit();
            return;
        }
        var1_5 = this.doPrepare();
        switch (var1_5) {
            case 0: {
                this.doCommit();
                break;
            }
            case 2: {
                this.doAfterCompletion();
                break;
            }
            case 1: {
                this.doRollback();
                throw new TransactionRolledbackException();
            }
        }
    }

    public void forget() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.forget()");
        }
        this.doForget();
    }

    public void addSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("synchro=" + synchronization));
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        boolean bl = false;
        switch (this.status) {
            case 1: 
            case 4: {
                bl = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "addSynchronization: bad status = " + StatusHelper.getStatusName(this.status);
                TraceTm.jotm.error((Object)string);
                throw new IllegalStateException(string);
            }
        }
        this.synchroList.addElement(synchronization);
        if (bl) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"SubCoordinator.addSynchronization: transaction rollback only");
            }
            throw new RollbackException();
        }
    }

    public synchronized boolean addResource(XAResource xAResource) throws IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xares=" + xAResource));
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        boolean bl = false;
        switch (this.status) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "SubCoordinator.addResource: bad status= " + StatusHelper.getStatusName(this.status);
                TraceTm.jotm.error((Object)string);
                throw new IllegalStateException(string);
            }
        }
        boolean bl2 = false;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource xAResource2 = (XAResource)this.resourceList.elementAt(i);
            try {
                if (!xAResource2.isSameRM(xAResource)) continue;
                bl2 = true;
                break;
            }
            catch (XAException xAException) {
                String string = "Cannot send res.isSameRM:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
                TraceTm.jotm.error((Object)("Exception on resource.isSameRM: " + string));
            }
        }
        if (!bl2) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"new XAResource added to the list");
            }
            this.resourceList.addElement(xAResource);
        }
        if (bl && TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.addResource: transaction set rollback only");
        }
        return bl2;
    }

    public synchronized void addJavaxXid(javax.transaction.xa.Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("addJavaxXid javaxxid=" + xid));
        }
        this.javaxxidList.addElement(xid);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"new JavaxXid added to the list");
        }
    }

    public int getStatus() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        return this.status;
    }

    public javax.transaction.xa.Xid getJavaxXid(int n) {
        javax.transaction.xa.Xid xid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(n);
        return xid;
    }

    public void setRollbackOnly() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        switch (this.status) {
            case 0: 
            case 5: 
            case 7: {
                this.status = 1;
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                TraceTm.jotm.error((Object)"Cannot set transaction as rollback only");
                TraceTm.jotm.error((Object)("Bad status=" + StatusHelper.getStatusName(this.status)));
            }
        }
    }

    private void doForget() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doForget()");
        }
        boolean bl = false;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource xAResource = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid xid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            XidImpl xidImpl = new XidImpl(this.xid, i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("xid=        " + xidImpl));
                TraceTm.jta.debug((Object)("myjavaxxid= " + xid));
                TraceTm.jta.debug((Object)("forgotten with resource= " + xAResource));
            }
            try {
                xAResource.forget(xid);
                continue;
            }
            catch (XAException xAException) {
                String string = "Cannot send xar.forget:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from xar.forget: " + string));
                bl = true;
            }
        }
        if (bl) {
            throw new RemoteException("XAException on forget");
        }
        SubCoordinator.unexportObject((Remote)this);
    }

    private synchronized int doPrepare() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doPrepare()");
        }
        String string = "PREPARE";
        int n = 2;
        int n2 = 0;
        if (this.resourceList.size() == 0) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            return n;
        }
        this.log = new SLog();
        this.status = 7;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            String string2;
            XAResource xAResource = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid xid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            XidImpl xidImpl = new XidImpl(this.xid, i);
            if (n2 > 0) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("xid=        " + xidImpl));
                    TraceTm.jta.debug((Object)("myjavaxxid= " + xid));
                    TraceTm.jta.debug((Object)("rolled back with resource= " + xAResource));
                }
                try {
                    xAResource.rollback(xid);
                }
                catch (XAException xAException) {
                    string2 = "Cannot send res.rollback:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
                    TraceTm.jotm.error((Object)("Got XAException from res.rollback: " + string2));
                }
                continue;
            }
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("xid=        " + xidImpl));
                TraceTm.jta.debug((Object)("myjavaxxid= " + xid));
                TraceTm.jta.debug((Object)("prepared with resource= " + xAResource));
            }
            try {
                switch (xAResource.prepare(xid)) {
                    case 0: {
                        this.log.addResource(xAResource, xidImpl);
                        n = 0;
                        break;
                    }
                }
                continue;
            }
            catch (XAException xAException) {
                string2 = "Cannot send res.prepare:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from res.prepare: " + string2));
                n = 1;
                ++n2;
            }
        }
        switch (n) {
            case 2: {
                Current.getCurrent().incrementCommitCounter();
                this.status = 3;
                break;
            }
            case 0: {
                this.status = 2;
                break;
            }
            case 1: {
                this.status = 9;
            }
        }
        return n;
    }

    private synchronized int doCommit() throws RemoteException {
        int n;
        Object object;
        Object object2;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doCommit()");
        }
        if (this.log == null) {
            TraceTm.jotm.error((Object)"doCommit: no log");
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        List list = this.log.getLoggedResources();
        List list2 = this.log.getLoggedXids();
        XACommittingTx xACommittingTx = null;
        XACommittingTx xACommittingTx2 = null;
        byte[][] byArrayArray = new byte[list.size() + 1][];
        byte[] byArray = null;
        byte[] byArray2 = null;
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        String string = "RR1";
        String string2 = "RR2";
        byte[] byArray3 = new byte[11];
        byte[][] byArray4 = new byte[1][11];
        if (Current.getDefaultRecovery()) {
            Object object3;
            Xid xid = this.tx.getXid();
            object2 = xid.toString(true);
            int n5 = ((String)object2).length();
            object = this.tx.getTxDate();
            int n6 = ((String)object).length();
            long l = System.currentTimeMillis();
            byArray = new byte[15 + n5 + 4 + n6 + 4];
            byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.put(string.getBytes());
            byteBuffer.putLong(l);
            byteBuffer.putInt(n5);
            byteBuffer.put(((String)object2).getBytes());
            byteBuffer.putInt(n6);
            byteBuffer.put(((String)object).getBytes());
            byteBuffer.putInt(list.size());
            byArrayArray[0] = byteBuffer.array();
            byArray3 = "RR3JOTMDONE".getBytes();
            for (n = 0; n < list.size(); ++n) {
                object3 = (XAResource)list.get(n);
                Xid xid2 = (Xid)list2.get(n);
                int n7 = 99;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("recovery xid= " + xid2));
                    TraceTm.recovery.debug((Object)("recovery resource= " + object3));
                }
                int n8 = object3.toString().length();
                int n9 = object3.getClass().getName().length();
                int n10 = xid2.toString(true).length();
                byArray2 = new byte[11 + n8 + 4 + n9 + 4 + n10 + 4];
                byteBuffer2 = ByteBuffer.wrap(byArray2);
                byteBuffer2.put(string2.getBytes());
                byteBuffer2.putInt(n7);
                byteBuffer2.putInt(n8);
                byteBuffer2.put(object3.toString().getBytes());
                byteBuffer2.putInt(n9);
                byteBuffer2.put(object3.getClass().getName().getBytes());
                byteBuffer2.putInt(n10);
                byteBuffer2.put(xid2.toString(true).getBytes());
                byteBuffer2.putInt(this.status);
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)"Prepare Init RR2 to Recovery Buffer");
                }
                byArrayArray[n + 1] = byteBuffer2.array();
            }
            try {
                xACommittingTx = TransactionRecoveryImpl.getTransactionRecovery().howlCommitLog(byArrayArray);
            }
            catch (Exception exception) {
                this.status = 4;
                object3 = "Cannot howlCommitLog:" + exception + " --" + exception.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlCommitLog: " + (String)object3));
                xACommittingTx = null;
                this.doAfterCompletion();
                this.log.forgetLog();
                throw new TransactionRolledbackException();
            }
        }
        this.status = 8;
        for (int i = 0; i < list.size(); ++i) {
            block39: {
                object2 = (XAResource)list.get(i);
                javax.transaction.xa.Xid xid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
                object = (Xid)list2.get(i);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("xid=        " + object));
                    TraceTm.jta.debug((Object)("myjavaxxid= " + xid));
                    TraceTm.jta.debug((Object)("attempting commit with resource= " + object2));
                }
                if (Current.getDefaultRecovery()) {
                    int n11 = 99;
                    int n12 = object2.toString().length();
                    int n13 = object2.getClass().getName().length();
                    n = object.toString(true).length();
                    byArray2 = new byte[11 + n12 + 4 + n13 + 4 + n + 4];
                    byteBuffer2 = ByteBuffer.wrap(byArray2);
                    byteBuffer2.put(string2.getBytes());
                    byteBuffer2.putInt(n11);
                    byteBuffer2.putInt(n12);
                    byteBuffer2.put(object2.toString().getBytes());
                    byteBuffer2.putInt(n13);
                    byteBuffer2.put(object2.getClass().getName().getBytes());
                    byteBuffer2.putInt(n);
                    byteBuffer2.put(object.toString(true).getBytes());
                }
                try {
                    object2.commit(xid, false);
                    if (Current.getDefaultRecovery()) {
                        byteBuffer2.putInt(3);
                    }
                    ++n3;
                }
                catch (XAException xAException) {
                    switch (xAException.errorCode) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            if (TraceTm.jta.isDebugEnabled()) {
                                TraceTm.jta.debug((Object)("Heuristic condition= " + xAException.getMessage()));
                            }
                            if (Current.getDefaultRecovery()) {
                                byteBuffer2.putInt(5);
                            }
                        }
                        case -7: 
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: {
                            if (TraceTm.jta.isDebugEnabled()) {
                                TraceTm.jta.debug((Object)("RM error= " + xAException.getMessage()));
                            }
                            if (!Current.getDefaultRecovery()) break;
                            byteBuffer2.putInt(8);
                        }
                    }
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)("Default error= " + xAException.getMessage()));
                    }
                    if (Current.getDefaultRecovery()) {
                        byteBuffer2.putInt(4);
                    }
                    String string3 = "Cannot send res.commit:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
                    TraceTm.jotm.error((Object)("Got XAException from res.commit: " + string3));
                    ++n2;
                    if (n3 <= 0) break block39;
                    ++n4;
                }
            }
            if (!Current.getDefaultRecovery()) continue;
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Prepare New RR2 to Recovery Buffer");
            }
            byArrayArray[i + 1] = byteBuffer2.array();
        }
        if (n2 == 0) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            if (Current.getDefaultRecovery()) {
                try {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"Done howl log, all okay");
                    }
                    byArray4[0] = byArray3;
                    TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(byArray4, xACommittingTx);
                }
                catch (Exception exception) {
                    object2 = "Cannot howlDoneLog:" + exception + "--" + exception.getMessage();
                    TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + (String)object2));
                }
            }
            this.doAfterCompletion();
            this.log.forgetLog();
            return 0;
        }
        if (n4 == 0) {
            this.status = 4;
            if (Current.getDefaultRecovery()) {
                try {
                    byArray4[0] = byArray3;
                    TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(byArray4, xACommittingTx);
                }
                catch (Exception exception) {
                    object2 = "Cannot howlDoneLog" + exception + "--" + exception.getMessage();
                    TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + (String)object2));
                }
            }
            this.doAfterCompletion();
            this.log.forgetLog();
            throw new TransactionRolledbackException();
        }
        if (n4 != 0 && Current.getDefaultRecovery()) {
            try {
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)"Rewrite HowlCommitLog");
                }
                xACommittingTx2 = TransactionRecoveryImpl.getTransactionRecovery().howlCommitLog(byArrayArray);
            }
            catch (Exception exception) {
                this.status = 5;
                object2 = "Cannot howlCommitLog:" + exception + " --" + exception.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlCommitLog: " + (String)object2));
                xACommittingTx = null;
                this.doAfterCompletion();
                this.log.forgetLog();
                throw new TransactionRolledbackException();
            }
            this.status = 5;
            try {
                byArray4[0] = byArray3;
                TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(byArray4, xACommittingTx);
            }
            catch (Exception exception) {
                object2 = "Cannot howlDoneLog" + exception + "--" + exception.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + (String)object2));
            }
        }
        this.status = 5;
        this.doAfterCompletion();
        return -1;
    }

    private synchronized void doOnePhaseCommit() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doOnePhaseCommit()");
        }
        this.status = 8;
        XAResource xAResource = (XAResource)this.resourceList.elementAt(0);
        javax.transaction.xa.Xid xid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(0);
        XidImpl xidImpl = new XidImpl(this.xid, 0);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xid=        " + xidImpl));
            TraceTm.jta.debug((Object)("myjavaxxid= " + xid));
            TraceTm.jta.debug((Object)("one phase commit with resource= " + xAResource));
        }
        try {
            xAResource.commit(xid, true);
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
        }
        catch (XAException xAException) {
            this.status = 5;
            String string = "Cannot send res.commit:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
            TraceTm.jotm.error((Object)("Got XAException from res.commit: " + string));
            if (xAException.errorCode == 100) {
                throw new TransactionRolledbackException("XAException:" + string);
            }
            throw new RemoteException("XAException:" + string);
        }
        finally {
            this.doAfterCompletion();
        }
    }

    private synchronized void doRollback() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doRollback()");
        }
        this.status = 4;
        boolean bl = false;
        String string = null;
        int n = 0;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource xAResource = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid xid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            XidImpl xidImpl = new XidImpl(this.xid, i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("xid=        " + xidImpl));
                TraceTm.jta.debug((Object)("myjavaxxid= " + xid));
                TraceTm.jta.debug((Object)("rolled back with resource= " + xAResource));
            }
            try {
                xAResource.rollback(xid);
                continue;
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (TraceTm.jta.isDebugEnabled()) {
                            TraceTm.jta.debug((Object)("Heuristic condition= " + xAException.getMessage()));
                        }
                        bl = true;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: {
                        if (!TraceTm.jta.isDebugEnabled()) break;
                        TraceTm.jta.debug((Object)("RM error= " + xAException.getMessage()));
                    }
                }
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("Default error= " + xAException.getMessage()));
                }
                string = "Cannot send res.rollback:" + xAException + " (error code = " + xAException.errorCode + ") --" + xAException.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from res.rollback: " + string));
                ++n;
            }
        }
        if (bl) {
            throw new HeuristicRollback();
        }
        if (n != 0) {
            throw new RemoteException("rollback: Unexpected XAException:" + string);
        }
        Current.getCurrent().incrementRollbackCounter();
        this.doAfterCompletion();
    }

    private void doBeforeCompletion(boolean bl) {
        block32: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("doBeforeCompletion committing= " + bl));
            }
            if (this.beforeCompletionDone) {
                return;
            }
            this.tx.unsetTimer();
            if (bl && this.synchroList.size() > 0) {
                String string;
                boolean bl2;
                boolean bl3;
                Transaction transaction;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                transaction = null;
                                bl3 = false;
                                bl2 = false;
                                try {
                                    transaction = this.tm.getTransaction();
                                }
                                catch (SystemException systemException) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block28;
                                    string = "Cannot get transaction:" + (Object)((Object)systemException) + "--" + systemException.getMessage();
                                    TraceTm.jta.debug((Object)string);
                                }
                            }
                            if (transaction != null && !transaction.equals(this.tx)) {
                                try {
                                    this.tm.suspend();
                                    bl3 = true;
                                }
                                catch (SystemException systemException) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block29;
                                    string = "Cannot suspend transaction:" + (Object)((Object)systemException) + "--" + systemException.getMessage();
                                    TraceTm.jta.debug((Object)string);
                                }
                            }
                        }
                        if (transaction == null || bl3) {
                            try {
                                this.tm.resume((Transaction)this.tx);
                                bl2 = true;
                            }
                            catch (SystemException systemException) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    string = "Cannot resume transaction:" + (Object)((Object)systemException) + "--" + systemException.getMessage();
                                    TraceTm.jta.debug((Object)string);
                                }
                            }
                            catch (InvalidTransactionException invalidTransactionException) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    string = "Cannot resume transaction:" + (Object)((Object)invalidTransactionException) + "--" + invalidTransactionException.getMessage();
                                    TraceTm.jta.debug((Object)string);
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                if (!TraceTm.jta.isDebugEnabled()) break block30;
                                string = "Cannot resume transaction:" + illegalStateException + "--" + illegalStateException.getMessage();
                                TraceTm.jta.debug((Object)string);
                            }
                        }
                    }
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)("sychronization list size= " + this.synchroList.size()));
                    }
                    for (int i = 0; i < this.synchroList.size(); ++i) {
                        string = (Synchronization)this.synchroList.elementAt(i);
                        if (TraceTm.jta.isDebugEnabled()) {
                            TraceTm.jta.debug((Object)("Synchronization sync= " + string));
                        }
                        string.beforeCompletion();
                    }
                    if (bl2) {
                        try {
                            this.tm.suspend();
                        }
                        catch (SystemException systemException) {
                            if (!TraceTm.jta.isDebugEnabled()) break block31;
                            string = "Cannot suspend transaction:" + (Object)((Object)systemException) + "--" + systemException.getMessage();
                            TraceTm.jta.debug((Object)string);
                        }
                    }
                }
                if (bl3) {
                    try {
                        this.tm.resume(transaction);
                        bl2 = true;
                    }
                    catch (SystemException systemException) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            string = "Cannot resume transaction:" + (Object)((Object)systemException) + "--" + systemException.getMessage();
                            TraceTm.jta.debug((Object)string);
                        }
                    }
                    catch (InvalidTransactionException invalidTransactionException) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            string = "Cannot resume transaction:" + (Object)((Object)invalidTransactionException) + "--" + invalidTransactionException.getMessage();
                            TraceTm.jta.debug((Object)string);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!TraceTm.jta.isDebugEnabled()) break block32;
                        string = "Cannot resume transaction:" + illegalStateException + "--" + illegalStateException.getMessage();
                        TraceTm.jta.debug((Object)string);
                    }
                }
            }
        }
        this.beforeCompletionDone = true;
    }

    private void doAfterCompletion() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"doAfterCompletion()");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("sychronization list size= " + this.synchroList.size()));
        }
        for (int i = 0; i < this.synchroList.size(); ++i) {
            Synchronization synchronization = (Synchronization)this.synchroList.elementAt(i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("Synchronization sync= " + synchronization));
                TraceTm.jta.debug((Object)("sync.afterCompletion status= " + StatusHelper.getStatusName(this.status)));
            }
            synchronization.afterCompletion(this.status);
        }
        Current.getCurrent().forgetTx(this.tx.getXid());
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SubCoordinator unexported [subcoord=" + this + "]"));
        }
        try {
            SubCoordinator.unexportObject((Remote)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getXaresIndex(XAResource xAResource) {
        XAResource xAResource2;
        int n;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("getXaresIndex xares= " + xAResource));
            TraceTm.jta.debug((Object)("resourceList.size= " + this.resourceList.size()));
        }
        int n2 = -1;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"search xares with same obj ref");
        }
        for (n = 0; n < this.resourceList.size(); ++n) {
            xAResource2 = (XAResource)this.resourceList.elementAt(n);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("res= " + xAResource2));
            }
            if (!xAResource2.equals(xAResource)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"not found -> search for xares with same RM");
            }
            for (n = 0; n < this.resourceList.size(); ++n) {
                xAResource2 = (XAResource)this.resourceList.elementAt(n);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("res= " + xAResource2));
                }
                try {
                    if (!xAResource2.isSameRM(xAResource)) continue;
                    n2 = n;
                    break;
                }
                catch (XAException xAException) {
                    if (!TraceTm.jta.isDebugEnabled()) continue;
                    String string = "res.isSameRm exception:" + xAException + "--" + xAException.getMessage();
                    TraceTm.jta.debug((Object)string);
                }
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xaresIndex= " + n2));
        }
        return n2;
    }
}

