/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.objectweb.jotm.Jotm;
import org.objectweb.jotm.TraceTimer;
import org.objectweb.transaction.jta.TMService;

public class Main
extends Thread {
    private static final String progname = "JOTM";
    private static Options cmdLineOptions = null;
    static boolean verbose = false;
    static boolean debug = false;
    static int timeout = 0;
    static boolean remote = false;
    static String userTransactionName = null;
    static String transactionManagerName = null;
    static Context ictx = null;
    static PrintWriter logWriter = new PrintWriter(System.out, true);
    private static TMService jotm;

    public void run() {
        System.out.print("shutting down...");
        try {
            ictx.unbind(userTransactionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ictx.unbind(transactionManagerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jotm.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        logWriter.close();
    }

    public static void printHelp(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("JOTM [options...]", options);
    }

    private static void verbose(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    private static void checkRegistryMessage() {
        System.err.println("Current JNDI settings are:");
        boolean bl = false;
        try {
            Hashtable<?, ?> hashtable = ictx.getEnvironment();
            Enumeration<?> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                System.err.println("- " + string + "=" + hashtable.get(string));
                bl = true;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (!bl) {
            System.err.println("JNDI properties are not set!");
        } else {
            System.err.println("Check that registry is running on a port matching JNDI properties");
        }
    }

    public static void main(String[] stringArray) {
        cmdLineOptions = new Options();
        cmdLineOptions.addOption("d", "debug", false, "debug mode");
        cmdLineOptions.addOption("v", "verbose", false, "verbose mode");
        cmdLineOptions.addOption("h", "help", false, "print this message and exit");
        cmdLineOptions.addOption("m", "transaction_manager", true, "JNDI URL of the TransactionManager");
        cmdLineOptions.addOption("r", "remote", false, "lookup remote transaction factory");
        cmdLineOptions.addOption("t", "timeout", true, "default transaction timeout (in seconds)");
        cmdLineOptions.addOption("u", "user_transaction", true, "JNDI URL of the UserTransaction");
        CommandLine commandLine = null;
        PosixParser posixParser = new PosixParser();
        try {
            commandLine = posixParser.parse(cmdLineOptions, stringArray, true);
        }
        catch (ParseException parseException) {
            System.err.println("\n" + parseException.getMessage());
            Main.printHelp(cmdLineOptions);
            System.err.println();
            System.exit(1);
        }
        debug = commandLine.hasOption('d');
        remote = commandLine.hasOption('r');
        verbose = commandLine.hasOption('v');
        if (commandLine.hasOption('h')) {
            Main.printHelp(cmdLineOptions);
            System.exit(1);
        }
        if (commandLine.hasOption('m')) {
            transactionManagerName = commandLine.getOptionValue('m');
        }
        if (commandLine.hasOption('t')) {
            try {
                timeout = Integer.parseInt(commandLine.getOptionValue('t'));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("\ntimeout is not a number");
                Main.printHelp(cmdLineOptions);
                System.err.println();
                System.exit(1);
            }
        }
        if (commandLine.hasOption('u')) {
            userTransactionName = commandLine.getOptionValue('u');
        }
        Main.verbose("UserTransaction Name =" + userTransactionName);
        Main.verbose("TransactionManager Name =" + transactionManagerName);
        Main.verbose("Transaction factory =" + (remote ? "remote" : "local"));
        Main.verbose("Default transaction timeout =" + timeout);
        TraceTimer.setLogWriter(logWriter);
        TraceTimer.setVerbose(verbose);
        TraceTimer.setDebug(debug);
        try {
            jotm = new Jotm(!remote, true);
        }
        catch (NamingException namingException) {
            System.out.println("unable to start JOTM!: " + namingException.getMessage());
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Main());
        try {
            ictx = new InitialContext();
        }
        catch (NamingException namingException) {
            System.err.println("No initial context: " + namingException.getExplanation());
            namingException.printStackTrace();
            System.exit(1);
        }
        try {
            if (userTransactionName != null) {
                ictx.rebind(userTransactionName, (Object)jotm.getUserTransaction());
                System.out.println("UserTransaction object bound in JNDI with name " + userTransactionName);
            }
            if (transactionManagerName != null) {
                ictx.rebind(transactionManagerName, (Object)jotm.getTransactionManager());
                System.out.println("TransactionManager object bound in JNDI with name " + transactionManagerName);
            }
        }
        catch (NamingException namingException) {
            System.err.println("UserTransaction rebind failed :" + namingException.getExplanation());
            namingException.printStackTrace();
            Main.checkRegistryMessage();
            System.exit(1);
        }
        System.out.print("JOTM is running...");
    }
}

