/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.jotm.JotmRecovery;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.TimerManager;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.XATerminatorImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;
import org.objectweb.transaction.jta.ResourceManagerEvent;
import org.objectweb.transaction.jta.TransactionManager;

public class Current
implements UserTransaction,
TransactionManager,
Referenceable,
Serializable {
    private static transient ThreadLocal threadTx = new ThreadLocal();
    private static transient Map txXids = Collections.synchronizedMap(new HashMap());
    private static transient Current unique = null;
    private static transient TimerManager timermgr = null;
    private static transient TransactionFactory tm = null;
    private static transient TransactionRecovery tr = null;
    private static final String JOTM_VERSION = "JOTM 2.0.10";
    private static final int DEFAULT_TIMEOUT = 60;
    private int defaultTimeout = 60;
    private int transactionTimeout = 60;
    private static final boolean DEFAULT_RECOVERY = false;
    private static boolean transactionRecovery = false;
    private transient int nb_bg_tx = 0;
    private transient int nb_rb_tx = 0;
    private transient int nb_cm_tx = 0;
    private transient int nb_to = 0;
    private transient ThreadLocal eventListStack = new ThreadLocal();

    public Current() {
        TraceTm.jta.info((Object)JOTM_VERSION);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"no args constructor");
        }
        unique = this;
        timermgr = TimerManager.getInstance();
        try {
            tr = new TransactionRecoveryImpl();
        }
        catch (Exception exception) {
            Current.setDefaultRecovery(false);
            TraceTm.recovery.error((Object)"Cannot open Howl Log");
            TraceTm.recovery.error((Object)"JOTM Recovery is being disabled");
        }
    }

    public Current(TransactionFactory transactionFactory) {
        TraceTm.jta.info((Object)JOTM_VERSION);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionFactory=" + transactionFactory));
        }
        unique = this;
        tm = transactionFactory;
        timermgr = TimerManager.getInstance();
        try {
            tr = new TransactionRecoveryImpl();
        }
        catch (Exception exception) {
            Current.setDefaultRecovery(false);
            TraceTm.recovery.error((Object)"Cannot open Howl Log");
            TraceTm.recovery.error((Object)"JOTM Recovery is being disabled");
        }
    }

    public static TransactionManager getTransactionManager() {
        return unique;
    }

    public void begin() throws NotSupportedException, SystemException {
        block17: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"begin transaction");
            }
            TransactionImpl transactionImpl = (TransactionImpl)threadTx.get();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
            }
            if (transactionImpl != null) {
                if (txXids.containsValue(transactionImpl)) {
                    throw new NotSupportedException("Nested transactions not supported");
                }
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("Resetting current tx = " + transactionImpl + " since it is already completed."));
                }
            }
            XidImpl xidImpl = new XidImpl();
            transactionImpl = new TransactionImpl(xidImpl, this.transactionTimeout);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("tx=" + transactionImpl));
            }
            try {
                transactionImpl.doAttach(0x200000);
            }
            catch (RollbackException rollbackException) {
                TraceTm.jotm.error((Object)"doAttach: RollbackException");
                throw new SystemException("RollbackException in occured in begin() " + rollbackException.getMessage());
            }
            threadTx.set(transactionImpl);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
            }
            this.putTxXid(xidImpl, transactionImpl);
            if (timermgr != null) {
                transactionImpl.setTimer(timermgr.addTimer(transactionImpl, this.transactionTimeout, null, false));
            }
            Date date = new Date();
            transactionImpl.setTxDate(date.toString());
            Stack stack = (Stack)this.eventListStack.get();
            if (stack != null) {
                try {
                    List list = (List)stack.peek();
                    if (list != null) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ((ResourceManagerEvent)iterator.next()).enlistConnection(transactionImpl);
                        }
                    } else if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)"Current.begin called with null list");
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    if (!TraceTm.jta.isDebugEnabled()) break block17;
                    TraceTm.jta.debug((Object)"Current.begin called with empty stack");
                }
            }
        }
    }

    public void begin(javax.transaction.xa.Xid xid) throws NotSupportedException, SystemException {
        this.begin(xid, this.transactionTimeout);
    }

    public void begin(javax.transaction.xa.Xid xid, long l) throws NotSupportedException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("begin inflow transaction, timeout = " + l));
        }
        if (l <= 0L) {
            l = this.defaultTimeout;
        }
        TransactionImpl transactionImpl = (TransactionImpl)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
        }
        if (transactionImpl != null) {
            if (txXids.containsValue(transactionImpl)) {
                throw new NotSupportedException("Nested transactions not supported");
            }
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("Resetting current tx = " + transactionImpl + " since it is already completed."));
            }
        }
        XidImpl xidImpl = new XidImpl(xid);
        transactionImpl = new TransactionImpl(xidImpl, (int)l);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + transactionImpl));
        }
        threadTx.set(transactionImpl);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
        }
        this.putTxXid(xidImpl, transactionImpl);
        if (timermgr != null) {
            transactionImpl.setTimer(timermgr.addTimer(transactionImpl, (int)l, null, false));
        }
        Date date = new Date();
        transactionImpl.setTxDate(date.toString());
    }

    public XATerminator getXATerminator() throws XAException {
        XATerminatorImpl xATerminatorImpl;
        block2: {
            xATerminatorImpl = null;
            try {
                xATerminatorImpl = new XATerminatorImpl();
            }
            catch (XAException xAException) {
                if (!TraceTm.jta.isDebugEnabled()) break block2;
                TraceTm.jta.debug((Object)("Cannot create XATerminatorImpl" + xAException));
            }
        }
        return xATerminatorImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl transactionImpl;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"commit transaction ");
        }
        if ((transactionImpl = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for commit");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + transactionImpl));
        }
        try {
            transactionImpl.commit();
            Object var3_2 = null;
            threadTx.set(null);
            this.transactionTimeout = this.defaultTimeout;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            threadTx.set(null);
            this.transactionTimeout = this.defaultTimeout;
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set= null");
                TraceTm.jta.debug((Object)("reset timeout= " + this.defaultTimeout));
            }
            throw throwable;
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"threadTx.set= null");
            TraceTm.jta.debug((Object)("reset timeout= " + this.defaultTimeout));
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl transactionImpl;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.rollback()");
        }
        if ((transactionImpl = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for rollback");
        }
        threadTx.set(null);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"threadTx.set= null");
        }
        transactionImpl.rollback();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("reset timeout= " + this.defaultTimeout));
        }
        this.transactionTimeout = this.defaultTimeout;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl transactionImpl;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.setRollbackOnly()");
        }
        if ((transactionImpl = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for setRollbackOnly");
        }
        transactionImpl.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImpl transactionImpl;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.getStatus()");
        }
        if ((transactionImpl = (TransactionImpl)this.getTransaction()) == null) {
            return 6;
        }
        return transactionImpl.getStatus();
    }

    public void setTransactionTimeout(int n) throws SystemException {
        TransactionImpl transactionImpl;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("timeout= " + n));
        }
        if ((transactionImpl = (TransactionImpl)threadTx.get()) != null && txXids.containsValue(transactionImpl)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"Cannot reset transaction timeout, tx in execution");
            }
            return;
        }
        this.transactionTimeout = n > 0 ? n : this.defaultTimeout;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Resetting transaction timeout= " + this.transactionTimeout));
        }
    }

    public void setTransactionRecovery(boolean bl) throws SystemException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("recovery=" + bl));
        }
        transactionRecovery = bl ? bl : false;
    }

    public Transaction getTransaction() throws SystemException {
        Transaction transaction = (Transaction)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
            TraceTm.jta.debug((Object)("Transaction ret= " + transaction));
        }
        return transaction;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"resume transaction");
        }
        if (transaction == null) {
            TraceTm.jotm.error((Object)"resume: null arg.");
            throw new InvalidTransactionException("resume(null) is not valid");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + transaction));
        }
        Transaction transaction2 = (Transaction)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
        }
        if (transaction2 != null) {
            if (transaction2.equals(transaction)) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"nothing to do");
                }
                return;
            }
            TraceTm.jotm.error((Object)"resume: already associated with another transaction.");
            throw new IllegalStateException("the thread is already associated with another transaction.");
        }
        if (!(transaction instanceof TransactionImpl)) {
            TraceTm.jotm.error((Object)"resume: non TransactionImpl arg.");
            throw new InvalidTransactionException("resume(" + transaction.getClass().getName() + ") is not valid");
        }
        threadTx.set(transaction);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
        }
        try {
            ((TransactionImpl)transaction).doAttach(0x8000000);
        }
        catch (RollbackException rollbackException) {
            TraceTm.jotm.error((Object)"RollbackException occured in resume()");
            throw new SystemException("RollbackException in occured in resume() " + rollbackException.getMessage());
        }
    }

    public Transaction suspend() throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"suspend transaction");
        }
        TransactionImpl transactionImpl = (TransactionImpl)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
        }
        if (transactionImpl != null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("tx=" + transactionImpl));
            }
            transactionImpl.doDetach(0x2000000);
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set= null");
            }
        }
        return transactionImpl;
    }

    public void connectionOpened(ResourceManagerEvent resourceManagerEvent) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Current.connectionOpened " + this));
        }
        Vector<ResourceManagerEvent> vector = null;
        Stack<Vector<ResourceManagerEvent>> stack = (Stack<Vector<ResourceManagerEvent>>)this.eventListStack.get();
        if (stack == null) {
            stack = new Stack<Vector<ResourceManagerEvent>>();
            this.eventListStack.set(stack);
        } else {
            try {
                vector = (Vector<ResourceManagerEvent>)stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        if (vector == null) {
            vector = new Vector<ResourceManagerEvent>(1);
        }
        vector.add(resourceManagerEvent);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("list.add(event) = " + resourceManagerEvent));
        }
        stack.push(vector);
    }

    public void connectionClosed(ResourceManagerEvent resourceManagerEvent) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.connectionClosed, remove");
        }
        this.removeFromCurrentStack(resourceManagerEvent);
    }

    public void connectionErrorOccured(ResourceManagerEvent resourceManagerEvent) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.connectionErrorOccured");
        }
        this.removeFromCurrentStack(resourceManagerEvent);
    }

    private void removeFromCurrentStack(ResourceManagerEvent resourceManagerEvent) {
        Stack stack;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Current.removeFromCurrentStack " + resourceManagerEvent));
            TraceTm.jta.debug((Object)("Current = " + this));
        }
        if ((stack = (Stack)this.eventListStack.get()) == null) {
            return;
        }
        try {
            List list = (List)stack.peek();
            if (list != null) {
                list.remove(resourceManagerEvent);
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void pushThreadLocalRMEventList(List list) {
        Stack<List> stack;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.pushThreadLocalRMEventList");
        }
        if ((stack = (Stack<List>)this.eventListStack.get()) == null) {
            stack = new Stack<List>();
            this.eventListStack.set(stack);
        }
        stack.push(list);
    }

    public List popThreadLocalRMEventList() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.popThreadLocalRMEventList");
        }
        Stack stack = (Stack)this.eventListStack.get();
        return (List)stack.pop();
    }

    public Reference getReference() throws NamingException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.getReference()");
        }
        Reference reference = new Reference(this.getClass().getName(), "org.objectweb.jotm.UserTransactionFactory", null);
        Integer n = new Integer(this.transactionTimeout);
        reference.add(new StringRefAddr("jotm.timeout", n.toString()));
        return reference;
    }

    public static Current getCurrent() {
        return unique;
    }

    public static TransactionFactory getJTM() {
        if (tm == null) {
            TraceTm.jotm.error((Object)"Current: TMFactory is null!");
        }
        return tm;
    }

    public static TransactionRecovery getTransactionRecovery() {
        if (tr == null) {
            TraceTm.jotm.error((Object)"Current: Transaction Recovery is null!");
        }
        return tr;
    }

    public void setDefaultTimeout(int n) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("timeout= " + n));
        }
        if (n != 0) {
            this.defaultTimeout = n;
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("default timeout= " + this.defaultTimeout));
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public static void setDefaultRecovery(boolean bl) {
        TraceTm.recovery.info((Object)("Jotm Recovery= " + bl));
        transactionRecovery = bl;
    }

    public static boolean getDefaultRecovery() {
        return transactionRecovery;
    }

    public void setPropagationContext(TransactionContext transactionContext, boolean bl) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("pctx=" + transactionContext + ", isReply=" + bl));
        }
        if (transactionContext == null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"detach tx");
            }
            TransactionImpl transactionImpl = (TransactionImpl)threadTx.get();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
            }
            if (transactionImpl != null) {
                if (transactionImpl.isRemovable()) {
                    this.forgetTx(transactionImpl.getXid());
                }
                threadTx.set(null);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"threadTx.set= null");
                }
            }
            return;
        }
        Xid xid = transactionContext.getXid();
        TransactionImpl transactionImpl = this.getTxXid(xid);
        if (transactionImpl == null) {
            if (!bl) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"new Tx");
                }
                transactionImpl = new TransactionImpl(transactionContext);
                this.putTxXid(xid, transactionImpl);
                Date date = new Date();
                transactionImpl.setTxDate(date.toString());
            } else if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("unknown tx:" + xid));
            }
        } else if (bl) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("updating Xid=" + xid));
            }
            transactionImpl.updatePropagationContext(transactionContext);
        } else if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("transaction already known:" + xid));
        }
        if (!bl) {
            threadTx.set(transactionImpl);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
            }
        }
    }

    public TransactionContext getPropagationContext(boolean bl) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("hold=" + bl));
        }
        try {
            TransactionImpl transactionImpl = (TransactionImpl)this.getTransaction();
            if (transactionImpl != null) {
                return transactionImpl.getPropagationContext(bl);
            }
        }
        catch (SystemException systemException) {
            TraceTm.jotm.error((Object)"getPropagationContext system exception:", (Throwable)systemException);
        }
        return null;
    }

    public void forgetTx(Xid xid) {
        TransactionImpl transactionImpl = (TransactionImpl)txXids.get(xid);
        if (transactionImpl != null && transactionImpl.equals((TransactionImpl)threadTx.get())) {
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set = null");
            }
        }
        this.removeTxXid(xid);
    }

    public TransactionImpl getTxByXid(Xid xid) {
        TransactionImpl transactionImpl = (TransactionImpl)txXids.get(xid);
        return transactionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.transaction.xa.Xid[] getPreparedHeuristicXid() {
        Xid xid = null;
        int n = txXids.size();
        if (n == 0) {
            return null;
        }
        Vector<Xid> vector = new Vector<Xid>();
        Set set = txXids.keySet();
        Object object = txXids;
        synchronized (object) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TransactionImpl transactionImpl = (TransactionImpl)txXids.get(iterator.next());
                try {
                    if (transactionImpl.getStatus() != 2) continue;
                    xid = transactionImpl.getXid();
                    vector.add(xid);
                }
                catch (SystemException systemException) {
                    TraceTm.jotm.error((Object)"getPreparedHeuristicsXid system exception:", (Throwable)systemException);
                }
            }
        }
        object = JotmRecovery.getTxRecovered();
        return (javax.transaction.xa.Xid[])vector.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.transaction.xa.Xid[] getAllXid() {
        Xid xid = null;
        int n = txXids.size();
        if (n == 0) {
            return null;
        }
        Vector<Xid> vector = new Vector<Xid>();
        Set set = txXids.keySet();
        Map map = txXids;
        synchronized (map) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TransactionImpl transactionImpl = (TransactionImpl)txXids.get(iterator.next());
                xid = transactionImpl.getXid();
                vector.add(xid);
            }
        }
        return (javax.transaction.xa.Xid[])vector.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllTx() {
        int n = txXids.size();
        if (n == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Set set = txXids.keySet();
        String[] stringArray = txXids;
        synchronized (txXids) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                TransactionImpl transactionImpl = (TransactionImpl)txXids.get(iterator.next());
                try {
                    string = StatusHelper.getStatusName(transactionImpl.getStatus());
                }
                catch (SystemException systemException) {
                    string = "No State Defined";
                }
                List list = transactionImpl.getEnlistedXAResource();
                int n2 = list.size();
                if (n2 == 0) {
                    vector.add(transactionImpl.getTxDate() + "????" + transactionImpl.toString() + "????" + "NO Resource Defined" + "????" + string);
                    continue;
                }
                for (int i = 0; i < n2; ++i) {
                    vector.add(transactionImpl.getTxDate() + "????" + transactionImpl.toString() + "????" + list.get(i).toString() + "????" + string);
                }
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = vector.get(i).toString();
            }
            return stringArray;
        }
    }

    public String[] getAllRcTx() {
        Vector vector = null;
        JotmRecovery jotmRecovery = null;
        if (tr == null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"tr= null");
            }
            return null;
        }
        jotmRecovery = tr.getJotmRecovery();
        if (jotmRecovery == null) {
            return null;
        }
        vector = JotmRecovery.getTxRecovered();
        int n = vector.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("txcount= " + n));
        }
        if (n == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        TxRecovered txRecovered = null;
        for (int i = 0; i < n; ++i) {
            txRecovered = (TxRecovered)vector.elementAt(i);
            XidImpl xidImpl = new XidImpl(txRecovered.gettxxid());
            vector2.add(new String(txRecovered.gettxxid()) + "????" + ((Object)xidImpl).toString() + "????" + txRecovered.gettxdatetime() + "????" + txRecovered.getxidcount());
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = vector2.get(i).toString();
        }
        return stringArray;
    }

    public String[] getAllXaTx(String string) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        JotmRecovery jotmRecovery = null;
        if (tr == null) {
            return null;
        }
        jotmRecovery = tr.getJotmRecovery();
        if (jotmRecovery == null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"myjr= null");
            }
            return null;
        }
        Vector<String> vector = new Vector<String>();
        TxxidRecovered txxidRecovered = null;
        TxRecovered txRecovered = null;
        Vector vector2 = null;
        Vector vector3 = null;
        RmRegistration rmRegistration = null;
        String string2 = null;
        vector2 = JotmRecovery.getTxRecovered();
        int n2 = vector2.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("txcount= " + n2));
        }
        for (int i = 0; i < n2; ++i) {
            txRecovered = (TxRecovered)vector2.elementAt(i);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("gettxxid= " + new String(txRecovered.gettxxid())));
                TraceTm.recovery.debug((Object)("stx=" + string));
            }
            if (!new String(txRecovered.gettxxid()).equals(string)) continue;
            bl = true;
            break;
        }
        Vector vector4 = new Vector();
        RecoverRmInfo recoverRmInfo = null;
        vector3 = JotmRecovery.getRecoverRmInfo();
        String string3 = null;
        Vector vector5 = tr.getRmRegistration();
        if (bl) {
            n = txRecovered.getxidcount();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("myxacount= " + n));
            }
            for (int i = 0; i < n; ++i) {
                int n3;
                bl3 = false;
                bl2 = false;
                bl4 = false;
                txxidRecovered = txRecovered.getRecoverTxXidInfo(i);
                if (txxidRecovered == null) {
                    vector.add("NotFound????NotFound????NotFound????NotFound????NotFound");
                    continue;
                }
                int n4 = vector3.size();
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("rmiCount= " + n4));
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    recoverRmInfo = (RecoverRmInfo)vector3.elementAt(n3);
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)("getRecoverXaResName()= " + recoverRmInfo.getRecoverXaResName()));
                        TraceTm.recovery.debug((Object)("getRecoverxaresname()=" + txxidRecovered.getRecoverxaresname()));
                        TraceTm.recovery.debug((Object)("getRecoverXaRes()= " + new String(recoverRmInfo.getRecoverXaRes())));
                        TraceTm.recovery.debug((Object)("getRecoverxares()=" + new String(txxidRecovered.getRecoverxares())));
                    }
                    if (!new String(recoverRmInfo.getRecoverXaRes()).equals(new String(txxidRecovered.getRecoverxares()))) continue;
                    string3 = recoverRmInfo.getRecoverRm();
                    bl2 = true;
                    string2 = new String(txxidRecovered.getRecoverxares());
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug((Object)("myrm= " + string3));
                    TraceTm.recovery.debug((Object)("myxares= " + string2));
                    break;
                }
                if (!bl2) {
                    string3 = "NotFound";
                }
                if (vector5 == null) {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"vRmRegistration is null");
                    }
                    string2 = "NotRegistered";
                } else {
                    n3 = vector5.size();
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)("rmregcount= " + n3));
                    }
                    for (int j = 0; j < n3; ++j) {
                        rmRegistration = (RmRegistration)vector5.elementAt(j);
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug((Object)("myrm= " + string3));
                            TraceTm.recovery.debug((Object)("rmGetName= " + rmRegistration.rmGetName()));
                        }
                        if (!string3.equals(rmRegistration.rmGetName())) continue;
                        bl3 = true;
                        if (rmRegistration.rmGetXaRes() == null) {
                            string2 = "IsNull";
                            break;
                        }
                        string2 = rmRegistration.rmGetXaRes().toString();
                        bl4 = true;
                        if (!TraceTm.recovery.isDebugEnabled()) break;
                        TraceTm.recovery.debug((Object)("myxares= " + string2));
                        break;
                    }
                    if (!bl3) {
                        string2 = "NotRegistered";
                    }
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)("myxares= " + string2));
                    }
                }
                XidImpl xidImpl = new XidImpl(txxidRecovered.getRecoverxid());
                vector.add(string3 + "????" + string2 + "????" + new String(txxidRecovered.getRecoverxid()) + "????" + new String(((Object)xidImpl).toString()) + "????" + StatusHelper.getStatusName(txxidRecovered.getRecoverstatus()));
            }
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = vector.get(i).toString();
        }
        return stringArray;
    }

    public int actionXAResource(String string, String string2) {
        javax.transaction.xa.Xid[] xidArray;
        String string3;
        XAResource xAResource;
        block22: {
            int n;
            Vector vector = null;
            Object var5_4 = null;
            boolean bl = false;
            boolean bl2 = false;
            JotmRecovery jotmRecovery = null;
            RmRegistration rmRegistration = null;
            xAResource = null;
            if (tr == null) {
                return 0;
            }
            jotmRecovery = tr.getJotmRecovery();
            if (jotmRecovery == null) {
                return 0;
            }
            vector = tr.getRmRegistration();
            if (vector == null) {
                return 0;
            }
            String string4 = string2;
            int n2 = string4.indexOf(10);
            String string5 = string4.substring(0, n2);
            int n3 = string4.indexOf(10, n2 + 1);
            String string6 = string4.substring(n2 + 1, n3);
            int n4 = string4.indexOf(10, n3 + 1);
            string3 = string4.substring(n3 + 1, n4);
            String string7 = string4.substring(n4 + 1);
            int n5 = vector.size();
            for (n = 0; n < n5; ++n) {
                rmRegistration = (RmRegistration)vector.elementAt(n);
                if (!string5.equals(rmRegistration.rmGetName())) continue;
                xAResource = rmRegistration.rmGetXaRes();
                break;
            }
            n = 0;
            xidArray = new javax.transaction.xa.Xid[100];
            try {
                xidArray = xAResource.recover(n);
            }
            catch (XAException xAException) {
                if (!TraceTm.jta.isDebugEnabled()) break block22;
                TraceTm.recovery.debug((Object)("xaResource.recover call failed during recovery " + xAException.getMessage()));
            }
        }
        if (xidArray == null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"No XIDs to recover for Xares javaxid is null");
            }
            this.cleanuptxrecovery(string3);
            return 0;
        }
        if (xidArray.length == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("No XIDs to recover for Xares= " + xAResource));
            }
            this.cleanuptxrecovery(string3);
            return 0;
        }
        Xid[] xidArray2 = new Xid[xidArray.length];
        int n = 0;
        if (n < xidArray.length && xidArray[n] != null && new String(xidArray[n].toString()).equals(string3)) {
            if (string == "commit") {
                try {
                    xAResource.commit(xidArray[n], false);
                }
                catch (XAException xAException) {
                    TraceTm.recovery.error((Object)("Unable to commit Xid during Admin Recovery " + xAException.getMessage()));
                }
            } else if (string == "rollback") {
                try {
                    xAResource.rollback(xidArray[n]);
                }
                catch (XAException xAException) {
                    TraceTm.recovery.error((Object)("Unable to rollback Xid during Admin Recovery " + xAException.getMessage()));
                }
            } else if (string == "forget") {
                try {
                    xAResource.rollback(xidArray[n]);
                }
                catch (XAException xAException) {
                    TraceTm.recovery.error((Object)("Unable to rollback Xid during Admin Recovery " + xAException.getMessage()));
                }
            }
        }
        this.cleanuptxrecovery(string3);
        return 0;
    }

    private void cleanuptxrecovery(String string) {
        Vector vector = null;
        TxRecovered txRecovered = null;
        TxxidRecovered txxidRecovered = null;
        int n = 0;
        boolean bl = false;
        byte[] byArray = new byte[11];
        byte[][] byArray2 = new byte[1][11];
        byArray = "RR3JOTMDONE".getBytes();
        vector = JotmRecovery.getTxRecovered();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            txRecovered = (TxRecovered)vector.elementAt(i);
            n = txRecovered.getxidcount();
            for (n3 = 0; n3 < n; ++n3) {
                txxidRecovered = txRecovered.getRecoverTxXidInfo(n3);
                if (txxidRecovered == null || !string.equals(new String(txxidRecovered.getRecoverxid()))) continue;
                txxidRecovered.setRecoverstatus(3);
                bl = true;
                break;
            }
            n3 = 1;
            for (int j = 0; j < n; ++j) {
                txxidRecovered = txRecovered.getRecoverTxXidInfo(j);
                if (txxidRecovered.getRecoverstatus() == 3) continue;
                n3 = 0;
                break;
            }
            if (n3 != 0) {
                XACommittingTx xACommittingTx = txRecovered.getXACommittingTx();
                byArray2[0] = byArray;
                if (Current.getDefaultRecovery()) {
                    try {
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug((Object)"Done howl log, after admin action");
                        }
                        TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(byArray2, xACommittingTx);
                    }
                    catch (Exception exception) {
                        String string2 = "Cannot howlDoneLog:" + exception + "--" + exception.getMessage();
                        TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + string2));
                    }
                }
                vector.remove(i);
                break;
            }
            if (!bl) continue;
            return;
        }
    }

    public void associateThreadTx(Xid xid) {
        TransactionImpl transactionImpl = this.getTxXid(xid);
        threadTx.set(transactionImpl);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
        }
    }

    public void clearThreadTx() {
        TransactionImpl transactionImpl = (TransactionImpl)threadTx.get();
        if (transactionImpl != null) {
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set=null");
            }
        }
    }

    private void putTxXid(Xid xid, TransactionImpl transactionImpl) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Associate tx to xid (xid=" + xid + ")"));
        }
        txXids.put(xid, transactionImpl);
    }

    private TransactionImpl getTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("get tx from xid (xid=" + xid + ")"));
        }
        TransactionImpl transactionImpl = (TransactionImpl)txXids.get(xid);
        return transactionImpl;
    }

    private void removeTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("remove tx from xid (xid=" + xid + ")"));
        }
        txXids.remove(xid);
    }

    void forget() throws Exception {
        threadTx.set(null);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"threadTx.set= null");
        }
    }

    public int getTotalCurrentTransactions() {
        return txXids.size();
    }

    synchronized void incrementBeginCounter() {
        ++this.nb_bg_tx;
    }

    public int getTotalBegunTransactions() {
        return this.nb_bg_tx;
    }

    synchronized void incrementRollbackCounter() {
        ++this.nb_rb_tx;
    }

    public int getTotalRolledbackTransactions() {
        return this.nb_rb_tx;
    }

    synchronized void incrementCommitCounter() {
        ++this.nb_cm_tx;
    }

    public int getTotalCommittedTransactions() {
        return this.nb_cm_tx;
    }

    public synchronized void resetAllTxTotalCounters() {
        this.nb_bg_tx = 0;
        this.nb_cm_tx = 0;
        this.nb_rb_tx = 0;
        this.nb_to = 0;
    }

    synchronized void incrementExpiredCounter() {
        ++this.nb_to;
    }

    public int getTotalExpiredTransactions() {
        return this.nb_to;
    }

    public synchronized Integer[] getTransactionCounters() {
        Integer[] integerArray = new Integer[]{new Integer(txXids.size()), new Integer(this.nb_bg_tx), new Integer(this.nb_cm_tx), new Integer(this.nb_rb_tx), new Integer(this.nb_to)};
        return integerArray;
    }
}

