/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.Xid;
import org.objectweb.carol.rmi.exception.RmiUtility;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.HeuristicCommit;
import org.objectweb.jotm.HeuristicHazard;
import org.objectweb.jotm.HeuristicMixed;
import org.objectweb.jotm.HeuristicRollback;
import org.objectweb.jotm.InactiveException;
import org.objectweb.jotm.Log;
import org.objectweb.jotm.NotPreparedException;
import org.objectweb.jotm.RecoveryCoordinator;
import org.objectweb.jotm.RemoteSynchro;
import org.objectweb.jotm.Resource;
import org.objectweb.jotm.ResourceInfo;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TimerManager;
import org.objectweb.jotm.TraceTm;

public class ControlImpl
extends PortableRemoteObject
implements Control,
Resource,
Coordinator,
Terminator,
RecoveryCoordinator,
TimerEventListener {
    private List resourceList = new ArrayList();
    private List synchronizationList = new ArrayList();
    private int mystatus = 5;
    private boolean hasSupCoord = false;
    private TimerEvent mytimer = null;
    private Xid xid;
    private Log mylog;

    ControlImpl(int n, Xid xid, Object object) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("timeout=" + n + ", xid=" + xid + ", supco=" + object));
        }
        this.mystatus = 0;
        this.xid = xid;
        this.hasSupCoord = object != null;
        this.mytimer = TimerManager.getInstance().addTimer(this, n, new Integer(1), false);
        if (object != null) {
            try {
                if (!(object instanceof Coordinator)) {
                    throw new RemoteException("Not Implemented");
                }
                ((Coordinator)object).register_resource(this);
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"Cannot register sub-coordinator:\n", (Throwable)exception);
            }
        }
    }

    public Terminator get_terminator() throws RemoteException {
        return this;
    }

    public Coordinator get_coordinator() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.get_coordinator");
        }
        return this;
    }

    public int get_status() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.get_status()");
        }
        return this.mystatus;
    }

    public boolean is_same_transaction(Coordinator coordinator) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.is_same_transaction(Coordinator)");
        }
        String string = null;
        try {
            string = coordinator.get_transaction_name();
        }
        catch (Exception exception) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.error((Object)"ControlImpl.is_same_transaction() raised exception:\n", (Throwable)exception);
            }
            return false;
        }
        return string.equals(this.get_transaction_name());
    }

    public synchronized RecoveryCoordinator register_resource(Resource resource) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("resource=" + resource));
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 0: {
                this.resourceList.add(resource);
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"Resource registered");
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                TraceTm.jotm.error((Object)"ControlImpl.register_resource(): Transaction Rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new TransactionRolledbackException();
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.register_resource(): Transaction Inactive");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new InactiveException("Cannot register resource, status " + StatusHelper.getStatusName(this.mystatus));
            }
        }
        return this;
    }

    public synchronized void register_synchronization(RemoteSynchro remoteSynchro) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("sync=" + remoteSynchro));
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 0: {
                this.synchronizationList.add(remoteSynchro);
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.register_synchronization(): RemoteSynchro registered");
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                TraceTm.jotm.error((Object)"ControlImpl.register_synchronization(): Transaction Rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new TransactionRolledbackException();
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.register_synchronization(): Transaction Inactive");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new InactiveException("Cannot register synchronization, status " + StatusHelper.getStatusName(this.mystatus));
            }
        }
    }

    public synchronized void rollback_only() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 1: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.rollback_only(): Already marked rolledback");
                break;
            }
            case 0: {
                this.mystatus = 1;
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.rollback_only(): Marked rollback");
                break;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.rollback_only(): Inactive");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new InactiveException("Cannot rollback transaction, status " + StatusHelper.getStatusName(this.mystatus));
            }
        }
    }

    public String get_transaction_name() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.get_transaction_name()");
        }
        return this.xid.toString();
    }

    public synchronized void commit(boolean bl) throws RemoteException {
        int n;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + bl));
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        String string = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (this.mytimer != null) {
            this.mytimer.stop();
        }
        switch (this.mystatus) {
            case 0: {
                break;
            }
            case 3: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(boolean): already done");
                return;
            }
            case 4: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(boolean): already rolled back");
                this.completed(true);
                if (string == null || !string.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            case 1: {
                n = this.do_before_completion();
                if (n > 0) {
                    TraceTm.jotm.info((Object)"ControlImpl.commit(boolean): before completion error at rollback");
                }
                this.do_rollback(bl);
                this.completed(true);
                if (string == null || !string.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(boolean): bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                if (string == null || !string.equals("iiop")) {
                    throw new HeuristicMixed();
                }
                RmiUtility.rethrowRmiException((Exception)new HeuristicMixed());
            }
        }
        if (this.resourceList.size() == 1) {
            TraceTm.jotm.debug((Object)"1 resource");
            n = this.do_before_completion();
            if (n > 0) {
                TraceTm.jotm.info((Object)"before completion error -> rollback");
                this.do_rollback(bl);
                this.completed(true);
                if (string == null || !string.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            this.mystatus = 8;
            try {
                Resource resource = (Resource)this.resourceList.get(0);
                resource.commit_one_phase();
                this.mystatus = 3;
            }
            catch (TransactionRolledbackException transactionRolledbackException) {
                TraceTm.jotm.info((Object)"commit_one_phase = TransactionRolledbackException");
                this.mystatus = 4;
            }
            catch (HeuristicHazard heuristicHazard) {
                TraceTm.jotm.info((Object)"commit_one_phase = HeuristicException");
                this.mystatus = 5;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                TraceTm.jotm.info((Object)"commit_one_phase = NoSuchObjectException");
                this.mystatus = 4;
            }
            catch (ServerException serverException) {
                TraceTm.jotm.info((Object)("commit_one_phase = ServerException: " + serverException));
                this.mystatus = 4;
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"commit_one_phase = Unexpected exception: ", (Throwable)exception);
                this.mystatus = 5;
            }
            this.do_after_completion();
            switch (this.mystatus) {
                case 3: {
                    this.completed(true);
                    break;
                }
                case 4: {
                    this.completed(true);
                    if (string == null || !string.equals("iiop")) {
                        throw new TransactionRolledbackException();
                    }
                    RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
                }
                case 5: {
                    this.completed(false);
                    if (!bl) break;
                    if (string == null || !string.equals("iiop")) {
                        throw new HeuristicHazard();
                    }
                    RmiUtility.rethrowRmiException((Exception)new HeuristicHazard());
                }
            }
            return;
        }
        n = this.do_prepare(bl);
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("Vote = " + n));
        }
        switch (n) {
            case 0: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.commit(boolean): committing Tx");
                break;
            }
            case 1: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.commit(boolean): rolling back Tx");
                }
                this.do_rollback(bl);
                this.completed(true);
                if (string == null || !string.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            case 2: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.commit(boolean): readonly resources");
                }
                this.mystatus = 3;
                this.completed(true);
                return;
            }
        }
        this.mylog.flushLog(1);
        if (this.do_commit(bl) == 0) {
            this.completed(true);
        } else {
            this.completed(false);
        }
    }

    public synchronized void rollback() throws RemoteException {
        int n;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        String string = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (this.mytimer != null) {
            this.mytimer.stop();
        }
        switch (this.mystatus) {
            case 0: 
            case 1: {
                break;
            }
            case 4: {
                TraceTm.jotm.error((Object)"ControlImpl.rollback(): already rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                return;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.rollback(): rollback: bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                this.completed(false);
                if (string == null || !string.equals("iiop")) {
                    throw new HeuristicMixed("rollback: bad status");
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
        }
        if (!this.hasSupCoord && (n = this.do_before_completion()) > 0) {
            TraceTm.jotm.info((Object)"ControlImpl.rollback(): before completion error at rollback");
        }
        try {
            this.do_rollback(false);
        }
        catch (Exception exception) {
            TraceTm.jotm.error((Object)"ControlImpl.rollback(): rollback raised exception ", (Throwable)exception);
        }
        this.completed(true);
    }

    public synchronized int prepare() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        if (this.mytimer != null) {
            this.mytimer.stop();
        }
        switch (this.mystatus) {
            case 0: {
                break;
            }
            case 3: {
                TraceTm.jotm.error((Object)"ControlImpl.prepare(): transaction already commited");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                return 0;
            }
            case 4: {
                TraceTm.jotm.error((Object)"ControlImpl.prepare(): transaction already rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                return 1;
            }
            case 1: {
                this.do_rollback(false);
                this.completed(true);
                return 1;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.prepare(): bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                this.completed(false);
                return 1;
            }
        }
        int n = this.do_prepare(false);
        switch (n) {
            case 0: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.prepare(): vote commit");
                break;
            }
            case 1: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.prepare(): vote rollback");
                }
                this.do_rollback(false);
                this.completed(true);
                return n;
            }
            case 2: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.prepare(): vote readonly");
                }
                this.mystatus = 3;
                this.completed(true);
                return n;
            }
        }
        return n;
    }

    public synchronized void commit() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 2: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(): commit: bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                this.completed(false);
                return;
            }
        }
        if (this.do_commit(true) == 0) {
            this.completed(true);
        } else {
            this.completed(false);
        }
    }

    public void commit_one_phase() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.commit_one_phase()");
        }
        this.commit(true);
    }

    public synchronized void forget() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.forget()");
        }
        this.completed(true);
    }

    public int replay_completion(Resource resource) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("res=" + resource));
        }
        return this.mystatus;
    }

    public void timeoutExpired(Object object) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("arg=" + object));
        }
        int n = (Integer)object;
        switch (n) {
            case 1: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.timeoutExpired(Object): timeout expired");
                }
                try {
                    this.do_rollback(false);
                }
                catch (Exception exception) {
                    TraceTm.jotm.error((Object)"ControlImpl.timeoutExpired(Object): rollback raised exception ", (Throwable)exception);
                }
                break;
            }
            case 2: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.timeoutExpired(Object): removing ControlImpl");
                }
                this.explicit_destroy();
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("ControlImpl.timeoutExpired(Object): timeoutExpired bad value=" + n));
            }
        }
    }

    void ding() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"");
        }
    }

    private int do_prepare(boolean bl) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + bl));
        }
        int n = 0;
        int n2 = 2;
        n = this.do_before_completion();
        if (n > 0) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"before_completion failed -> rollback");
            }
            return 1;
        }
        if (this.resourceList.size() == 0) {
            TraceTm.jotm.error((Object)"commit: no resource");
            this.mystatus = 3;
            this.do_after_completion();
            this.completed(true);
            return n2;
        }
        this.mylog = new Log();
        this.mystatus = 7;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            Resource resource = (Resource)this.resourceList.get(i);
            if (n > 0) {
                if (!TraceTm.jotm.isWarnEnabled()) break;
                TraceTm.jotm.warn((Object)"Vote stopped: at least one resource has voted rollback.");
                break;
            }
            try {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"send prepare to resource");
                }
                switch (resource.prepare()) {
                    case 0: {
                        this.mylog.addResource(resource);
                        TraceTm.jotm.info((Object)"Resource replied commit to prepare");
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        TraceTm.jotm.info((Object)"Resource replied rollback to prepare");
                        n2 = 1;
                        ++n;
                        break;
                    }
                    case 2: {
                        if (!TraceTm.jotm.isDebugEnabled()) break;
                        TraceTm.jotm.debug((Object)"Resource replied readonly to prepare");
                    }
                }
                continue;
            }
            catch (HeuristicHazard heuristicHazard) {
                TraceTm.jotm.error((Object)"HeuristicHazard on prepare");
                n2 = 1;
                ++n;
                continue;
            }
            catch (HeuristicMixed heuristicMixed) {
                TraceTm.jotm.error((Object)"HeuristicMixed on prepare");
                n2 = 1;
                ++n;
                continue;
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"exception on prepare: ", (Throwable)exception);
                n2 = 1;
                ++n;
            }
        }
        if (n2 == 2) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"All resources returned Readonly");
            }
            this.mystatus = 3;
            this.do_after_completion();
        }
        if (n2 == 0) {
            this.mystatus = 2;
        }
        if (TraceTm.jotm.isDebugEnabled() && TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("Vote = " + n2));
        }
        return n2;
    }

    private int do_commit(boolean bl) throws TransactionRolledbackException, HeuristicMixed, HeuristicHazard, HeuristicRollback {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + bl));
        }
        if (this.mylog == null) {
            TraceTm.jotm.error((Object)"no log");
            return -1;
        }
        this.mystatus = 8;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.mylog.resourceLogged.size(); ++i) {
            ResourceInfo resourceInfo = (ResourceInfo)this.mylog.resourceLogged.elementAt(i);
            if (resourceInfo.mystate != 2) {
                TraceTm.jotm.info((Object)"resource not prepared");
                continue;
            }
            if (n == 0 && n3 > 0) {
                try {
                    TraceTm.jotm.info((Object)"Send rollback to resource");
                    resourceInfo.getResource().rollback();
                    resourceInfo.mystate = 4;
                }
                catch (HeuristicCommit heuristicCommit) {
                    TraceTm.jotm.error((Object)"Heuristic commit");
                    resourceInfo.mystate = 5;
                    n4 = 5;
                    ++n;
                    ++n2;
                }
                catch (Exception exception) {
                    TraceTm.jotm.error((Object)"exception on rollback: ", (Throwable)exception);
                }
                continue;
            }
            try {
                TraceTm.jotm.debug((Object)"Send commit to resource");
                resourceInfo.getResource().commit();
                resourceInfo.mystate = 3;
                ++n;
                continue;
            }
            catch (HeuristicRollback heuristicRollback) {
                TraceTm.jotm.error((Object)"Heuristic Rollback");
                resourceInfo.mystate = 6;
                n4 = 6;
                ++n3;
                if (n <= 0) continue;
                ++n2;
                continue;
            }
            catch (HeuristicMixed heuristicMixed) {
                TraceTm.jotm.error((Object)"Heuristic Mixed");
                resourceInfo.mystate = 7;
                n4 = 7;
                ++n3;
                ++n;
                ++n2;
                continue;
            }
            catch (HeuristicHazard heuristicHazard) {
                TraceTm.jotm.error((Object)"Heuristic Hazard");
                resourceInfo.mystate = 8;
                n4 = 8;
                ++n3;
                ++n;
                ++n2;
                continue;
            }
            catch (NotPreparedException notPreparedException) {
                TraceTm.jotm.error((Object)"Resource Not Prepared");
                resourceInfo.mystate = 1;
                ++n3;
                continue;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                TraceTm.jotm.error((Object)"invalid objref - assume committed");
                resourceInfo.mystate = 3;
                ++n;
                continue;
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"exception on commit: ", (Throwable)exception);
                ++n3;
            }
        }
        if (n3 == 0) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"transaction committed");
            }
            this.mystatus = 3;
            this.mylog.forgetLog();
            this.do_after_completion();
            return 0;
        }
        if (n2 == 0) {
            TraceTm.jotm.info((Object)"transaction rolled back");
            this.mystatus = 4;
            this.mylog.forgetLog();
            this.do_after_completion();
            throw new TransactionRolledbackException();
        }
        TraceTm.jotm.info((Object)"Heuristics must be logged");
        this.mystatus = 5;
        this.mylog.updateLog();
        this.do_after_completion();
        if (bl) {
            switch (n4) {
                case 6: {
                    throw new HeuristicRollback();
                }
                case 7: {
                    throw new HeuristicMixed();
                }
                case 8: {
                    throw new HeuristicHazard();
                }
            }
        }
        return -1;
    }

    private void do_rollback(boolean bl) throws HeuristicMixed {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + bl));
        }
        this.mystatus = 4;
        int n = 0;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            Resource resource = (Resource)this.resourceList.get(i);
            try {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"Send rollback to Resource");
                }
                resource.rollback();
                continue;
            }
            catch (HeuristicCommit heuristicCommit) {
                TraceTm.jotm.error((Object)"Rollback raised HeuristicCommit");
                ++n;
                continue;
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"Cannot rollback resource: ", (Throwable)exception);
            }
        }
        this.do_after_completion();
        if (n > 0 && bl) {
            throw new HeuristicMixed();
        }
    }

    private void explicit_destroy() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"");
        }
        try {
            ControlImpl.unexportObject((Remote)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void completed(boolean bl) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("removeit=" + bl));
        }
        if (this.mytimer != null) {
            if (bl) {
                this.mytimer.change(60L, new Integer(2));
            } else {
                this.mytimer.unset();
                this.mytimer = null;
            }
        }
    }

    private int do_before_completion() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.do_before_completion()");
            TraceTm.jotm.debug((Object)("synchronizationList.size()=" + this.synchronizationList.size()));
        }
        int n = 0;
        for (int i = 0; i < this.synchronizationList.size(); ++i) {
            RemoteSynchro remoteSynchro = (RemoteSynchro)this.synchronizationList.get(i);
            try {
                remoteSynchro.before_completion(this);
                continue;
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"before_completion raised exception ", (Throwable)exception);
                ++n;
            }
        }
        return n;
    }

    private void do_after_completion() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.do_after_completion()");
            TraceTm.jotm.debug((Object)("status=" + this.mystatus));
            TraceTm.jotm.debug((Object)("synchronizationList.size()=" + this.synchronizationList.size()));
        }
        for (int i = 0; i < this.synchronizationList.size(); ++i) {
            RemoteSynchro remoteSynchro = (RemoteSynchro)this.synchronizationList.get(i);
            try {
                remoteSynchro.after_completion(this, this.mystatus);
                continue;
            }
            catch (Exception exception) {
                TraceTm.jotm.error((Object)"after_completion raised exception ", (Throwable)exception);
            }
        }
    }
}

