/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class OpenSessionInViewInterceptor
extends HibernateAccessor
implements WebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    private boolean singleSession = true;

    public OpenSessionInViewInterceptor() {
        this.setFlushMode(0);
    }

    public void setSingleSession(boolean bl) {
        this.singleSession = bl;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void preHandle(WebRequest webRequest) throws DataAccessException {
        if (this.isSingleSession() && TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory()) || SessionFactoryUtils.isDeferredCloseActive(this.getSessionFactory())) {
            String string = this.getParticipateAttributeName();
            Integer n = (Integer)webRequest.getAttribute(string, 0);
            int n2 = n != null ? n + 1 : 1;
            webRequest.setAttribute(this.getParticipateAttributeName(), (Object)new Integer(n2), 0);
        } else if (this.isSingleSession()) {
            this.logger.debug((Object)"Opening single Hibernate Session in OpenSessionInViewInterceptor");
            Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
            this.applyFlushMode(session, false);
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)new SessionHolder(session)));
        } else {
            SessionFactoryUtils.initDeferredClose(this.getSessionFactory());
        }
    }

    public void postHandle(WebRequest webRequest, ModelMap modelMap) throws DataAccessException {
        if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
            this.logger.debug((Object)"Flushing single Hibernate Session in OpenSessionInViewInterceptor");
            try {
                this.flushIfNecessary(sessionHolder.getSession(), false);
            }
            catch (HibernateException hibernateException) {
                throw this.convertHibernateAccessException(hibernateException);
            }
        }
    }

    public void afterCompletion(WebRequest webRequest, Exception exception) throws DataAccessException {
        String string = this.getParticipateAttributeName();
        Integer n = (Integer)webRequest.getAttribute(string, 0);
        if (n != null) {
            if (n > 1) {
                webRequest.setAttribute(string, (Object)new Integer(n - 1), 0);
            } else {
                webRequest.removeAttribute(string, 0);
            }
        } else if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
            this.logger.debug((Object)"Closing single Hibernate Session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSession(sessionHolder.getSession());
        } else {
            SessionFactoryUtils.processDeferredClose(this.getSessionFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }
}

