/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";
    private boolean singleSession = true;
    private FlushMode flushMode = FlushMode.NEVER;
    static /* synthetic */ Class class$org$hibernate$SessionFactory;

    public void setSessionFactoryBeanName(String string) {
        this.sessionFactoryBeanName = string;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setSingleSession(boolean bl) {
        this.singleSession = bl;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    protected FlushMode getFlushMode() {
        return this.flushMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Object object;
        SessionFactory sessionFactory = this.lookupSessionFactory(httpServletRequest);
        boolean bl = false;
        if (this.isSingleSession()) {
            if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                bl = true;
            } else {
                this.logger.debug((Object)"Opening single Hibernate Session in OpenSessionInViewFilter");
                object = this.getSession(sessionFactory);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)new SessionHolder((Session)object)));
            }
        } else if (SessionFactoryUtils.isDeferredCloseActive(sessionFactory)) {
            bl = true;
        } else {
            SessionFactoryUtils.initDeferredClose(sessionFactory);
        }
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            if (!bl) {
                if (this.isSingleSession()) {
                    object = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)sessionFactory));
                    this.logger.debug((Object)"Closing single Hibernate Session in OpenSessionInViewFilter");
                    this.closeSession(((SessionHolder)((Object)object)).getSession(), sessionFactory);
                } else {
                    SessionFactoryUtils.processDeferredClose(sessionFactory);
                }
            }
        }
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest httpServletRequest) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        }
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)webApplicationContext.getBean(this.getSessionFactoryBeanName(), class$org$hibernate$SessionFactory == null ? (class$org$hibernate$SessionFactory = OpenSessionInViewFilter.class$("org.hibernate.SessionFactory")) : class$org$hibernate$SessionFactory);
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession(sessionFactory, true);
        FlushMode flushMode = this.getFlushMode();
        if (flushMode != null) {
            session.setFlushMode(flushMode);
        }
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.closeSession(session);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

