/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.support.AbstractLobType;

public class BlobSerializableType
extends AbstractLobType {
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 1024;
    static /* synthetic */ Class class$java$io$Serializable;

    public BlobSerializableType() {
    }

    protected BlobSerializableType(LobHandler lobHandler, TransactionManager transactionManager) {
        super(lobHandler, transactionManager);
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return class$java$io$Serializable == null ? (class$java$io$Serializable = BlobSerializableType.class$("java.io.Serializable")) : class$java$io$Serializable;
    }

    public boolean isMutable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deepCopy(Object object) throws HibernateException {
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            objectOutputStream.writeObject(object);
        }
        finally {
            objectOutputStream.close();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        try {
            object2 = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new HibernateException("Couldn't clone BLOB contents", (Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                throw new HibernateException("Couldn't clone BLOB contents", (Throwable)iOException);
            }
        }
        objectInputStream.close();
        return object2;
    }

    protected Object nullSafeGetInternal(ResultSet resultSet, String[] stringArray, Object object, LobHandler lobHandler) throws SQLException, IOException, HibernateException {
        InputStream inputStream = lobHandler.getBlobAsBinaryStream(resultSet, stringArray[0]);
        if (inputStream != null) {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            try {
                Object object2 = objectInputStream.readObject();
                return object2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new HibernateException("Could not deserialize BLOB contents", (Throwable)classNotFoundException);
            }
            finally {
                objectInputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nullSafeSetInternal(PreparedStatement preparedStatement, int n, Object object, LobCreator lobCreator) throws SQLException, IOException {
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                lobCreator.setBlobAsBytes(preparedStatement, n, byteArrayOutputStream.toByteArray());
            }
            finally {
                objectOutputStream.close();
            }
        } else {
            lobCreator.setBlobAsBytes(preparedStatement, n, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

