/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.hibernate.util.EqualsHelper;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobCreatorUtils;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public abstract class AbstractLobType
implements UserType {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final LobHandler lobHandler;
    private final TransactionManager jtaTransactionManager;

    protected AbstractLobType() {
        this(LocalSessionFactoryBean.getConfigTimeLobHandler(), LocalSessionFactoryBean.getConfigTimeTransactionManager());
    }

    protected AbstractLobType(LobHandler lobHandler, TransactionManager transactionManager) {
        this.lobHandler = lobHandler;
        this.jtaTransactionManager = transactionManager;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean equals(Object object, Object object2) throws HibernateException {
        return EqualsHelper.equals((Object)object, (Object)object2);
    }

    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    public Serializable disassemble(Object object) throws HibernateException {
        return (Serializable)object;
    }

    public Object assemble(Serializable serializable, Object object) throws HibernateException {
        return serializable;
    }

    public Object replace(Object object, Object object2, Object object3) throws HibernateException {
        return object;
    }

    public final Object nullSafeGet(ResultSet resultSet, String[] stringArray, Object object) throws HibernateException, SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        try {
            return this.nullSafeGetInternal(resultSet, stringArray, object, this.lobHandler);
        }
        catch (IOException iOException) {
            throw new HibernateException("I/O errors during LOB access", (Throwable)iOException);
        }
    }

    public final void nullSafeSet(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        LobCreator lobCreator = this.lobHandler.getLobCreator();
        try {
            this.nullSafeSetInternal(preparedStatement, n, object, lobCreator);
        }
        catch (IOException iOException) {
            throw new HibernateException("I/O errors during LOB access", (Throwable)iOException);
        }
        LobCreatorUtils.registerTransactionSynchronization((LobCreator)lobCreator, (TransactionManager)this.jtaTransactionManager);
    }

    protected abstract Object nullSafeGetInternal(ResultSet var1, String[] var2, Object var3, LobHandler var4) throws SQLException, IOException, HibernateException;

    protected abstract void nullSafeSetInternal(PreparedStatement var1, int var2, Object var3, LobCreator var4) throws SQLException, IOException, HibernateException;
}

