/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.annotation;

import org.hibernate.HibernateException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class AnnotationSessionFactoryBean
extends LocalSessionFactoryBean {
    private Class[] annotatedClasses;
    private String[] annotatedPackages;

    public AnnotationSessionFactoryBean() {
        this.setConfigurationClass(AnnotationConfiguration.class);
    }

    public void setConfigurationClass(Class clazz) {
        if (clazz == null || !AnnotationConfiguration.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("AnnotationSessionFactoryBean only supports AnnotationConfiguration or subclasses");
        }
        super.setConfigurationClass(clazz);
    }

    public void setAnnotatedClasses(Class[] classArray) {
        this.annotatedClasses = classArray;
    }

    public void setAnnotatedPackages(String[] stringArray) {
        this.annotatedPackages = stringArray;
    }

    protected final void postProcessConfiguration(Configuration configuration) throws HibernateException {
        int n;
        AnnotationConfiguration annotationConfiguration = (AnnotationConfiguration)configuration;
        if (this.annotatedClasses != null) {
            for (n = 0; n < this.annotatedClasses.length; ++n) {
                annotationConfiguration.addAnnotatedClass(this.annotatedClasses[n]);
            }
        }
        if (this.annotatedPackages != null) {
            for (n = 0; n < this.annotatedPackages.length; ++n) {
                annotationConfiguration.addPackage(this.annotatedPackages[n]);
            }
        }
        this.postProcessAnnotationConfiguration(annotationConfiguration);
    }

    protected void postProcessAnnotationConfiguration(AnnotationConfiguration annotationConfiguration) throws HibernateException {
    }
}

