/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionImplementor;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class SpringSessionSynchronization
extends TransactionSynchronizationAdapter
implements Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final SQLExceptionTranslator jdbcExceptionTranslator;
    private final boolean newSession;
    private boolean hibernateTransactionCompletion = false;
    private Transaction jtaTransaction;
    private boolean holderActive = true;

    public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator sQLExceptionTranslator, boolean bl) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.jdbcExceptionTranslator = sQLExceptionTranslator;
        this.newSession = bl;
        TransactionManager transactionManager = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (transactionManager != null) {
            this.hibernateTransactionCompletion = true;
            try {
                this.jtaTransaction = transactionManager.getTransaction();
            }
            catch (SystemException systemException) {
                throw new DataAccessResourceFailureException("Could not access JTA transaction", (Throwable)systemException);
            }
        }
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void beforeCommit(boolean bl) throws DataAccessException {
        if (!bl) {
            Session session = null;
            if (this.jtaTransaction != null) {
                session = this.sessionHolder.getSession(this.jtaTransaction);
            }
            if (session == null) {
                session = this.sessionHolder.getSession();
            }
            if (!session.getFlushMode().lessThan(FlushMode.COMMIT)) {
                try {
                    SessionFactoryUtils.logger.debug((Object)"Flushing Hibernate Session on transaction synchronization");
                    session.flush();
                }
                catch (HibernateException hibernateException) {
                    if (this.jdbcExceptionTranslator != null && hibernateException instanceof JDBCException) {
                        JDBCException jDBCException = (JDBCException)hibernateException;
                        throw this.jdbcExceptionTranslator.translate("Hibernate flushing: " + jDBCException.getMessage(), jDBCException.getSQL(), jDBCException.getSQLException());
                    }
                    throw SessionFactoryUtils.convertHibernateAccessException(hibernateException);
                }
            }
        }
    }

    public void beforeCompletion() {
        Session session;
        if (this.jtaTransaction != null && (session = this.sessionHolder.removeSession(this.jtaTransaction)) != null) {
            if (this.sessionHolder.isEmpty()) {
                if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
                    TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                }
                this.holderActive = false;
            }
            if (session != this.sessionHolder.getSession()) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            } else if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            return;
        }
        if (this.newSession) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.holderActive = false;
            if (this.hibernateTransactionCompletion) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(this.sessionHolder.getSession(), this.sessionFactory);
            }
        } else if (this.sessionHolder.getPreviousFlushMode() != null) {
            this.sessionHolder.getSession().setFlushMode(this.sessionHolder.getPreviousFlushMode());
        }
    }

    public void afterCompletion(int n) {
        if (!this.hibernateTransactionCompletion || !this.newSession) {
            Session session = this.sessionHolder.getSession();
            if (session instanceof SessionImplementor) {
                ((SessionImplementor)session).afterTransactionCompletion(n == 0, null);
            }
            if (this.newSession) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            }
        }
        if (!this.newSession && n != 0) {
            this.sessionHolder.getSession().clear();
        }
        if (this.sessionHolder.doesNotHoldNonDefaultSession()) {
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

