/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PropertyValueException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.core.CollectionFactory;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateJdbcException;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate3.HibernateQueryException;
import org.springframework.orm.hibernate3.HibernateSystemException;
import org.springframework.orm.hibernate3.LocalDataSourceConnectionProvider;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.SpringSessionSynchronization;
import org.springframework.transaction.jta.SpringJtaSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class SessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$hibernate3$SessionFactoryUtils == null ? (class$org$springframework$orm$hibernate3$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.hibernate3.SessionFactoryUtils")) : class$org$springframework$orm$hibernate3$SessionFactoryUtils));
    private static final ThreadLocal deferredCloseHolder = new ThreadLocal();
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$SessionFactoryUtils;

    public static DataSource getDataSource(SessionFactory sessionFactory) {
        ConnectionProvider connectionProvider;
        if (sessionFactory instanceof SessionFactoryImplementor && (connectionProvider = ((SessionFactoryImplementor)sessionFactory).getConnectionProvider()) instanceof LocalDataSourceConnectionProvider) {
            return ((LocalDataSourceConnectionProvider)connectionProvider).getDataSource();
        }
        return null;
    }

    public static SQLExceptionTranslator newJdbcExceptionTranslator(SessionFactory sessionFactory) {
        DataSource dataSource = SessionFactoryUtils.getDataSource(sessionFactory);
        if (dataSource != null) {
            return new SQLErrorCodeSQLExceptionTranslator(dataSource);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    public static TransactionManager getJtaTransactionManager(SessionFactory sessionFactory, org.hibernate.Session session) {
        SessionFactory sessionFactory2;
        SessionFactoryImplementor sessionFactoryImplementor = null;
        if (sessionFactory instanceof SessionFactoryImplementor) {
            sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        } else if (session != null && (sessionFactory2 = session.getSessionFactory()) instanceof SessionFactoryImplementor) {
            sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory2;
        }
        return sessionFactoryImplementor != null ? sessionFactoryImplementor.getTransactionManager() : null;
    }

    public static org.hibernate.Session getSession(SessionFactory sessionFactory, boolean bl) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, null, null, bl);
        }
        catch (HibernateException hibernateException) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)hibernateException);
        }
    }

    public static org.hibernate.Session getSession(SessionFactory sessionFactory, Interceptor interceptor, SQLExceptionTranslator sQLExceptionTranslator) throws DataAccessResourceFailureException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, interceptor, sQLExceptionTranslator, true);
        }
        catch (HibernateException hibernateException) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)hibernateException);
        }
    }

    public static org.hibernate.Session doGetSession(SessionFactory sessionFactory, boolean bl) throws HibernateException, IllegalStateException {
        return SessionFactoryUtils.doGetSession(sessionFactory, null, null, bl);
    }

    private static org.hibernate.Session doGetSession(SessionFactory sessionFactory, Interceptor interceptor, SQLExceptionTranslator sQLExceptionTranslator, boolean bl) throws HibernateException, IllegalStateException {
        SessionHolder sessionHolder;
        Session session;
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        SessionHolder sessionHolder2 = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder2 != null && !sessionHolder2.isEmpty()) {
            session = null;
            if (TransactionSynchronizationManager.isSynchronizationActive() && sessionHolder2.doesNotHoldNonDefaultSession()) {
                session = sessionHolder2.getValidatedSession();
                if (session != null && !sessionHolder2.isSynchronizedWithTransaction()) {
                    logger.debug((Object)"Registering Spring transaction synchronization for existing Hibernate Session");
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder2, sessionFactory, sQLExceptionTranslator, false));
                    sessionHolder2.setSynchronizedWithTransaction(true);
                    sessionHolder = session.getFlushMode();
                    if (sessionHolder.lessThan(FlushMode.COMMIT) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                        session.setFlushMode(FlushMode.AUTO);
                        sessionHolder2.setPreviousFlushMode((FlushMode)sessionHolder);
                    }
                }
            } else {
                session = SessionFactoryUtils.getJtaSynchronizedSession(sessionHolder2, sessionFactory, sQLExceptionTranslator);
            }
            if (session != null) {
                return session;
            }
        }
        logger.debug((Object)"Opening Hibernate Session");
        Session session2 = session = interceptor != null ? sessionFactory.openSession(interceptor) : sessionFactory.openSession();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering Spring transaction synchronization for new Hibernate Session");
            sessionHolder = sessionHolder2;
            if (sessionHolder == null) {
                sessionHolder = new SessionHolder((org.hibernate.Session)session);
            } else {
                sessionHolder.addSession((org.hibernate.Session)session);
            }
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setFlushMode(FlushMode.NEVER);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, sQLExceptionTranslator, true));
            sessionHolder.setSynchronizedWithTransaction(true);
            if (sessionHolder != sessionHolder2) {
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
            }
        } else {
            SessionFactoryUtils.registerJtaSynchronization((org.hibernate.Session)session, sessionFactory, sQLExceptionTranslator, sessionHolder2);
        }
        if (!bl && !SessionFactoryUtils.isSessionTransactional((org.hibernate.Session)session, sessionFactory)) {
            SessionFactoryUtils.closeSession((org.hibernate.Session)session);
            throw new IllegalStateException("No Hibernate Session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        return session;
    }

    private static org.hibernate.Session getJtaSynchronizedSession(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator sQLExceptionTranslator) throws DataAccessResourceFailureException {
        TransactionManager transactionManager = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (transactionManager != null) {
            try {
                int n;
                Transaction transaction = transactionManager.getTransaction();
                if (transaction != null && ((n = transaction.getStatus()) == 0 || n == 1)) {
                    org.hibernate.Session session = sessionHolder.getValidatedSession(transaction);
                    if (session == null && !sessionHolder.isSynchronizedWithTransaction() && (session = sessionHolder.getValidatedSession()) != null) {
                        logger.debug((Object)"Registering JTA transaction synchronization for existing Hibernate Session");
                        sessionHolder.addSession(transaction, session);
                        transaction.registerSynchronization((Synchronization)new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, sQLExceptionTranslator, false), transactionManager));
                        sessionHolder.setSynchronizedWithTransaction(true);
                        FlushMode flushMode = session.getFlushMode();
                        if (flushMode.lessThan(FlushMode.COMMIT)) {
                            session.setFlushMode(FlushMode.AUTO);
                            sessionHolder.setPreviousFlushMode(flushMode);
                        }
                    }
                    return session;
                }
                return sessionHolder.getValidatedSession();
            }
            catch (Throwable throwable) {
                throw new DataAccessResourceFailureException("Could not check JTA transaction", throwable);
            }
        }
        return sessionHolder.getValidatedSession();
    }

    private static void registerJtaSynchronization(org.hibernate.Session session, SessionFactory sessionFactory, SQLExceptionTranslator sQLExceptionTranslator, SessionHolder sessionHolder) {
        TransactionManager transactionManager = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, session);
        if (transactionManager != null) {
            try {
                int n;
                Transaction transaction = transactionManager.getTransaction();
                if (transaction != null && ((n = transaction.getStatus()) == 0 || n == 1)) {
                    logger.debug((Object)"Registering JTA transaction synchronization for new Hibernate Session");
                    SessionHolder sessionHolder2 = sessionHolder;
                    if (sessionHolder2 == null) {
                        sessionHolder2 = new SessionHolder(transaction, session);
                    } else {
                        sessionHolder2.addSession(transaction, session);
                    }
                    transaction.registerSynchronization((Synchronization)new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder2, sessionFactory, sQLExceptionTranslator, true), transactionManager));
                    sessionHolder2.setSynchronizedWithTransaction(true);
                    if (sessionHolder2 != sessionHolder) {
                        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder2));
                    }
                }
            }
            catch (Throwable throwable) {
                throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", throwable);
            }
        }
    }

    public static org.hibernate.Session getNewSession(SessionFactory sessionFactory) {
        return SessionFactoryUtils.getNewSession(sessionFactory, null);
    }

    public static org.hibernate.Session getNewSession(SessionFactory sessionFactory, Interceptor interceptor) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        try {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
            if (sessionHolder != null && !sessionHolder.isEmpty()) {
                if (interceptor != null) {
                    return sessionFactory.openSession(sessionHolder.getAnySession().connection(), interceptor);
                }
                return sessionFactory.openSession(sessionHolder.getAnySession().connection());
            }
            if (interceptor != null) {
                return sessionFactory.openSession(interceptor);
            }
            return sessionFactory.openSession();
        }
        catch (HibernateException hibernateException) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)hibernateException);
        }
    }

    public static String toString(org.hibernate.Session session) {
        return session.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(session));
    }

    public static boolean isSessionTransactional(org.hibernate.Session session, SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return sessionHolder != null && sessionHolder.containsSession(session);
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        SessionHolder sessionHolder;
        Assert.notNull((Object)query, (String)"No Query object specified");
        if (sessionFactory != null && (sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory))) != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static void applyTransactionTimeout(Criteria criteria, SessionFactory sessionFactory) {
        Assert.notNull((Object)criteria, (String)"No Criteria object specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertHibernateAccessException(HibernateException hibernateException) {
        if (hibernateException instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof SQLGrammarException) {
            return new InvalidDataAccessResourceUsageException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof DataException) {
            return new InvalidDataAccessResourceUsageException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof LockAcquisitionException) {
            return new CannotAcquireLockException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof ConstraintViolationException) {
            return new DataIntegrityViolationException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)hibernateException);
        }
        if (hibernateException instanceof PropertyValueException) {
            return new DataIntegrityViolationException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(hibernateException.getMessage(), (Throwable)hibernateException);
        }
        if (hibernateException instanceof QueryException) {
            return new HibernateQueryException((QueryException)hibernateException);
        }
        if (hibernateException instanceof UnresolvableObjectException) {
            return new HibernateObjectRetrievalFailureException((UnresolvableObjectException)hibernateException);
        }
        if (hibernateException instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)hibernateException);
        }
        if (hibernateException instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(hibernateException.getMessage(), 1);
        }
        if (hibernateException instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)hibernateException);
        }
        if (hibernateException instanceof StaleStateException) {
            return new HibernateOptimisticLockingFailureException((StaleStateException)hibernateException);
        }
        return new HibernateSystemException(hibernateException);
    }

    public static boolean isDeferredCloseActive(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        Map map = (Map)deferredCloseHolder.get();
        return map != null && map.containsKey(sessionFactory);
    }

    public static void initDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        logger.debug((Object)"Initializing deferred close of Hibernate Sessions");
        HashMap<SessionFactory, Set> hashMap = (HashMap<SessionFactory, Set>)deferredCloseHolder.get();
        if (hashMap == null) {
            hashMap = new HashMap<SessionFactory, Set>();
            deferredCloseHolder.set(hashMap);
        }
        hashMap.put(sessionFactory, CollectionFactory.createLinkedSetIfPossible((int)4));
    }

    public static void processDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        Map map = (Map)deferredCloseHolder.get();
        if (map == null || !map.containsKey(sessionFactory)) {
            throw new IllegalStateException("Deferred close not active for SessionFactory [" + sessionFactory + "]");
        }
        logger.debug((Object)"Processing deferred close of Hibernate Sessions");
        Set set = (Set)map.remove(sessionFactory);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SessionFactoryUtils.closeSession((org.hibernate.Session)iterator.next());
        }
        if (map.isEmpty()) {
            deferredCloseHolder.set(null);
        }
    }

    public static void releaseSession(org.hibernate.Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!SessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, sessionFactory);
        }
    }

    static void closeSessionOrRegisterDeferredClose(org.hibernate.Session session, SessionFactory sessionFactory) {
        Map map = (Map)deferredCloseHolder.get();
        if (map != null && sessionFactory != null && map.containsKey(sessionFactory)) {
            logger.debug((Object)"Registering Hibernate Session for deferred close");
            session.setFlushMode(FlushMode.NEVER);
            Set set = (Set)map.get(sessionFactory);
            set.add(session);
        } else {
            SessionFactoryUtils.closeSession(session);
        }
    }

    public static void closeSession(org.hibernate.Session session) {
        if (session != null) {
            logger.debug((Object)"Closing Hibernate Session");
            try {
                session.close();
            }
            catch (HibernateException hibernateException) {
                logger.debug((Object)"Could not close Hibernate Session", (Throwable)hibernateException);
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Unexpected exception on closing Hibernate Session", throwable);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

