/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.io.File;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.event.EventListeners;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.AbstractSessionFactoryBean;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.TypeDefinitionBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LocalSessionFactoryBean
extends AbstractSessionFactoryBean {
    private static final ThreadLocal configTimeDataSourceHolder = new ThreadLocal();
    private static final ThreadLocal configTimeTransactionManagerHolder = new ThreadLocal();
    private static final ThreadLocal configTimeLobHandlerHolder = new ThreadLocal();
    private Class configurationClass = class$org$hibernate$cfg$Configuration == null ? (class$org$hibernate$cfg$Configuration = LocalSessionFactoryBean.class$("org.hibernate.cfg.Configuration")) : class$org$hibernate$cfg$Configuration;
    private Resource[] configLocations;
    private Resource[] mappingLocations;
    private Resource[] cacheableMappingLocations;
    private Resource[] mappingJarLocations;
    private Resource[] mappingDirectoryLocations;
    private Properties hibernateProperties;
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = false;
    private TransactionManager jtaTransactionManager;
    private LobHandler lobHandler;
    private Interceptor entityInterceptor;
    private NamingStrategy namingStrategy;
    private TypeDefinitionBean[] typeDefinitions;
    private FilterDefinition[] filterDefinitions;
    private Properties entityCacheStrategies;
    private Properties collectionCacheStrategies;
    private Map eventListeners;
    private boolean schemaUpdate = false;
    private Configuration configuration;
    static /* synthetic */ Class class$org$hibernate$cfg$Configuration;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup;
    static /* synthetic */ Class class$org$hibernate$transaction$JTATransactionFactory;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider;

    public static DataSource getConfigTimeDataSource() {
        return (DataSource)configTimeDataSourceHolder.get();
    }

    public static TransactionManager getConfigTimeTransactionManager() {
        return (TransactionManager)configTimeTransactionManagerHolder.get();
    }

    public static LobHandler getConfigTimeLobHandler() {
        return (LobHandler)configTimeLobHandlerHolder.get();
    }

    public void setConfigurationClass(Class clazz) {
        if (clazz == null || !(class$org$hibernate$cfg$Configuration == null ? (class$org$hibernate$cfg$Configuration = LocalSessionFactoryBean.class$("org.hibernate.cfg.Configuration")) : class$org$hibernate$cfg$Configuration).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("configurationClass must be assignable to [org.hibernate.cfg.Configuration]");
        }
        this.configurationClass = clazz;
    }

    public void setConfigLocation(Resource resource) {
        this.configLocations = new Resource[]{resource};
    }

    public void setConfigLocations(Resource[] resourceArray) {
        this.configLocations = resourceArray;
    }

    public void setMappingResources(String[] stringArray) {
        this.mappingLocations = new Resource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.mappingLocations[i] = new ClassPathResource(stringArray[i].trim());
        }
    }

    public void setMappingLocations(Resource[] resourceArray) {
        this.mappingLocations = resourceArray;
    }

    public void setCacheableMappingLocations(Resource[] resourceArray) {
        this.cacheableMappingLocations = resourceArray;
    }

    public void setMappingJarLocations(Resource[] resourceArray) {
        this.mappingJarLocations = resourceArray;
    }

    public void setMappingDirectoryLocations(Resource[] resourceArray) {
        this.mappingDirectoryLocations = resourceArray;
    }

    public void setHibernateProperties(Properties properties) {
        this.hibernateProperties = properties;
    }

    public Properties getHibernateProperties() {
        if (this.hibernateProperties == null) {
            this.hibernateProperties = new Properties();
        }
        return this.hibernateProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUseTransactionAwareDataSource(boolean bl) {
        this.useTransactionAwareDataSource = bl;
    }

    public void setJtaTransactionManager(TransactionManager transactionManager) {
        this.jtaTransactionManager = transactionManager;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setEntityInterceptor(Interceptor interceptor) {
        this.entityInterceptor = interceptor;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setTypeDefinitions(TypeDefinitionBean[] typeDefinitionBeanArray) {
        this.typeDefinitions = typeDefinitionBeanArray;
    }

    public void setFilterDefinitions(FilterDefinition[] filterDefinitionArray) {
        this.filterDefinitions = filterDefinitionArray;
    }

    public void setEntityCacheStrategies(Properties properties) {
        this.entityCacheStrategies = properties;
    }

    public void setCollectionCacheStrategies(Properties properties) {
        this.collectionCacheStrategies = properties;
    }

    public void setEventListeners(Map map) {
        this.eventListeners = map;
    }

    public void setSchemaUpdate(boolean bl) {
        this.schemaUpdate = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionFactory buildSessionFactory() throws Exception {
        Configuration configuration = this.newConfiguration();
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.jtaTransactionManager != null) {
            configTimeTransactionManagerHolder.set(this.jtaTransactionManager);
        }
        if (this.lobHandler != null) {
            configTimeLobHandlerHolder.set(this.lobHandler);
        }
        try {
            Object object;
            Object object2;
            if (this.jtaTransactionManager != null) {
                configuration.setProperty("hibernate.transaction.manager_lookup_class", (class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup == null ? (class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate3.LocalTransactionManagerLookup")) : class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup).getName());
                configuration.setProperty("hibernate.transaction.factory_class", (class$org$hibernate$transaction$JTATransactionFactory == null ? (class$org$hibernate$transaction$JTATransactionFactory = LocalSessionFactoryBean.class$("org.hibernate.transaction.JTATransactionFactory")) : class$org$hibernate$transaction$JTATransactionFactory).getName());
            } else {
                configuration.setProperty("hibernate.connection.release_mode", ConnectionReleaseMode.ON_CLOSE.toString());
            }
            if (!this.isExposeTransactionAwareSessionFactory()) {
                configuration.setProperty("hibernate.current_session_context_class", "org.springframework.orm.hibernate3.SpringSessionContext");
            }
            if (this.entityInterceptor != null) {
                configuration.setInterceptor(this.entityInterceptor);
            }
            if (this.namingStrategy != null) {
                configuration.setNamingStrategy(this.namingStrategy);
            }
            if (this.typeDefinitions != null) {
                object2 = configuration.createMappings();
                for (int i = 0; i < this.typeDefinitions.length; ++i) {
                    object = this.typeDefinitions[i];
                    object2.addTypeDef(object.getTypeName(), object.getTypeClass(), object.getParameters());
                }
            }
            if (this.filterDefinitions != null) {
                for (int i = 0; i < this.filterDefinitions.length; ++i) {
                    configuration.addFilterDefinition(this.filterDefinitions[i]);
                }
            }
            if (this.configLocations != null) {
                for (int i = 0; i < this.configLocations.length; ++i) {
                    configuration.configure(this.configLocations[i].getURL());
                }
            }
            if (this.hibernateProperties != null) {
                configuration.addProperties(this.hibernateProperties);
            }
            if (this.dataSource != null) {
                boolean bl;
                boolean bl2 = bl = this.useTransactionAwareDataSource || this.dataSource instanceof TransactionAwareDataSourceProxy;
                configuration.setProperty("hibernate.connection.provider_class", bl ? (class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider == null ? (class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate3.TransactionAwareDataSourceConnectionProvider")) : class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider).getName() : (class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider == null ? (class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate3.LocalDataSourceConnectionProvider")) : class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider).getName());
            }
            if (this.mappingLocations != null) {
                for (int i = 0; i < this.mappingLocations.length; ++i) {
                    configuration.addInputStream(this.mappingLocations[i].getInputStream());
                }
            }
            if (this.cacheableMappingLocations != null) {
                for (int i = 0; i < this.cacheableMappingLocations.length; ++i) {
                    configuration.addCacheableFile(this.cacheableMappingLocations[i].getFile());
                }
            }
            if (this.mappingJarLocations != null) {
                for (int i = 0; i < this.mappingJarLocations.length; ++i) {
                    Resource resource = this.mappingJarLocations[i];
                    configuration.addJar(resource.getFile());
                }
            }
            if (this.mappingDirectoryLocations != null) {
                for (int i = 0; i < this.mappingDirectoryLocations.length; ++i) {
                    File file = this.mappingDirectoryLocations[i].getFile();
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("Mapping directory location [" + this.mappingDirectoryLocations[i] + "] does not denote a directory");
                    }
                    configuration.addDirectory(file);
                }
            }
            if (this.entityCacheStrategies != null) {
                object2 = this.entityCacheStrategies.propertyNames();
                while (object2.hasMoreElements()) {
                    String string = (String)object2.nextElement();
                    object = StringUtils.commaDelimitedListToStringArray((String)this.entityCacheStrategies.getProperty(string));
                    if (((String[])object).length > 1) {
                        configuration.setCacheConcurrencyStrategy(string, object[0], object[1]);
                        continue;
                    }
                    if (((String[])object).length <= 0) continue;
                    configuration.setCacheConcurrencyStrategy(string, object[0]);
                }
            }
            if (this.collectionCacheStrategies != null) {
                object2 = this.collectionCacheStrategies.propertyNames();
                while (object2.hasMoreElements()) {
                    String string = (String)object2.nextElement();
                    object = StringUtils.commaDelimitedListToStringArray((String)this.collectionCacheStrategies.getProperty(string));
                    if (((String[])object).length > 1) {
                        configuration.setCollectionCacheConcurrencyStrategy(string, object[0], object[1]);
                        continue;
                    }
                    if (((String[])object).length <= 0) continue;
                    configuration.setCollectionCacheConcurrencyStrategy(string, object[0]);
                }
            }
            if (this.eventListeners != null) {
                object2 = this.eventListeners.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry entry = (Map.Entry)object2.next();
                    Assert.isTrue((boolean)(entry.getKey() instanceof String), (String)"Event listener key needs to be of type String");
                    object = (String)entry.getKey();
                    Object v = entry.getValue();
                    if (v instanceof Collection) {
                        Collection collection = (Collection)v;
                        EventListeners eventListeners = configuration.getEventListeners();
                        Object[] objectArray = (Object[])Array.newInstance(eventListeners.getListenerClassFor((String)object), collection.size());
                        objectArray = collection.toArray(objectArray);
                        configuration.setListeners((String)object, objectArray);
                        continue;
                    }
                    configuration.setListener((String)object, v);
                }
            }
            this.postProcessConfiguration(configuration);
            this.logger.info((Object)"Building new Hibernate SessionFactory");
            this.configuration = configuration;
            object2 = this.newSessionFactory(configuration);
            return object2;
        }
        finally {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
            if (this.jtaTransactionManager != null) {
                configTimeTransactionManagerHolder.set(null);
            }
            if (this.lobHandler != null) {
                configTimeLobHandlerHolder.set(null);
            }
        }
    }

    protected Configuration newConfiguration() throws HibernateException {
        return (Configuration)BeanUtils.instantiateClass((Class)this.configurationClass);
    }

    protected void postProcessConfiguration(Configuration configuration) throws HibernateException {
    }

    protected SessionFactory newSessionFactory(Configuration configuration) throws HibernateException {
        return configuration.buildSessionFactory();
    }

    public final Configuration getConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException("Configuration not initialized yet");
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterSessionFactoryCreation() throws Exception {
        if (this.schemaUpdate) {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(this.dataSource);
            }
            try {
                this.updateDatabaseSchema();
            }
            finally {
                if (this.dataSource != null) {
                    configTimeDataSourceHolder.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws HibernateException {
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        try {
            super.destroy();
        }
        finally {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
        }
    }

    public void dropDatabaseSchema() throws DataAccessException {
        this.logger.info((Object)"Dropping database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection connection = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)LocalSessionFactoryBean.this.getConfiguration().getProperties());
                String[] stringArray = LocalSessionFactoryBean.this.getConfiguration().generateDropSchemaScript(dialect);
                LocalSessionFactoryBean.this.executeSchemaScript(connection, stringArray);
                return null;
            }
        });
    }

    public void createDatabaseSchema() throws DataAccessException {
        this.logger.info((Object)"Creating database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection connection = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)LocalSessionFactoryBean.this.getConfiguration().getProperties());
                String[] stringArray = LocalSessionFactoryBean.this.getConfiguration().generateSchemaCreationScript(dialect);
                LocalSessionFactoryBean.this.executeSchemaScript(connection, stringArray);
                return null;
            }
        });
    }

    public void updateDatabaseSchema() throws DataAccessException {
        this.logger.info((Object)"Updating database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        hibernateTemplate.setFlushMode(0);
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection connection = session.connection();
                Dialect dialect = Dialect.getDialect((Properties)LocalSessionFactoryBean.this.getConfiguration().getProperties());
                DatabaseMetadata databaseMetadata = new DatabaseMetadata(connection, dialect);
                String[] stringArray = LocalSessionFactoryBean.this.getConfiguration().generateSchemaUpdateScript(dialect, databaseMetadata);
                LocalSessionFactoryBean.this.executeSchemaScript(connection, stringArray);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSchemaScript(Connection connection, String[] stringArray) throws SQLException {
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = connection.getAutoCommit();
            if (!bl) {
                connection.setAutoCommit(true);
            }
            try {
                Statement statement = connection.createStatement();
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.executeSchemaStatement(statement, stringArray[i]);
                    }
                }
                finally {
                    JdbcUtils.closeStatement((Statement)statement);
                }
            }
            finally {
                if (!bl) {
                    connection.setAutoCommit(false);
                }
            }
        }
    }

    protected void executeSchemaStatement(Statement statement, String string) throws SQLException {
        block3: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing schema statement: " + string));
            }
            try {
                statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn((Object)("Unsuccessful schema statement: " + string), (Throwable)sQLException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

