/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.classic.Session;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.impl.SessionImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ClassUtils;

public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
BeanFactoryAware,
InitializingBean {
    private static final boolean hibernateSetTimeoutAvailable = ClassUtils.hasMethod((Class)(class$org$hibernate$Transaction == null ? (class$org$hibernate$Transaction = HibernateTransactionManager.class$("org.hibernate.Transaction")) : class$org$hibernate$Transaction), (String)"setTimeout", (Class[])new Class[]{Integer.TYPE});
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private boolean prepareConnection = true;
    private Object entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SQLExceptionTranslator defaultJdbcExceptionTranslator;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$hibernate$Transaction;
    static /* synthetic */ Class class$org$hibernate$Interceptor;
    static /* synthetic */ Class class$org$hibernate$exception$GenericJDBCException;

    public HibernateTransactionManager() {
    }

    public HibernateTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean bl) {
        this.autodetectDataSource = bl;
    }

    public void setPrepareConnection(boolean bl) {
        this.prepareConnection = bl;
    }

    public void setEntityInterceptorBeanName(String string) {
        this.entityInterceptor = string;
    }

    public void setEntityInterceptor(Interceptor interceptor) {
        this.entityInterceptor = interceptor;
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptor instanceof Interceptor) {
            return (Interceptor)this.entityInterceptor;
        }
        if (this.entityInterceptor instanceof String) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            String string = (String)this.entityInterceptor;
            return (Interceptor)this.beanFactory.getBean(string, class$org$hibernate$Interceptor == null ? (class$org$hibernate$Interceptor = HibernateTransactionManager.class$("org.hibernate.Interceptor")) : class$org$hibernate$Interceptor);
        }
        return null;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator sQLExceptionTranslator) {
        this.jdbcExceptionTranslator = sQLExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        DataSource dataSource;
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
        if (this.entityInterceptor instanceof String && this.beanFactory == null) {
            throw new IllegalArgumentException("Property 'beanFactory' is required for 'entityInterceptorBeanName'");
        }
        if (this.autodetectDataSource && this.getDataSource() == null && (dataSource = SessionFactoryUtils.getDataSource(this.getSessionFactory())) != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using DataSource [" + dataSource + "] of Hibernate SessionFactory for HibernateTransactionManager"));
            }
            this.setDataSource(dataSource);
        }
    }

    public Object getResourceFactory() {
        return this.getSessionFactory();
    }

    protected Object doGetTransaction() {
        HibernateTransactionObject hibernateTransactionObject = new HibernateTransactionObject();
        hibernateTransactionObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound Session [" + SessionFactoryUtils.toString(sessionHolder.getSession()) + "] for Hibernate transaction"));
            }
            hibernateTransactionObject.setSessionHolder(sessionHolder, false);
        }
        if (this.getDataSource() != null) {
            ConnectionHolder connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.getDataSource());
            hibernateTransactionObject.setConnectionHolder(connectionHolder);
        }
        return hibernateTransactionObject;
    }

    protected boolean isExistingTransaction(Object object) {
        return ((HibernateTransactionObject)((Object)object)).hasTransaction();
    }

    protected void doBegin(Object object, TransactionDefinition transactionDefinition) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)((Object)object);
        if (hibernateTransactionObject.hasConnectionHolder() && !hibernateTransactionObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! HibernateTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single HibernateTransactionManager for all transactions on a single DataSource, no matter whether Hibernate or JDBC access.");
        }
        org.hibernate.Session session = null;
        try {
            Object object2;
            Object object3;
            if (hibernateTransactionObject.getSessionHolder() == null || hibernateTransactionObject.getSessionHolder().isSynchronizedWithTransaction()) {
                object3 = this.getEntityInterceptor();
                Session session2 = object2 = object3 != null ? this.getSessionFactory().openSession(object3) : this.getSessionFactory().openSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new Session [" + SessionFactoryUtils.toString((org.hibernate.Session)object2) + "] for Hibernate transaction"));
                }
                hibernateTransactionObject.setSessionHolder(new SessionHolder((org.hibernate.Session)object2), true);
            }
            hibernateTransactionObject.getSessionHolder().setSynchronizedWithTransaction(true);
            session = hibernateTransactionObject.getSessionHolder().getSession();
            if (this.prepareConnection && this.isSameConnectionForEntireSession(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Preparing JDBC Connection of Hibernate Session [" + SessionFactoryUtils.toString(session) + "]"));
                }
                object3 = session.connection();
                object2 = DataSourceUtils.prepareConnectionForTransaction((Connection)object3, (TransactionDefinition)transactionDefinition);
                hibernateTransactionObject.setPreviousIsolationLevel((Integer)object2);
            } else {
                if (transactionDefinition.getIsolationLevel() != -1) {
                    throw new InvalidIsolationLevelException("HibernateTransactionManager is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to 'on_close' (LocalSessionFactoryBean's default)");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Not preparing JDBC Connection of Hibernate Session [" + SessionFactoryUtils.toString(session) + "]"));
                }
            }
            if (transactionDefinition.isReadOnly() && hibernateTransactionObject.isNewSessionHolder()) {
                session.setFlushMode(FlushMode.NEVER);
            }
            if (!transactionDefinition.isReadOnly() && !hibernateTransactionObject.isNewSessionHolder() && (object3 = session.getFlushMode()).lessThan(FlushMode.COMMIT)) {
                session.setFlushMode(FlushMode.AUTO);
                hibernateTransactionObject.getSessionHolder().setPreviousFlushMode((FlushMode)object3);
            }
            object3 = null;
            int n = this.determineTimeout(transactionDefinition);
            if (n != -1) {
                if (hibernateSetTimeoutAvailable) {
                    object3 = session.getTransaction();
                    object3.setTimeout(n);
                    object3.begin();
                } else {
                    object3 = session.beginTransaction();
                    hibernateTransactionObject.getSessionHolder().setTimeoutInSeconds(n);
                }
            } else {
                object3 = session.beginTransaction();
            }
            hibernateTransactionObject.getSessionHolder().setTransaction((Transaction)object3);
            if (this.getDataSource() != null) {
                Connection connection = session.connection();
                ConnectionHolder connectionHolder = new ConnectionHolder(connection);
                if (n != -1) {
                    connectionHolder.setTimeoutInSeconds(n);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing Hibernate transaction as JDBC transaction [" + connection + "]"));
                }
                TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)connectionHolder);
                hibernateTransactionObject.setConnectionHolder(connectionHolder);
            }
            if (hibernateTransactionObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)hibernateTransactionObject.getSessionHolder()));
            }
        }
        catch (Exception exception) {
            SessionFactoryUtils.closeSession(session);
            throw new CannotCreateTransactionException("Could not open Hibernate Session for transaction", (Throwable)exception);
        }
    }

    protected Object doSuspend(Object object) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)((Object)object);
        hibernateTransactionObject.setSessionHolder(null, false);
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
        hibernateTransactionObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(Object object, Object object2) {
        SuspendedResourcesHolder suspendedResourcesHolder = (SuspendedResourcesHolder)object2;
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)suspendedResourcesHolder.getSessionHolder()));
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)suspendedResourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)((Object)defaultTransactionStatus.getTransaction());
        if (defaultTransactionStatus.isDebug()) {
            this.logger.debug((Object)("Committing Hibernate transaction on Session [" + SessionFactoryUtils.toString(hibernateTransactionObject.getSessionHolder().getSession()) + "]"));
        }
        try {
            hibernateTransactionObject.getSessionHolder().getTransaction().commit();
        }
        catch (TransactionException transactionException) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", (Throwable)transactionException);
        }
        catch (HibernateException hibernateException) {
            throw this.convertHibernateAccessException(hibernateException);
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)((Object)defaultTransactionStatus.getTransaction());
        if (defaultTransactionStatus.isDebug()) {
            this.logger.debug((Object)("Rolling back Hibernate transaction on Session [" + SessionFactoryUtils.toString(hibernateTransactionObject.getSessionHolder().getSession()) + "]"));
        }
        try {
            hibernateTransactionObject.getSessionHolder().getTransaction().rollback();
        }
        catch (TransactionException transactionException) {
            throw new TransactionSystemException("Could not roll back Hibernate transaction", (Throwable)transactionException);
        }
        catch (HibernateException hibernateException) {
            throw this.convertHibernateAccessException(hibernateException);
        }
        finally {
            if (!hibernateTransactionObject.isNewSessionHolder()) {
                hibernateTransactionObject.getSessionHolder().getSession().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus defaultTransactionStatus) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)((Object)defaultTransactionStatus.getTransaction());
        if (defaultTransactionStatus.isDebug()) {
            this.logger.debug((Object)("Setting Hibernate transaction on Session [" + SessionFactoryUtils.toString(hibernateTransactionObject.getSessionHolder().getSession()) + "] rollback-only"));
        }
        hibernateTransactionObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object object) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)((Object)object);
        if (hibernateTransactionObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        org.hibernate.Session session = hibernateTransactionObject.getSessionHolder().getSession();
        if (this.prepareConnection && session.isConnected() && this.isSameConnectionForEntireSession(session)) {
            try {
                Connection connection = session.connection();
                DataSourceUtils.resetConnectionAfterTransaction((Connection)connection, (Integer)hibernateTransactionObject.getPreviousIsolationLevel());
            }
            catch (HibernateException hibernateException) {
                this.logger.debug((Object)"Could not access JDBC Connection of Hibernate Session", (Throwable)hibernateException);
            }
        }
        if (hibernateTransactionObject.isNewSessionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Hibernate Session [" + SessionFactoryUtils.toString(session) + "] after transaction"));
            }
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not closing pre-bound Hibernate Session [" + SessionFactoryUtils.toString(session) + "] after transaction"));
            }
            if (hibernateTransactionObject.getSessionHolder().getPreviousFlushMode() != null) {
                session.setFlushMode(hibernateTransactionObject.getSessionHolder().getPreviousFlushMode());
            }
            if (hibernateSetTimeoutAvailable) {
                session.disconnect();
            }
        }
        hibernateTransactionObject.getSessionHolder().clear();
    }

    protected boolean isSameConnectionForEntireSession(org.hibernate.Session session) {
        if (!(session instanceof SessionImpl)) {
            return true;
        }
        ConnectionReleaseMode connectionReleaseMode = ((SessionImpl)session).getConnectionReleaseMode();
        return ConnectionReleaseMode.ON_CLOSE.equals(connectionReleaseMode);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException hibernateException) {
        if (this.getJdbcExceptionTranslator() != null && hibernateException instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)hibernateException, this.getJdbcExceptionTranslator());
        }
        if ((class$org$hibernate$exception$GenericJDBCException == null ? (class$org$hibernate$exception$GenericJDBCException = HibernateTransactionManager.class$("org.hibernate.exception.GenericJDBCException")) : class$org$hibernate$exception$GenericJDBCException).equals(((Object)((Object)hibernateException)).getClass())) {
            return this.convertJdbcAccessException((JDBCException)((GenericJDBCException)hibernateException), this.getDefaultJdbcExceptionTranslator());
        }
        return SessionFactoryUtils.convertHibernateAccessException(hibernateException);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException jDBCException, SQLExceptionTranslator sQLExceptionTranslator) {
        return sQLExceptionTranslator.translate("Hibernate flushing: " + jDBCException.getMessage(), jDBCException.getSQL(), jDBCException.getSQLException());
    }

    protected synchronized SQLExceptionTranslator getDefaultJdbcExceptionTranslator() {
        if (this.defaultJdbcExceptionTranslator == null) {
            this.defaultJdbcExceptionTranslator = this.getDataSource() != null ? new SQLErrorCodeSQLExceptionTranslator(this.getDataSource()) : SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.defaultJdbcExceptionTranslator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class HibernateTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;

        private HibernateTransactionObject() {
        }

        public void setSessionHolder(SessionHolder sessionHolder, boolean bl) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = bl;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean hasTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public void setRollbackOnly() {
            this.getSessionHolder().setRollbackOnly();
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.getSessionHolder().isRollbackOnly() || this.hasConnectionHolder() && this.getConnectionHolder().isRollbackOnly();
        }
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder connectionHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = connectionHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

