/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.engine.SessionImplementor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateOperations;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.util.Assert;

public class HibernateTemplate
extends HibernateAccessor
implements HibernateOperations {
    private boolean allowCreate = true;
    private boolean alwaysUseNewSession = false;
    private boolean exposeNativeSession = false;
    private boolean checkWriteOperations = true;
    private boolean cacheQueries = false;
    private String queryCacheRegion;
    private int fetchSize = 0;
    private int maxResults = 0;
    static /* synthetic */ Class class$org$hibernate$Session;
    static /* synthetic */ Class class$org$hibernate$engine$SessionImplementor;

    public HibernateTemplate() {
    }

    public HibernateTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public HibernateTemplate(SessionFactory sessionFactory, boolean bl) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(bl);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean bl) {
        this.allowCreate = bl;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAlwaysUseNewSession(boolean bl) {
        this.alwaysUseNewSession = bl;
    }

    public boolean isAlwaysUseNewSession() {
        return this.alwaysUseNewSession;
    }

    public void setExposeNativeSession(boolean bl) {
        this.exposeNativeSession = bl;
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    public void setCheckWriteOperations(boolean bl) {
        this.checkWriteOperations = bl;
    }

    public boolean isCheckWriteOperations() {
        return this.checkWriteOperations;
    }

    public void setCacheQueries(boolean bl) {
        this.cacheQueries = bl;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public void setQueryCacheRegion(String string) {
        this.queryCacheRegion = string;
    }

    public String getQueryCacheRegion() {
        return this.queryCacheRegion;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxResults(int n) {
        this.maxResults = n;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Object execute(HibernateCallback hibernateCallback) throws DataAccessException {
        return this.execute(hibernateCallback, this.isExposeNativeSession());
    }

    public List executeFind(HibernateCallback hibernateCallback) throws DataAccessException {
        Object object = this.execute(hibernateCallback, this.isExposeNativeSession());
        if (object != null && !(object instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from HibernateCallback isn't a List: [" + object + "]");
        }
        return (List)object;
    }

    public Object execute(HibernateCallback hibernateCallback, boolean bl) throws DataAccessException {
        Assert.notNull((Object)hibernateCallback, (String)"Callback object must not be null");
        Session session = this.getSession();
        boolean bl2 = SessionFactoryUtils.isSessionTransactional(session, this.getSessionFactory());
        if (bl2) {
            this.logger.debug((Object)"Found thread-bound Session for HibernateTemplate");
        }
        FlushMode flushMode = null;
        try {
            flushMode = this.applyFlushMode(session, bl2);
            this.enableFilters(session);
            Session session2 = bl ? session : this.createSessionProxy(session);
            Object object = hibernateCallback.doInHibernate(session2);
            this.flushIfNecessary(session, bl2);
            Object object2 = object;
            return object2;
        }
        catch (HibernateException hibernateException) {
            throw this.convertHibernateAccessException(hibernateException);
        }
        catch (SQLException sQLException) {
            throw this.convertJdbcAccessException(sQLException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        finally {
            if (bl2) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateTemplate");
                this.disableFilters(session);
                if (flushMode != null) {
                    session.setFlushMode(flushMode);
                }
            } else if (this.isAlwaysUseNewSession()) {
                SessionFactoryUtils.closeSession(session);
            } else {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
            }
        }
    }

    protected Session getSession() {
        if (this.isAlwaysUseNewSession()) {
            return SessionFactoryUtils.getNewSession(this.getSessionFactory(), this.getEntityInterceptor());
        }
        if (!this.isAllowCreate()) {
            return SessionFactoryUtils.getSession(this.getSessionFactory(), false);
        }
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }

    protected Session createSessionProxy(Session session) {
        Class[] classArray = null;
        classArray = session instanceof SessionImplementor ? new Class[]{class$org$hibernate$Session == null ? (class$org$hibernate$Session = HibernateTemplate.class$("org.hibernate.Session")) : class$org$hibernate$Session, class$org$hibernate$engine$SessionImplementor == null ? (class$org$hibernate$engine$SessionImplementor = HibernateTemplate.class$("org.hibernate.engine.SessionImplementor")) : class$org$hibernate$engine$SessionImplementor} : new Class[]{class$org$hibernate$Session == null ? (class$org$hibernate$Session = HibernateTemplate.class$("org.hibernate.Session")) : class$org$hibernate$Session};
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), classArray, (InvocationHandler)new CloseSuppressingInvocationHandler(session));
    }

    public Object get(Class clazz, Serializable serializable) throws DataAccessException {
        return this.get(clazz, serializable, null);
    }

    public Object get(final Class clazz, final Serializable serializable, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.get(clazz, serializable, lockMode);
                }
                return session.get(clazz, serializable);
            }
        }, true);
    }

    public Object get(String string, Serializable serializable) throws DataAccessException {
        return this.get(string, serializable, null);
    }

    public Object get(final String string, final Serializable serializable, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.get(string, serializable, lockMode);
                }
                return session.get(string, serializable);
            }
        }, true);
    }

    public Object load(Class clazz, Serializable serializable) throws DataAccessException {
        return this.load(clazz, serializable, null);
    }

    public Object load(final Class clazz, final Serializable serializable, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.load(clazz, serializable, lockMode);
                }
                return session.load(clazz, serializable);
            }
        }, true);
    }

    public Object load(String string, Serializable serializable) throws DataAccessException {
        return this.load(string, serializable, null);
    }

    public Object load(final String string, final Serializable serializable, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.load(string, serializable, lockMode);
                }
                return session.load(string, serializable);
            }
        }, true);
    }

    public List loadAll(final Class clazz) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(clazz);
                HibernateTemplate.this.prepareCriteria(criteria);
                return criteria.list();
            }
        }, true);
    }

    public void load(final Object object, final Serializable serializable) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.load(object, serializable);
                return null;
            }
        }, true);
    }

    public void refresh(Object object) throws DataAccessException {
        this.refresh(object, null);
    }

    public void refresh(final Object object, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    session.refresh(object, lockMode);
                } else {
                    session.refresh(object);
                }
                return null;
            }
        }, true);
    }

    public boolean contains(final Object object) throws DataAccessException {
        Boolean bl = (Boolean)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.contains(object) ? Boolean.TRUE : Boolean.FALSE;
            }
        }, true);
        return bl;
    }

    public void evict(final Object object) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.evict(object);
                return null;
            }
        }, true);
    }

    public void initialize(Object object) throws DataAccessException {
        try {
            Hibernate.initialize((Object)object);
        }
        catch (HibernateException hibernateException) {
            throw SessionFactoryUtils.convertHibernateAccessException(hibernateException);
        }
    }

    public Filter enableFilter(String string) throws IllegalStateException {
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), false);
        Filter filter = session.getEnabledFilter(string);
        if (filter == null) {
            filter = session.enableFilter(string);
        }
        return filter;
    }

    public void lock(final Object object, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(object, lockMode);
                return null;
            }
        }, true);
    }

    public void lock(final String string, final Object object, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(string, object, lockMode);
                return null;
            }
        }, true);
    }

    public Serializable save(final Object object) throws DataAccessException {
        return (Serializable)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(object);
            }
        }, true);
    }

    public Serializable save(final String string, final Object object) throws DataAccessException {
        return (Serializable)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(string, object);
            }
        }, true);
    }

    public void update(Object object) throws DataAccessException {
        this.update(object, null);
    }

    public void update(final Object object, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(object);
                if (lockMode != null) {
                    session.lock(object, lockMode);
                }
                return null;
            }
        }, true);
    }

    public void update(String string, Object object) throws DataAccessException {
        this.update(string, object, null);
    }

    public void update(final String string, final Object object, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(string, object);
                if (lockMode != null) {
                    session.lock(object, lockMode);
                }
                return null;
            }
        }, true);
    }

    public void saveOrUpdate(final Object object) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(object);
                return null;
            }
        }, true);
    }

    public void saveOrUpdate(final String string, final Object object) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(string, object);
                return null;
            }
        }, true);
    }

    public void saveOrUpdateAll(final Collection collection) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    session.saveOrUpdate(iterator.next());
                }
                return null;
            }
        }, true);
    }

    public void replicate(final Object object, final ReplicationMode replicationMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.replicate(object, replicationMode);
                return null;
            }
        }, true);
    }

    public void replicate(final String string, final Object object, final ReplicationMode replicationMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.replicate(string, object, replicationMode);
                return null;
            }
        }, true);
    }

    public void persist(final Object object) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.persist(object);
                return null;
            }
        }, true);
    }

    public void persist(final String string, final Object object) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.persist(string, object);
                return null;
            }
        }, true);
    }

    public Object merge(final Object object) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.merge(object);
            }
        }, true);
    }

    public Object merge(final String string, final Object object) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.merge(string, object);
            }
        }, true);
    }

    public void delete(Object object) throws DataAccessException {
        this.delete(object, null);
    }

    public void delete(final Object object, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                if (lockMode != null) {
                    session.lock(object, lockMode);
                }
                session.delete(object);
                return null;
            }
        }, true);
    }

    public void deleteAll(final Collection collection) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    session.delete(iterator.next());
                }
                return null;
            }
        }, true);
    }

    public void flush() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.flush();
                return null;
            }
        }, true);
    }

    public void clear() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                session.clear();
                return null;
            }
        }, true);
    }

    public List find(String string) throws DataAccessException {
        return this.find(string, null);
    }

    public List find(String string, Object object) throws DataAccessException {
        return this.find(string, new Object[]{object});
    }

    public List find(final String string, final Object[] objectArray) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        query.setParameter(i, objectArray[i]);
                    }
                }
                return query.list();
            }
        }, true);
    }

    public List findByNamedParam(String string, String string2, Object object) throws DataAccessException {
        return this.findByNamedParam(string, new String[]{string2}, new Object[]{object});
    }

    public List findByNamedParam(final String string, final String[] stringArray, final Object[] objectArray) throws DataAccessException {
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        HibernateTemplate.this.applyNamedParameterToQuery(query, stringArray[i], objectArray[i]);
                    }
                }
                return query.list();
            }
        }, true);
    }

    public List findByValueBean(final String string, final Object object) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                query.setProperties(object);
                return query.list();
            }
        }, true);
    }

    public List findByNamedQuery(String string) throws DataAccessException {
        return this.findByNamedQuery(string, null);
    }

    public List findByNamedQuery(String string, Object object) throws DataAccessException {
        return this.findByNamedQuery(string, new Object[]{object});
    }

    public List findByNamedQuery(final String string, final Object[] objectArray) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        query.setParameter(i, objectArray[i]);
                    }
                }
                return query.list();
            }
        }, true);
    }

    public List findByNamedQueryAndNamedParam(String string, String string2, Object object) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(string, new String[]{string2}, new Object[]{object});
    }

    public List findByNamedQueryAndNamedParam(final String string, final String[] stringArray, final Object[] objectArray) throws DataAccessException {
        if (stringArray != null && objectArray != null && stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        HibernateTemplate.this.applyNamedParameterToQuery(query, stringArray[i], objectArray[i]);
                    }
                }
                return query.list();
            }
        }, true);
    }

    public List findByNamedQueryAndValueBean(final String string, final Object object) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                query.setProperties(object);
                return query.list();
            }
        }, true);
    }

    public List findByCriteria(DetachedCriteria detachedCriteria) throws DataAccessException {
        return this.findByCriteria(detachedCriteria, -1, -1);
    }

    public List findByCriteria(final DetachedCriteria detachedCriteria, final int n, final int n2) throws DataAccessException {
        Assert.notNull((Object)detachedCriteria, (String)"DetachedCriteria must not be null");
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                HibernateTemplate.this.prepareCriteria(criteria);
                if (n >= 0) {
                    criteria.setFirstResult(n);
                }
                if (n2 > 0) {
                    criteria.setMaxResults(n2);
                }
                return criteria.list();
            }
        }, true);
    }

    public List findByExample(Object object) throws DataAccessException {
        return this.findByExample(object, -1, -1);
    }

    public List findByExample(final Object object, final int n, final int n2) throws DataAccessException {
        Assert.notNull((Object)object, (String)"Example entity must not be null");
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(object.getClass());
                criteria.add((Criterion)Example.create((Object)object));
                HibernateTemplate.this.prepareCriteria(criteria);
                if (n >= 0) {
                    criteria.setFirstResult(n);
                }
                if (n2 > 0) {
                    criteria.setMaxResults(n2);
                }
                return criteria.list();
            }
        }, true);
    }

    public Iterator iterate(String string) throws DataAccessException {
        return this.iterate(string, null);
    }

    public Iterator iterate(String string, Object object) throws DataAccessException {
        return this.iterate(string, new Object[]{object});
    }

    public Iterator iterate(final String string, final Object[] objectArray) throws DataAccessException {
        return (Iterator)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        query.setParameter(i, objectArray[i]);
                    }
                }
                return query.iterate();
            }
        }, true);
    }

    public void closeIterator(Iterator iterator) throws DataAccessException {
        try {
            Hibernate.close((Iterator)iterator);
        }
        catch (HibernateException hibernateException) {
            throw SessionFactoryUtils.convertHibernateAccessException(hibernateException);
        }
    }

    public int bulkUpdate(String string) throws DataAccessException {
        return this.bulkUpdate(string, null);
    }

    public int bulkUpdate(String string, Object object) throws DataAccessException {
        return this.bulkUpdate(string, new Object[]{object});
    }

    public int bulkUpdate(final String string, final Object[] objectArray) throws DataAccessException {
        Integer n = (Integer)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(string);
                HibernateTemplate.this.prepareQuery(query);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        query.setParameter(i, objectArray[i]);
                    }
                }
                return new Integer(query.executeUpdate());
            }
        }, true);
        return n;
    }

    protected void checkWriteOperationAllowed(Session session) throws InvalidDataAccessApiUsageException {
        if (this.isCheckWriteOperations() && this.getFlushMode() != 2 && session.getFlushMode().lessThan(FlushMode.COMMIT)) {
            throw new InvalidDataAccessApiUsageException("Write operations are not allowed in read-only mode (FlushMode.NEVER/MANUAL): Turn your Session into FlushMode.COMMIT/AUTO or remove 'readOnly' marker from transaction definition.");
        }
    }

    protected void prepareQuery(Query query) {
        if (this.isCacheQueries()) {
            query.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                query.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            query.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            query.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(query, this.getSessionFactory());
    }

    protected void prepareCriteria(Criteria criteria) {
        if (this.isCacheQueries()) {
            criteria.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                criteria.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            criteria.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            criteria.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(criteria, this.getSessionFactory());
    }

    protected void applyNamedParameterToQuery(Query query, String string, Object object) throws HibernateException {
        if (object instanceof Collection) {
            query.setParameterList(string, (Collection)object);
        } else if (object instanceof Object[]) {
            query.setParameterList(string, (Object[])object);
        } else {
            query.setParameter(string, object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingInvocationHandler(Session session) {
            this.target = session;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("equals")) {
                return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object object2 = method.invoke((Object)this.target, objectArray);
                if (object2 instanceof Query) {
                    HibernateTemplate.this.prepareQuery((Query)object2);
                }
                if (object2 instanceof Criteria) {
                    HibernateTemplate.this.prepareCriteria((Criteria)object2);
                }
                return object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }
}

