/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean bl) {
        this.exceptionConversionEnabled = bl;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Session session = this.getSession();
        boolean bl = SessionFactoryUtils.isSessionTransactional(session, this.getSessionFactory());
        if (bl) {
            this.logger.debug((Object)"Found thread-bound Session for HibernateInterceptor");
        } else {
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)new SessionHolder(session)));
        }
        FlushMode flushMode = null;
        try {
            flushMode = this.applyFlushMode(session, bl);
            this.enableFilters(session);
            Object object = methodInvocation.proceed();
            this.flushIfNecessary(session, bl);
            Object object2 = object;
            return object2;
        }
        catch (HibernateException hibernateException) {
            if (this.exceptionConversionEnabled) {
                throw this.convertHibernateAccessException(hibernateException);
            }
            throw hibernateException;
        }
        finally {
            if (bl) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateInterceptor");
                this.disableFilters(session);
                if (flushMode != null) {
                    session.setFlushMode(flushMode);
                }
            } else {
                TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
            }
        }
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }
}

