/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.exception.GenericJDBCException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class HibernateAccessor
implements InitializingBean,
BeanFactoryAware {
    public static final int FLUSH_NEVER = 0;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EAGER = 2;
    public static final int FLUSH_COMMIT = 3;
    public static final int FLUSH_ALWAYS = 4;
    private static final Constants constants = new Constants(class$org$springframework$orm$hibernate3$HibernateAccessor == null ? (class$org$springframework$orm$hibernate3$HibernateAccessor = HibernateAccessor.class$("org.springframework.orm.hibernate3.HibernateAccessor")) : class$org$springframework$orm$hibernate3$HibernateAccessor);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;
    private Object entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SQLExceptionTranslator defaultJdbcExceptionTranslator;
    private int flushMode = 1;
    private String[] filterNames;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$HibernateAccessor;
    static /* synthetic */ Class class$org$hibernate$Interceptor;
    static /* synthetic */ Class class$org$hibernate$exception$GenericJDBCException;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setEntityInterceptorBeanName(String string) {
        this.entityInterceptor = string;
    }

    public void setEntityInterceptor(Interceptor interceptor) {
        this.entityInterceptor = interceptor;
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptor instanceof String) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            return (Interceptor)this.beanFactory.getBean((String)this.entityInterceptor, class$org$hibernate$Interceptor == null ? (class$org$hibernate$Interceptor = HibernateAccessor.class$("org.hibernate.Interceptor")) : class$org$hibernate$Interceptor);
        }
        return (Interceptor)this.entityInterceptor;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator sQLExceptionTranslator) {
        this.jdbcExceptionTranslator = sQLExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void setFlushModeName(String string) {
        this.setFlushMode(constants.asNumber(string).intValue());
    }

    public void setFlushMode(int n) {
        this.flushMode = n;
    }

    public int getFlushMode() {
        return this.flushMode;
    }

    public void setFilterName(String string) {
        this.filterNames = new String[]{string};
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
    }

    protected FlushMode applyFlushMode(Session session, boolean bl) {
        if (this.getFlushMode() == 0) {
            if (bl) {
                FlushMode flushMode = session.getFlushMode();
                if (!flushMode.lessThan(FlushMode.COMMIT)) {
                    session.setFlushMode(FlushMode.NEVER);
                    return flushMode;
                }
            } else {
                session.setFlushMode(FlushMode.NEVER);
            }
        } else if (this.getFlushMode() == 2) {
            FlushMode flushMode;
            if (bl && !(flushMode = session.getFlushMode()).equals(FlushMode.AUTO)) {
                session.setFlushMode(FlushMode.AUTO);
                return flushMode;
            }
        } else if (this.getFlushMode() == 3) {
            if (bl) {
                FlushMode flushMode = session.getFlushMode();
                if (flushMode.equals(FlushMode.AUTO) || flushMode.equals(FlushMode.ALWAYS)) {
                    session.setFlushMode(FlushMode.COMMIT);
                    return flushMode;
                }
            } else {
                session.setFlushMode(FlushMode.COMMIT);
            }
        } else if (this.getFlushMode() == 4) {
            if (bl) {
                FlushMode flushMode = session.getFlushMode();
                if (!flushMode.equals(FlushMode.ALWAYS)) {
                    session.setFlushMode(FlushMode.ALWAYS);
                    return flushMode;
                }
            } else {
                session.setFlushMode(FlushMode.ALWAYS);
            }
        }
        return null;
    }

    protected void flushIfNecessary(Session session, boolean bl) throws HibernateException {
        if (this.getFlushMode() == 2 || !bl && this.getFlushMode() != 0) {
            this.logger.debug((Object)"Eagerly flushing Hibernate session");
            session.flush();
        }
    }

    public DataAccessException convertHibernateAccessException(HibernateException hibernateException) {
        if (this.getJdbcExceptionTranslator() != null && hibernateException instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)hibernateException, this.getJdbcExceptionTranslator());
        }
        if ((class$org$hibernate$exception$GenericJDBCException == null ? (class$org$hibernate$exception$GenericJDBCException = HibernateAccessor.class$("org.hibernate.exception.GenericJDBCException")) : class$org$hibernate$exception$GenericJDBCException).equals(hibernateException.getClass())) {
            return this.convertJdbcAccessException((JDBCException)((GenericJDBCException)hibernateException), this.getDefaultJdbcExceptionTranslator());
        }
        return SessionFactoryUtils.convertHibernateAccessException(hibernateException);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException jDBCException, SQLExceptionTranslator sQLExceptionTranslator) {
        return sQLExceptionTranslator.translate("Hibernate operation: " + jDBCException.getMessage(), jDBCException.getSQL(), jDBCException.getSQLException());
    }

    protected DataAccessException convertJdbcAccessException(SQLException sQLException) {
        SQLExceptionTranslator sQLExceptionTranslator = this.getJdbcExceptionTranslator();
        if (sQLExceptionTranslator == null) {
            sQLExceptionTranslator = this.getDefaultJdbcExceptionTranslator();
        }
        return sQLExceptionTranslator.translate("Hibernate-related JDBC operation", null, sQLException);
    }

    protected synchronized SQLExceptionTranslator getDefaultJdbcExceptionTranslator() {
        if (this.defaultJdbcExceptionTranslator == null) {
            this.defaultJdbcExceptionTranslator = SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.defaultJdbcExceptionTranslator;
    }

    protected void enableFilters(Session session) {
        String[] stringArray = this.getFilterNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                session.enableFilter(stringArray[i]);
            }
        }
    }

    protected void disableFilters(Session session) {
        String[] stringArray = this.getFilterNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                session.disableFilter(stringArray[i]);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

