/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class AbstractSessionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean exposeTransactionAwareSessionFactory = true;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$org$hibernate$SessionFactory;
    static /* synthetic */ Class class$org$hibernate$engine$SessionFactoryImplementor;

    public void setExposeTransactionAwareSessionFactory(boolean bl) {
        this.exposeTransactionAwareSessionFactory = bl;
    }

    protected boolean isExposeTransactionAwareSessionFactory() {
        return this.exposeTransactionAwareSessionFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator sQLExceptionTranslator) {
        this.jdbcExceptionTranslator = sQLExceptionTranslator;
    }

    public void afterPropertiesSet() throws Exception {
        SessionFactory sessionFactory = this.buildSessionFactory();
        this.sessionFactory = this.wrapSessionFactoryIfNecessary(sessionFactory);
        this.afterSessionFactoryCreation();
    }

    protected SessionFactory wrapSessionFactoryIfNecessary(SessionFactory sessionFactory) {
        if (this.isExposeTransactionAwareSessionFactory()) {
            return this.getTransactionAwareSessionFactoryProxy(sessionFactory);
        }
        return sessionFactory;
    }

    protected SessionFactory getTransactionAwareSessionFactoryProxy(SessionFactory sessionFactory) {
        Class clazz;
        Class clazz2 = clazz = class$org$hibernate$SessionFactory == null ? (class$org$hibernate$SessionFactory = AbstractSessionFactoryBean.class$("org.hibernate.SessionFactory")) : class$org$hibernate$SessionFactory;
        if (sessionFactory instanceof SessionFactoryImplementor) {
            clazz = class$org$hibernate$engine$SessionFactoryImplementor == null ? (class$org$hibernate$engine$SessionFactoryImplementor = AbstractSessionFactoryBean.class$("org.hibernate.engine.SessionFactoryImplementor")) : class$org$hibernate$engine$SessionFactoryImplementor;
        }
        return (SessionFactory)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new TransactionAwareInvocationHandler(sessionFactory));
    }

    protected final SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("SessionFactory not initialized yet");
        }
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws HibernateException {
        this.logger.info((Object)"Closing Hibernate SessionFactory");
        try {
            this.beforeSessionFactoryDestruction();
        }
        finally {
            this.sessionFactory.close();
        }
    }

    public Object getObject() {
        return this.sessionFactory;
    }

    public Class getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : (class$org$hibernate$SessionFactory == null ? (class$org$hibernate$SessionFactory = AbstractSessionFactoryBean.class$("org.hibernate.SessionFactory")) : class$org$hibernate$SessionFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException runtimeException) {
        if (runtimeException instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)runtimeException);
        }
        return null;
    }

    protected DataAccessException convertHibernateAccessException(HibernateException hibernateException) {
        if (this.jdbcExceptionTranslator != null && hibernateException instanceof JDBCException) {
            JDBCException jDBCException = (JDBCException)hibernateException;
            return this.jdbcExceptionTranslator.translate("Hibernate operation: " + jDBCException.getMessage(), jDBCException.getSQL(), jDBCException.getSQLException());
        }
        return SessionFactoryUtils.convertHibernateAccessException(hibernateException);
    }

    protected abstract SessionFactory buildSessionFactory() throws Exception;

    protected void afterSessionFactoryCreation() throws Exception {
    }

    protected void beforeSessionFactoryDestruction() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final SessionFactory target;

        public TransactionAwareInvocationHandler(SessionFactory sessionFactory) {
            this.target = sessionFactory;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("getCurrentSession")) {
                try {
                    return SessionFactoryUtils.doGetSession((SessionFactory)object, false);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new HibernateException(illegalStateException.getMessage());
                }
            }
            if (method.getName().equals("equals")) {
                return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            try {
                return method.invoke((Object)this.target, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }
}

