/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class SpringBindingActionForm
extends ActionForm {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$struts$SpringBindingActionForm == null ? (class$org$springframework$web$struts$SpringBindingActionForm = SpringBindingActionForm.class$("org.springframework.web.struts.SpringBindingActionForm")) : class$org$springframework$web$struts$SpringBindingActionForm));
    private static boolean defaultActionMessageAvailable = true;
    private Errors errors;
    private Locale locale;
    private MessageResources messageResources;
    static /* synthetic */ Class class$org$springframework$web$struts$SpringBindingActionForm;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$struts$action$ActionMessage;

    public void expose(Errors errors, HttpServletRequest httpServletRequest) {
        this.errors = errors;
        this.locale = (Locale)httpServletRequest.getSession().getAttribute("org.apache.struts.action.LOCALE");
        this.messageResources = (MessageResources)httpServletRequest.getAttribute("org.apache.struts.action.MESSAGE");
        if (errors != null && errors.hasErrors()) {
            ActionMessages actionMessages = (ActionMessages)httpServletRequest.getAttribute("org.apache.struts.action.ERROR");
            if (actionMessages == null) {
                httpServletRequest.setAttribute("org.apache.struts.action.ERROR", (Object)this.getActionMessages());
            } else {
                actionMessages.add(this.getActionMessages());
            }
        }
    }

    private ActionMessages getActionMessages() {
        ActionMessages actionMessages = new ActionMessages();
        Iterator iterator = this.errors.getAllErrors().iterator();
        while (iterator.hasNext()) {
            ActionMessage actionMessage;
            ObjectError objectError = (ObjectError)iterator.next();
            String string = this.findEffectiveMessageKey(objectError);
            if (string == null && !defaultActionMessageAvailable) {
                string = objectError.getCode();
            }
            ActionMessage actionMessage2 = actionMessage = string != null ? new ActionMessage(string, this.resolveArguments(objectError.getArguments())) : new ActionMessage(objectError.getDefaultMessage(), false);
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                actionMessages.add(fieldError.getField(), actionMessage);
                continue;
            }
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", actionMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Final ActionMessages used for binding: " + actionMessages));
        }
        return actionMessages;
    }

    private Object[] resolveArguments(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof MessageSourceResolvable)) continue;
            MessageSourceResolvable messageSourceResolvable = (MessageSourceResolvable)object;
            String[] stringArray = messageSourceResolvable.getCodes();
            boolean bl = false;
            if (this.messageResources != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    if (!this.messageResources.isPresent(this.locale, string)) continue;
                    objectArray[i] = this.messageResources.getMessage(this.locale, string, this.resolveArguments(messageSourceResolvable.getArguments()));
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            objectArray[i] = messageSourceResolvable.getDefaultMessage();
        }
        return objectArray;
    }

    private String findEffectiveMessageKey(ObjectError objectError) {
        if (this.messageResources != null) {
            String[] stringArray = objectError.getCodes();
            for (int i = 0; i < stringArray.length; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Looking for error code '" + stringArray[i] + "'"));
                }
                if (!this.messageResources.isPresent(this.locale, stringArray[i])) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found error code '" + stringArray[i] + "' in resource bundle"));
                }
                return stringArray[i];
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Could not find a suitable message error code, returning default message");
        }
        return null;
    }

    private Object getFieldValue(String string) throws NoSuchMethodException {
        if (this.errors == null) {
            throw new NoSuchMethodException("No bean properties exposed to Struts binding - performing Spring binding later on");
        }
        return this.errors.getFieldValue(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
        SpringBindingAwarePropertyUtilsBean springBindingAwarePropertyUtilsBean = new SpringBindingAwarePropertyUtilsBean();
        BeanUtilsBean beanUtilsBean = new BeanUtilsBean(convertUtilsBean, (PropertyUtilsBean)springBindingAwarePropertyUtilsBean);
        BeanUtilsBean.setInstance((BeanUtilsBean)beanUtilsBean);
        try {
            (class$org$apache$struts$action$ActionMessage == null ? (class$org$apache$struts$action$ActionMessage = SpringBindingActionForm.class$("org.apache.struts.action.ActionMessage")) : class$org$apache$struts$action$ActionMessage).getConstructor(class$java$lang$String == null ? (class$java$lang$String = SpringBindingActionForm.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            defaultActionMessageAvailable = false;
        }
    }

    private static class SpringBindingAwarePropertyUtilsBean
    extends PropertyUtilsBean {
        private SpringBindingAwarePropertyUtilsBean() {
        }

        public Object getNestedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (object instanceof SpringBindingActionForm) {
                SpringBindingActionForm springBindingActionForm = (SpringBindingActionForm)((Object)object);
                return springBindingActionForm.getFieldValue(string);
            }
            return super.getNestedProperty(object, string);
        }
    }
}

