/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.struts.ContextLoaderPlugIn;

public abstract class DelegatingActionUtils {
    public static final String PARAM_AUTOWIRE = "spring.autowire";
    public static final String PARAM_DEPENDENCY_CHECK = "spring.dependencyCheck";
    public static final String AUTOWIRE_BY_NAME = "byName";
    public static final String AUTOWIRE_BY_TYPE = "byType";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$struts$DelegatingActionUtils == null ? (class$org$springframework$web$struts$DelegatingActionUtils = DelegatingActionUtils.class$("org.springframework.web.struts.DelegatingActionUtils")) : class$org$springframework$web$struts$DelegatingActionUtils));
    static /* synthetic */ Class class$org$springframework$web$struts$DelegatingActionUtils;
    static /* synthetic */ Class class$org$springframework$web$struts$ContextLoaderPlugIn;

    public static WebApplicationContext getWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) {
        WebApplicationContext webApplicationContext = null;
        String string = null;
        if (moduleConfig != null) {
            string = moduleConfig.getPrefix();
            webApplicationContext = (WebApplicationContext)actionServlet.getServletContext().getAttribute(ContextLoaderPlugIn.SERVLET_CONTEXT_PREFIX + string);
        }
        if (webApplicationContext == null && !"".equals(string)) {
            webApplicationContext = (WebApplicationContext)actionServlet.getServletContext().getAttribute(ContextLoaderPlugIn.SERVLET_CONTEXT_PREFIX);
        }
        return webApplicationContext;
    }

    public static WebApplicationContext getRequiredWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) throws IllegalStateException {
        WebApplicationContext webApplicationContext = DelegatingActionUtils.getWebApplicationContext(actionServlet, moduleConfig);
        if (webApplicationContext == null) {
            throw new IllegalStateException("Could not find ContextLoaderPlugIn's WebApplicationContext as ServletContext attribute [" + ContextLoaderPlugIn.SERVLET_CONTEXT_PREFIX + "]: Did you register [" + (class$org$springframework$web$struts$ContextLoaderPlugIn == null ? (class$org$springframework$web$struts$ContextLoaderPlugIn = DelegatingActionUtils.class$("org.springframework.web.struts.ContextLoaderPlugIn")) : class$org$springframework$web$struts$ContextLoaderPlugIn).getName() + "]?");
        }
        return webApplicationContext;
    }

    public static WebApplicationContext findRequiredWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) throws IllegalStateException {
        WebApplicationContext webApplicationContext = DelegatingActionUtils.getWebApplicationContext(actionServlet, moduleConfig);
        if (webApplicationContext == null) {
            webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)actionServlet.getServletContext());
        }
        return webApplicationContext;
    }

    public static String determineActionBeanName(ActionMapping actionMapping) {
        String string = actionMapping.getModuleConfig().getPrefix();
        String string2 = actionMapping.getPath();
        String string3 = string + string2;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DelegatingActionProxy with mapping path '" + string2 + "' and module prefix '" + string + "' delegating to Spring bean with name [" + string3 + "]"));
        }
        return string3;
    }

    public static int getAutowireMode(ActionServlet actionServlet) {
        String string = actionServlet.getInitParameter(PARAM_AUTOWIRE);
        if (string != null) {
            if (AUTOWIRE_BY_NAME.equals(string)) {
                return 1;
            }
            if (!AUTOWIRE_BY_TYPE.equals(string)) {
                throw new IllegalArgumentException("ActionServlet 'autowire' parameter must be 'byName' or 'byType'");
            }
        }
        return 2;
    }

    public static boolean getDependencyCheck(ActionServlet actionServlet) {
        String string = actionServlet.getInitParameter(PARAM_DEPENDENCY_CHECK);
        return Boolean.valueOf(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

