/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.struts.ActionServletAwareProcessor;

public class ContextLoaderPlugIn
implements PlugIn {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$springframework$web$context$support$XmlWebApplicationContext == null ? (class$org$springframework$web$context$support$XmlWebApplicationContext = ContextLoaderPlugIn.class$("org.springframework.web.context.support.XmlWebApplicationContext")) : class$org$springframework$web$context$support$XmlWebApplicationContext;
    public static final String SERVLET_CONTEXT_PREFIX = (class$org$springframework$web$struts$ContextLoaderPlugIn == null ? (class$org$springframework$web$struts$ContextLoaderPlugIn = ContextLoaderPlugIn.class$("org.springframework.web.struts.ContextLoaderPlugIn")) : class$org$springframework$web$struts$ContextLoaderPlugIn).getName() + ".CONTEXT.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private ActionServlet actionServlet;
    private ModuleConfig moduleConfig;
    private WebApplicationContext webApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$support$XmlWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$struts$ContextLoaderPlugIn;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;
    static /* synthetic */ Class class$org$apache$struts$action$ActionServlet;

    public void setContextClassName(String string) throws ClassNotFoundException {
        this.contextClass = ClassUtils.forName((String)string);
    }

    public void setContextClass(Class clazz) {
        this.contextClass = clazz;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        if (this.actionServlet != null) {
            return this.actionServlet.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
        }
        return null;
    }

    public void setContextConfigLocation(String string) {
        this.contextConfigLocation = string;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public final void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        long l = System.currentTimeMillis();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ContextLoaderPlugIn for Struts ActionServlet '" + actionServlet.getServletName() + ", module '" + moduleConfig.getPrefix() + "': initialization started"));
        }
        this.actionServlet = actionServlet;
        this.moduleConfig = moduleConfig;
        try {
            this.webApplicationContext = this.initWebApplicationContext();
            this.onInit();
        }
        catch (RuntimeException runtimeException) {
            this.logger.error((Object)"Context initialization failed", (Throwable)runtimeException);
            throw runtimeException;
        }
        if (this.logger.isInfoEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            this.logger.info((Object)("ContextLoaderPlugIn for Struts ActionServlet '" + actionServlet.getServletName() + "', module '" + moduleConfig.getPrefix() + "': initialization completed in " + l2 + " ms"));
        }
    }

    public final ActionServlet getActionServlet() {
        return this.actionServlet;
    }

    public final String getServletName() {
        return this.actionServlet.getServletName();
    }

    public final ServletContext getServletContext() {
        return this.actionServlet.getServletContext();
    }

    public final ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public final String getModulePrefix() {
        return this.moduleConfig.getPrefix();
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException, IllegalStateException {
        this.getServletContext().log("Initializing WebApplicationContext for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "'");
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        WebApplicationContext webApplicationContext2 = this.createWebApplicationContext(webApplicationContext);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using context class '" + webApplicationContext2.getClass().getName() + "' for servlet '" + this.getServletName() + "'"));
        }
        String string = this.getServletContextAttributeName();
        this.getServletContext().setAttribute(string, (Object)webApplicationContext2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Published WebApplicationContext of Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "' as ServletContext attribute with name [" + string + "]"));
        }
        return webApplicationContext2;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext webApplicationContext) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ContextLoaderPlugIn for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "' will try to create custom WebApplicationContext " + "context of class '" + this.getContextClass().getName() + "', using parent context [" + webApplicationContext + "]"));
        }
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoaderPlugIn.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in ContextLoaderPlugIn for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "': custom WebApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext configurableWebApplicationContext = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)this.getContextClass());
        configurableWebApplicationContext.setParent((ApplicationContext)webApplicationContext);
        configurableWebApplicationContext.setServletContext(this.getServletContext());
        configurableWebApplicationContext.setNamespace(this.getNamespace());
        if (this.getContextConfigLocation() != null) {
            configurableWebApplicationContext.setConfigLocations(StringUtils.tokenizeToStringArray((String)this.getContextConfigLocation(), (String)",; \t\n"));
        }
        configurableWebApplicationContext.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
                configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)new ActionServletAwareProcessor(ContextLoaderPlugIn.this.getActionServlet()));
                configurableListableBeanFactory.ignoreDependencyType(class$org$apache$struts$action$ActionServlet == null ? (class$org$apache$struts$action$ActionServlet = ContextLoaderPlugIn.class$("org.apache.struts.action.ActionServlet")) : class$org$apache$struts$action$ActionServlet);
            }
        });
        configurableWebApplicationContext.refresh();
        return configurableWebApplicationContext;
    }

    public String getServletContextAttributeName() {
        return SERVLET_CONTEXT_PREFIX + this.getModulePrefix();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void onInit() throws ServletException {
    }

    public void destroy() {
        this.getServletContext().log("Closing WebApplicationContext of Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "'");
        if (this.getWebApplicationContext() instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.getWebApplicationContext()).close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

