/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.enhydra.jdbc.util.Logger;

public class LRUCache {
    private Hashtable cache = new Hashtable();
    private LinkedList lru = new LinkedList();
    private int maxSize;
    public Logger log;

    public LRUCache(int n) {
        this.maxSize = n;
    }

    public int LRUSize() {
        return this.lru.size();
    }

    public int cacheSize() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, Object object2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            while (this.cache.size() + 1 > this.maxSize) {
                arrayList.add(this.removeLRU());
            }
            if (this.cache.containsKey(object)) {
                this.lru.remove(object);
            }
            this.lru.addLast(object);
            this.cache.put(object, object2);
        }
        this.cleanupAll(arrayList);
    }

    public synchronized Object get(Object object) {
        if (!this.cache.containsKey(object)) {
            return null;
        }
        this.lru.remove(object);
        this.lru.addLast(object);
        return this.cache.get(object);
    }

    public synchronized Object remove(Object object) {
        if (!this.cache.containsKey(object)) {
            return null;
        }
        this.lru.remove(object);
        Object v = this.cache.remove(object);
        return v;
    }

    private synchronized Object removeLRU() {
        Object v = this.cache.remove(this.lru.getFirst());
        this.lru.removeFirst();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n) {
        if (n <= 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            this.maxSize = n;
            while (this.cache.size() > this.maxSize) {
                arrayList.add(this.removeLRU());
            }
        }
        this.cleanupAll(arrayList);
    }

    private void cleanupAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.cleanupObject(iterator.next());
        }
    }

    protected void cleanupObject(Object object) {
    }

    public void cleanupAll() {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            Object object = this.remove(enumeration.nextElement());
            this.cleanupObject(object);
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

