/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import javax.transaction.xa.Xid;
import org.enhydra.jdbc.standard.StandardXADataSource;

public class StandardXAStatefulConnection {
    public static int nextId;
    public int id;
    public Connection con;
    private int state;
    public StandardXADataSource dataSource;
    Xid xid;
    public boolean commitOnPrepare;
    long timeout;
    boolean timedOut;

    public StandardXAStatefulConnection(StandardXADataSource standardXADataSource, Connection connection) {
        this.con = connection;
        this.dataSource = standardXADataSource;
        this.id = ++nextId;
        this.state = 6;
        standardXADataSource.log.debug("StandardXAStatefulConnection created");
    }

    synchronized void setState(int n) {
        this.dataSource.log.debug("StandardXAStatefulConnection:setState Stateful connection: " + this.id + " (state before=" + this.state + ")");
        this.state = n;
        this.dataSource.log.debug("StandardXAStatefulConnection:setState Stateful connection: " + this.id + " (state after=" + this.state + ")");
    }

    int getState() {
        return this.state;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardXAStatefulConnection:\n");
        stringBuffer.append("     commit on prepare =<" + this.commitOnPrepare + ">\n");
        stringBuffer.append("     timed out =<" + this.timedOut + ">\n");
        stringBuffer.append("     id =<" + this.id + ">\n");
        stringBuffer.append("     state =<" + this.state + ">\n");
        stringBuffer.append("     time out =<" + this.timeout + ">\n");
        stringBuffer.append("     xid =<" + this.xid + ">\n");
        return stringBuffer.toString();
    }
}

