/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.standard.StandardConnectionPoolDataSource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXAStatefulConnection;
import org.enhydra.jdbc.util.Logger;

public class StandardXADataSource
extends StandardConnectionPoolDataSource
implements XADataSource {
    public int minCon = 50;
    public int maxCon = 0;
    public long deadLockMaxWait = 300000L;
    Vector freeConnections = new Vector(this.minCon, 1);
    Hashtable xidConnections = new Hashtable(this.minCon * 2, 0.5f);
    Hashtable deadConnections;
    public int connectionCount = 0;
    public long deadLockRetryWait = 10000L;
    public transient TransactionManager transactionManager;
    public static final int DEFAULT_MIN_CON = 50;
    public static final int DEFAULT_MAX_CON = 0;
    public static final long DEFAULT_DEADLOCKMAXWAIT = 300000L;
    public static final int DEFAULT_DEADLOCKRETRYWAIT = 10000;

    public StandardXADataSource() {
        this.log = new Logger(LogFactory.getLog((String)"org.enhydra.jdbc.xapool"));
        this.log.debug("StandardXADataSource is created");
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public Hashtable getXidConnections() {
        return this.xidConnections;
    }

    public XAConnection getXAConnection() throws SQLException {
        this.log.debug("StandardXADataSource:getXAConnection(0) XA connection returned");
        return this.getXAConnection(this.user, this.password);
    }

    public synchronized XAConnection getXAConnection(String string, String string2) throws SQLException {
        this.log.debug("StandardXADataSource:getXAConnection(user, password)");
        StandardXAConnection standardXAConnection = new StandardXAConnection(this, string, string2);
        standardXAConnection.setTransactionManager(this.transactionManager);
        standardXAConnection.setLogger(this.log);
        ++this.connectionCount;
        return standardXAConnection;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.log.debug("StandardXADataSource:setTransactionManager");
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setUser(String string) {
        this.log.debug("StandardXADataSource:setUser");
        if (string == null || this.getUser() == null ? string != this.getUser() : !string.equals(this.getUser())) {
            super.setUser(string);
            this.resetCache();
        }
    }

    public void setPassword(String string) {
        this.log.debug("StandardXADataSource:setPassword");
        if (string == null || this.getPassword() == null ? string != this.getPassword() : !string.equals(this.getPassword())) {
            super.setPassword(string);
            this.resetCache();
        }
    }

    public void setUrl(String string) {
        if (string == null || this.getUrl() == null ? string != this.getUrl() : !string.equals(this.getUrl())) {
            super.setUrl(string);
            this.resetCache();
        }
    }

    public void setDriverName(String string) throws SQLException {
        if (string == null && this.getDriverName() != null || !string.equals(this.getDriverName())) {
            super.setDriverName(string);
            this.resetCache();
        }
    }

    private synchronized void resetCache() {
        this.log.debug("StandardXADataSource:resetCache");
        this.deadConnections = (Hashtable)this.xidConnections.clone();
        this.deadConnections.putAll(this.xidConnections);
        Enumeration enumeration = this.freeConnections.elements();
        while (enumeration.hasMoreElements()) {
            StandardXAStatefulConnection standardXAStatefulConnection = (StandardXAStatefulConnection)enumeration.nextElement();
            try {
                this.log.debug("StandardXADataSource:resetCache closing Connection:" + standardXAStatefulConnection.con);
                standardXAStatefulConnection.con.close();
            }
            catch (SQLException sQLException) {
                this.log.error("StandardXADataSource:resetCache Error closing connection:" + standardXAStatefulConnection.con);
            }
            this.freeConnections.removeElement(standardXAStatefulConnection);
        }
    }

    synchronized void connectionClosed() throws SQLException {
        this.log.debug("StandardXADataSource:connectionClosed");
        --this.connectionCount;
        if (this.connectionCount == 0) {
            StandardXAStatefulConnection standardXAStatefulConnection;
            Object object;
            Enumeration enumeration = this.xidConnections.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                standardXAStatefulConnection = (StandardXAStatefulConnection)this.xidConnections.remove(object);
                if (standardXAStatefulConnection != null) {
                    standardXAStatefulConnection.con.close();
                }
                this.log.debug("StandardXADataSource:connectionClosed close physical connection");
            }
            object = this.freeConnections.iterator();
            while (object.hasNext()) {
                standardXAStatefulConnection = (StandardXAStatefulConnection)object.next();
                standardXAStatefulConnection.con.close();
                object.remove();
                this.log.debug("StandardXADataSource:connectionClosed close any free connections");
            }
        }
    }

    public int getXidCount() {
        int n = 0;
        Enumeration enumeration = this.xidConnections.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            StandardXAStatefulConnection standardXAStatefulConnection = (StandardXAStatefulConnection)v;
            if (standardXAStatefulConnection.getState() != 2 && standardXAStatefulConnection.getState() != 7) continue;
            ++n;
        }
        this.log.debug("StandardXADataSource:getXidCount return XidCount=<" + n + ">");
        return n;
    }

    Xid[] recover() {
        int n = this.getXidCount();
        Xid[] xidArray = new Xid[n];
        int n2 = 0;
        Enumeration enumeration = this.xidConnections.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            StandardXAStatefulConnection standardXAStatefulConnection = (StandardXAStatefulConnection)v;
            if (standardXAStatefulConnection.getState() != 2 && standardXAStatefulConnection.getState() != 7) continue;
            xidArray[n2++] = standardXAStatefulConnection.xid;
        }
        return xidArray;
    }

    public synchronized void freeConnection(Xid xid, boolean bl) {
        this.log.debug("StandardXADataSource:freeConnection");
        Object v = this.xidConnections.get(xid);
        StandardXAStatefulConnection standardXAStatefulConnection = (StandardXAStatefulConnection)v;
        this.xidConnections.remove(xid);
        this.log.debug("StandardXADataSource:freeConnection remove id from xidConnections");
        if (!this.deadConnections.containsKey(xid)) {
            standardXAStatefulConnection.setState(6);
            if (!this.freeConnections.contains(standardXAStatefulConnection)) {
                if (bl) {
                    this.freeConnections.insertElementAt(standardXAStatefulConnection, 0);
                } else {
                    this.freeConnections.addElement(standardXAStatefulConnection);
                }
            }
        } else {
            this.deadConnections.remove(xid);
            try {
                standardXAStatefulConnection.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.notify();
    }

    synchronized long checkTimeouts(long l) throws SQLException {
        long l2 = 0L;
        Enumeration enumeration = this.xidConnections.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            StandardXAStatefulConnection standardXAStatefulConnection = (StandardXAStatefulConnection)v;
            if (standardXAStatefulConnection.timeout != 0L && l > standardXAStatefulConnection.timeout) {
                standardXAStatefulConnection.con.rollback();
                standardXAStatefulConnection.timedOut = true;
                this.freeConnection(standardXAStatefulConnection.xid, true);
                continue;
            }
            if (standardXAStatefulConnection.timeout == 0L || standardXAStatefulConnection.timeout >= l2 && l2 != 0L) continue;
            l2 = standardXAStatefulConnection.timeout;
        }
        return l2;
    }

    private synchronized void checkTimeouts(Xid xid) throws XAException {
        this.log.debug("StandardXADataSource:checkTimeouts");
        for (int i = 0; i < this.freeConnections.size(); ++i) {
            Object e = this.freeConnections.elementAt(i);
            StandardXAStatefulConnection standardXAStatefulConnection = (StandardXAStatefulConnection)e;
            if (!standardXAStatefulConnection.timedOut) continue;
            this.log.debug("StandardXADataSource:checkTimeouts (" + i + "/" + this.freeConnections.size() + ") xid     = " + xid);
            this.log.debug("StandardXADataSource:checkTimeouts cur.xid = " + standardXAStatefulConnection.xid);
            if (!xid.equals(standardXAStatefulConnection.xid)) continue;
            standardXAStatefulConnection.timedOut = false;
            throw new XAException(106);
        }
    }

    synchronized StandardXAStatefulConnection getConnection(Xid xid, boolean bl) throws XAException {
        this.log.debug("StandardXADataSource:getConnection (xid=" + xid + ", mustFind=" + bl + ")");
        Object v = this.xidConnections.get(xid);
        this.log.debug("XID: " + v);
        StandardXAStatefulConnection standardXAStatefulConnection = (StandardXAStatefulConnection)v;
        if (bl) {
            if (standardXAStatefulConnection == null) {
                this.log.debug("StandardXADataSource:getConnection (StatefulConnection is null)");
                this.checkTimeouts(xid);
                throw new XAException(-4);
            }
        } else if (standardXAStatefulConnection != null) {
            throw new XAException(-8);
        }
        this.log.debug("StandardXADataSource:getConnection return connection associated with a given XID");
        return standardXAStatefulConnection;
    }

    synchronized StandardXAStatefulConnection getFreeConnection() throws SQLException {
        Object object;
        this.log.debug("StandardXADataSource:getFreeConnection");
        StandardXAStatefulConnection standardXAStatefulConnection = null;
        int n = this.freeConnections.size();
        if (n == 0) {
            this.log.debug("StandardXADataSource:getFreeConnection  there are no free connections, get a new database connection");
            object = super.getConnection(this.user, this.password);
            standardXAStatefulConnection = new StandardXAStatefulConnection(this, (Connection)object);
        } else {
            object = this.freeConnections.lastElement();
            standardXAStatefulConnection = (StandardXAStatefulConnection)object;
            this.freeConnections.removeElementAt(n - 1);
            standardXAStatefulConnection.timeout = 0L;
            standardXAStatefulConnection.timedOut = false;
        }
        this.log.debug("StandardXADataSource:getFreeConnection return a connection from the free list");
        try {
            this.log.debug("StandardXADataSource:getFreeConnection setAutoCommit(true)");
            standardXAStatefulConnection.con.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            this.log.error("StandardXADataSource:getFreeConnection ERROR: Failed while autocommiting a connection: " + sQLException);
        }
        return standardXAStatefulConnection;
    }

    public void closeFreeConnection() {
        this.log.debug("StandardXADataSource:closeFreeConnection empty method TBD");
    }

    public void setMinCon(int n) {
        this.minCon = n;
    }

    public void setMaxCon(int n) {
        this.maxCon = n;
    }

    public void setDeadLockMaxWait(long l) {
        this.deadLockMaxWait = l;
    }

    public int getMinCon() {
        return this.minCon;
    }

    public int getMaxCon() {
        return this.maxCon;
    }

    public long getDeadLockMaxWait() {
        return this.deadLockMaxWait;
    }

    public int getAllConnections() {
        return this.xidConnections.size() + this.freeConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processToWait() throws Exception {
        this.log.debug("StandardXADataSource:processToWait");
        int n = 0;
        if (this.maxCon != 0) {
            while (this.getAllConnections() >= this.maxCon && (long)n < this.getDeadLockMaxWait()) {
                this.dump();
                try {
                    StandardXADataSource standardXADataSource = this;
                    synchronized (standardXADataSource) {
                        this.wait(this.getDeadLockRetryWait());
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.log.error("StandardXADataSource:processToWait ERROR: Failed while waiting for an object: " + interruptedException);
                }
                n = (int)((long)n + this.getDeadLockRetryWait());
            }
            if (this.getAllConnections() >= this.getMaxCon()) {
                throw new Exception("StandardXADataSource:processToWait ERROR : impossible to obtain a new xa connection");
            }
        }
    }

    public void dump() {
        for (int i = 0; i < this.freeConnections.size(); ++i) {
            this.log.debug("freeConnection:<" + this.freeConnections.elementAt(i).toString() + ">");
        }
        Enumeration enumeration = this.xidConnections.elements();
        while (enumeration.hasMoreElements()) {
            this.log.debug("xidConnection:<" + enumeration.nextElement().toString() + ">");
        }
    }

    public void setDeadLockRetryWait(long l) {
        this.deadLockRetryWait = l;
    }

    public long getDeadLockRetryWait() {
        return this.deadLockRetryWait;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardXADataSource:\n");
        stringBuffer.append("     connection count=<" + this.connectionCount + ">\n");
        if (this.deadConnections != null) {
            stringBuffer.append("     number of dead connection=<" + this.deadConnections.size() + ">\n");
        }
        stringBuffer.append("     dead lock max wait=<" + this.deadLockMaxWait + ">\n");
        stringBuffer.append("     dead lock retry wait=<" + this.deadLockRetryWait + ">\n");
        if (this.driver != null) {
            stringBuffer.append("     driver=<" + this.driver.toString() + ">\n");
        }
        stringBuffer.append("     driver name=<" + this.driverName + ">\n");
        if (this.freeConnections != null) {
            stringBuffer.append("     number of *free* connections=<" + this.freeConnections.size() + ">\n");
        }
        stringBuffer.append("     max con=<" + this.maxCon + ">\n");
        stringBuffer.append("     min con=<" + this.minCon + ">\n");
        stringBuffer.append("     prepared stmt cache size=<" + this.preparedStmtCacheSize + ">\n");
        stringBuffer.append("     transaction manager=<" + this.transactionManager + ">\n");
        stringBuffer.append("     xid connection size=<" + this.xidConnections.size() + ">\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

