/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.standard.StandardConnectionHandle;
import org.enhydra.jdbc.standard.StandardXACallableStatement;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXAPreparedStatement;
import org.enhydra.jdbc.standard.StandardXAStatement;

public class StandardXAConnectionHandle
extends StandardConnectionHandle {
    boolean resetTxonResume = false;
    boolean globalTransaction;
    public TransactionManager transactionManager;
    public Transaction tx;
    public StandardXAConnection xacon;
    public boolean thisAutoCommit = true;

    public StandardXAConnectionHandle(StandardXAConnection standardXAConnection, Hashtable hashtable, int n, TransactionManager transactionManager) {
        super(standardXAConnection, hashtable, n);
        this.xacon = standardXAConnection;
        this.transactionManager = transactionManager;
        this.log = standardXAConnection.dataSource.log;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public synchronized void close() throws SQLException {
        Transaction transaction = this.tx;
        super.close();
        this.log.debug("StandardXAConnectionHandle:close");
        this.log.debug("StandardXAConnectionHandle:close globalTransaction='" + this.globalTransaction + "' con.getAutoCommit='" + this.con.getAutoCommit() + "' ttx='" + transaction + "'");
        if (!this.con.getAutoCommit() && transaction == null) {
            this.log.debug("StandardXAConnectionHandle:close rollback the connection");
            this.con.rollback();
            this.con.setAutoCommit(this.thisAutoCommit);
        } else {
            this.log.debug("StandardXAConnectionHandle:close do nothing else");
        }
        this.isReallyUsed = false;
        this.log.debug("StandardXAConnectionHandle:close AFTER globalTransaction='" + this.globalTransaction + "' con.getAutoCommit='" + this.con.getAutoCommit() + "' ttx='" + transaction + "'");
    }

    void setGlobalTransaction(boolean bl) throws SQLException {
        this.log.debug("StandardXAConnectionHandle:setGlobalTransaction gTransaction='" + bl + "'");
        this.globalTransaction = bl;
        this.con = this.pooledCon.getPhysicalConnection();
        if (this.con == null) {
            this.log.warn("StandardXAConnectionHandle:setGlobalTransaction con is null before setupPreparedStatementCache");
        } else {
            this.log.debug("StandardXAConnectionHandle:setGlobalTransaction con is *NOT* null before setupPreparedStatementCache");
        }
        if (!this.isClosed()) {
            super.setAutoCommit(!bl);
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:setAutoCommit This connection is part of a global transaction");
        }
        super.setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:commit:This connection is part of a global transaction");
        }
        super.commit();
    }

    public void rollback() throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:rollback:This connection is part of a global transaction");
        }
        super.rollback();
    }

    synchronized PreparedStatement checkPreparedCache(String string, int n, int n2, int n3, Object object) throws SQLException {
        PreparedStatement preparedStatement = null;
        if (this.preparedStatementCache != null) {
            Object object2 = this.preparedStatementCache.get(object);
            if (object2 != null) {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is found");
                preparedStatement = (PreparedStatement)object2;
                try {
                    preparedStatement.clearParameters();
                }
                catch (SQLException sQLException) {
                    preparedStatement = this.createPreparedStatement(string, n, n2, n3);
                }
                this.preparedStatementCache.remove(object);
                this.inUse.put(object, preparedStatement);
            } else {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is *NOT* found");
                preparedStatement = this.createPreparedStatement(string, n, n2, n3);
                this.inUse.put(object, preparedStatement);
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:checkPreparedCache object the cache is out");
            preparedStatement = this.createPreparedStatement(string, n, n2, n3);
        }
        this.log.debug("StandardXAConnectionHandle:checkPreparedCache pstmt='" + preparedStatement.toString() + "'");
        return preparedStatement;
    }

    synchronized PreparedStatement checkPreparedCache(String string, int n, Object object) throws SQLException {
        PreparedStatement preparedStatement = null;
        if (this.preparedStatementCache != null) {
            Object object2 = this.preparedStatementCache.get(object);
            if (object2 != null) {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is found");
                preparedStatement = (PreparedStatement)object2;
                try {
                    preparedStatement.clearParameters();
                }
                catch (SQLException sQLException) {
                    preparedStatement = this.createPreparedStatement(string, n);
                }
                this.preparedStatementCache.remove(object);
                this.inUse.put(object, preparedStatement);
            } else {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is *NOT* found");
                preparedStatement = this.createPreparedStatement(string, n);
                this.inUse.put(object, preparedStatement);
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:checkPreparedCache object the cache is out");
            preparedStatement = this.createPreparedStatement(string, n);
        }
        this.log.debug("StandardXAConnectionHandle:checkPreparedCache pstmt='" + preparedStatement.toString() + "'");
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 0, 0, 0);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, 0);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.tx == null) {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx==null");
            try {
                try {
                    Transaction transaction = this.getTransaction();
                    if (transaction != null) {
                        this.log.debug("StandardXAConnectionHandle:prepareStatement (found a transaction)");
                        this.tx = transaction;
                        this.xacon.thisAutoCommit = this.getAutoCommit();
                        if (this.getAutoCommit()) {
                            this.setAutoCommit(false);
                        }
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                        }
                        catch (RollbackException rollbackException) {
                            this.log.debug("StandardXAConnectionHandle:prepareStatemnet enlistResource exception : " + rollbackException.toString());
                        }
                    }
                    this.log.debug("StandardXAConnectionHandle:prepareStatement (no transaction found)");
                }
                catch (SystemException systemException) {
                    systemException.printStackTrace();
                    throw new SQLException("StandardXAConnectionHandle:prepareStatement getTransaction exception: " + systemException.toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new SQLException("StandardXAConnectionHandle:prepareStatement should not be used outside an EJBServer");
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx!=null");
        }
        this.isReallyUsed = true;
        return new StandardXAPreparedStatement(this, string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.tx == null) {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx==null");
            try {
                try {
                    Transaction transaction = this.getTransaction();
                    if (transaction != null) {
                        this.log.debug("StandardXAConnectionHandle:prepareStatement (found a transaction)");
                        this.tx = transaction;
                        this.xacon.thisAutoCommit = this.getAutoCommit();
                        if (this.getAutoCommit()) {
                            this.setAutoCommit(false);
                        }
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                        }
                        catch (RollbackException rollbackException) {
                            this.log.debug("StandardXAConnectionHandle:prepareStatemnet enlistResource exception : " + rollbackException.toString());
                        }
                    }
                    this.log.debug("StandardXAConnectionHandle:prepareStatement (no transaction found)");
                }
                catch (SystemException systemException) {
                    systemException.printStackTrace();
                    throw new SQLException("StandardXAConnectionHandle:prepareStatement getTransaction exception: " + systemException.toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new SQLException("StandardXAConnectionHandle:prepareStatement should not be used outside an EJBServer");
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx!=null");
        }
        this.isReallyUsed = true;
        return new StandardXAPreparedStatement(this, string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return new StandardXACallableStatement(this, string, n, n2, 0);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return new StandardXACallableStatement(this, string, 0, 0, 0);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return new StandardXACallableStatement(this, string, n, n2, n3);
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(0, 0, 0);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 0);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (this.tx == null) {
            this.log.debug("StandardXAConnectionHandle:createStatement tx==null");
            try {
                try {
                    Transaction transaction = this.getTransaction();
                    if (transaction != null) {
                        this.log.debug("StandardXAConnectionHandle:createStatement (found a transaction)");
                        this.tx = transaction;
                        this.xacon.thisAutoCommit = this.getAutoCommit();
                        if (this.getAutoCommit()) {
                            this.setAutoCommit(false);
                        }
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                        }
                        catch (RollbackException rollbackException) {
                            this.log.debug("StandardXAConnectionHandle:createStatement enlistResource exception: " + rollbackException.toString());
                        }
                    } else {
                        this.log.debug("StandardXAConnectionHandle:createStatement (no transaction found)");
                    }
                }
                catch (SystemException systemException) {
                    throw new SQLException("StandardXAConnectionHandle:createStatement getTransaction exception: " + systemException.toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new SQLException("StandardXAConnectionHandle:createStatement should not be used outside an EJBServer: " + nullPointerException.toString());
            }
        }
        this.isReallyUsed = true;
        return new StandardXAStatement(this, n, n2, n3);
    }

    private Transaction getTransaction() throws SystemException {
        Transaction transaction = null;
        if (this.transactionManager != null) {
            transaction = this.transactionManager.getTransaction();
        } else {
            this.log.debug("StandardXAConnectionHandle:getTransaction (null transaction manager)");
        }
        return transaction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardXAConnectionHandle:\n");
        stringBuffer.append("     global transaction =<" + this.globalTransaction + ">\n");
        stringBuffer.append("     is really used =<" + this.isReallyUsed + ">\n");
        stringBuffer.append("     this autoCommit =<" + this.thisAutoCommit + ">\n");
        stringBuffer.append("     in use size =<" + this.inUse.size() + ">\n");
        stringBuffer.append("     master prepared stmt cache size =<" + this.masterPrepStmtCache.size() + ">\n");
        stringBuffer.append("     transaction =<" + this.tx + ">\n");
        stringBuffer.append("     connection =<" + this.con.toString() + ">\n");
        return stringBuffer.toString();
    }
}

