/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.enhydra.jdbc.standard.StandardPooledConnection;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.enhydra.jdbc.standard.StandardXAStatefulConnection;
import org.enhydra.jdbc.util.JdbcUtil;

public class StandardXAConnection
extends StandardPooledConnection
implements XAConnection,
XAResource,
Referenceable,
Runnable {
    protected StandardXAStatefulConnection curCon;
    private boolean commitOnPrepare;
    boolean isClosed;
    private int timeoutSecs;
    private long timeoutPeriod = 60000L;
    private long nextTimeout;
    public Thread timerThread;
    public TransactionManager transactionManager;
    public StandardXAConnectionHandle connectionHandle;
    protected StandardXADataSource xaDataSource;
    public boolean thisAutoCommit = true;

    public StandardXAConnection(StandardXADataSource standardXADataSource, String string, String string2) throws SQLException {
        super(standardXADataSource, string, string2);
        this.xaDataSource = standardXADataSource;
        this.curCon = new StandardXAStatefulConnection(standardXADataSource, this.con);
        standardXADataSource.log.debug("StandardXAConnection created");
    }

    public XAResource getXAResource() {
        return this;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.dataSource.log.debug("StandardXAConnection:getConnection");
        if (this.connectionHandle != null && !this.connectionHandle.isClosed()) {
            this.connectionHandle.close();
        }
        if (this.curCon == null) {
            this.curCon = this.xaDataSource.getFreeConnection();
            this.con = this.curCon.con;
        }
        this.newConnectionHandle();
        this.dataSource.log.debug("StandardXAConnection:getConnection return a connection");
        return this.connectionHandle;
    }

    protected void newConnectionHandle() {
        this.connectionHandle = new StandardXAConnectionHandle(this, this.dataSource.getMasterPrepStmtCache(), this.dataSource.getPreparedStmtCacheSize(), this.transactionManager);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public synchronized void close() throws SQLException {
        this.dataSource.log.debug("StandardXAConnection:close the XAConnection");
        if (this.curCon != null && !this.curCon.con.isClosed()) {
            this.curCon.con.close();
            this.dataSource.getMasterPrepStmtCache().remove(this.curCon.toString());
        } else if (this.xaDataSource.freeConnections.size() > 1) {
            this.curCon = this.xaDataSource.getFreeConnection();
            this.curCon.con.close();
            this.dataSource.getMasterPrepStmtCache().remove(this.curCon.con.toString());
        }
        this.curCon = null;
        this.con = null;
        this.xaDataSource.connectionClosed();
        this.isClosed = true;
        this.connectionHandle = null;
        this.nextTimeout = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart(Xid xid, int n) throws XAException {
        block25: {
            JdbcUtil jdbcUtil;
            this.dataSource.log.debug("StandardXAConnection:doStart xid='" + xid + "' flags='" + n + "'");
            if (xid == null) {
                throw new XAException(-5);
            }
            if (n == 0x8000000 || n == 0x200000) {
                try {
                    this.xaDataSource.processToWait();
                }
                catch (Exception exception) {
                    throw new XAException("Exception : " + exception.toString());
                }
                jdbcUtil = this.xaDataSource;
                synchronized (jdbcUtil) {
                    if (this.curCon != null && !this.xaDataSource.freeConnections.contains(this.curCon)) {
                        this.xaDataSource.freeConnections.addElement(this.curCon);
                    }
                }
                this.curCon = this.xaDataSource.getConnection(xid, true);
                this.con = this.curCon.con;
            }
            if (this.curCon == null) {
                try {
                    this.curCon = this.xaDataSource.getFreeConnection();
                    this.con = this.curCon.con;
                }
                catch (Exception exception) {
                    this.dataSource.log.error("error while gettting connection " + exception, exception);
                }
                this.dataSource.log.debug("StandardXAConnection:doStart curCon is null");
            }
            jdbcUtil = this.connectionHandle;
            try {
                ((StandardXAConnectionHandle)jdbcUtil).setGlobalTransaction(true);
                if (n != 0x8000000 || !((StandardXAConnectionHandle)jdbcUtil).resetTxonResume) break block25;
                ((StandardXAConnectionHandle)jdbcUtil).resetTxonResume = false;
                if (this.transactionManager == null || ((StandardXAConnectionHandle)jdbcUtil).tx != null) break block25;
                try {
                    this.connectionHandle.tx = this.transactionManager.getTransaction();
                }
                catch (SystemException systemException) {
                    throw new XAException(systemException.toString());
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.toString());
            }
        }
        if (this.timeoutSecs != 0) {
            this.curCon.timeout = System.currentTimeMillis() + (long)(this.timeoutSecs * 1000);
            if (this.nextTimeout == 0L) {
                this.nextTimeout = this.curCon.timeout;
                this.notify();
            } else if (this.curCon.timeout < this.nextTimeout) {
                this.nextTimeout = this.curCon.timeout;
            }
        }
        this.curCon.xid = xid;
        this.curCon.timedOut = false;
        this.curCon.commitOnPrepare = this.commitOnPrepare;
        if (!this.xaDataSource.xidConnections.containsKey(xid)) {
            try {
                this.log.debug("StandardXAConnection:dostart before processToWait");
                this.xaDataSource.processToWait();
                this.log.debug("StandardXAConnection:dostart after processToWait");
            }
            catch (Exception exception) {
                throw new XAException("Exception : " + exception.toString());
            }
            StandardXADataSource standardXADataSource = this.xaDataSource;
            synchronized (standardXADataSource) {
                this.xaDataSource.xidConnections.put(xid, this.curCon);
            }
        }
        this.curCon.setState(0);
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:start associate the current connection with a global transaction");
        this.doStart(xid, n);
        this.curCon = null;
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:end");
        this.dataSource.log.debug("StandardXAConnection:end xid='" + xid + "' flags='" + n + "'");
        if (xid == null) {
            throw new XAException(-5);
        }
        StandardXAStatefulConnection standardXAStatefulConnection = this.xaDataSource.getConnection(xid, true);
        int n2 = standardXAStatefulConnection.getState();
        if (n2 != 0) {
            throw new XAException(-6);
        }
        if (this.connectionHandle.tx != null) {
            this.connectionHandle.resetTxonResume = true;
        }
        this.connectionHandle.tx = null;
        this.connectionHandle.globalTransaction = false;
    }

    public StandardXAStatefulConnection checkPreparedState(Xid xid) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:checkPreparedState");
        if (xid == null) {
            throw new XAException(-5);
        }
        StandardXAStatefulConnection standardXAStatefulConnection = this.xaDataSource.getConnection(xid, true);
        try {
            if (standardXAStatefulConnection.commitOnPrepare) {
                standardXAStatefulConnection.con.commit();
                standardXAStatefulConnection.setState(7);
            } else {
                standardXAStatefulConnection.setState(2);
            }
        }
        catch (SQLException sQLException) {
            this.dataSource.log.error("StandardXAConnection:checkPrepareState Exception on prepare, rolling back");
            standardXAStatefulConnection.setState(6);
            throw new XAException(100);
        }
        return standardXAStatefulConnection;
    }

    public int prepare(Xid xid) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:prepare prepare to perform a commit");
        this.checkPreparedState(xid);
        return 0;
    }

    /*
     * Loose catch block
     */
    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        block18: {
            this.dataSource.log.debug("StandardXAConnection:commit perform a commit");
            if (xid == null) {
                throw new XAException(-5);
            }
            StandardXAStatefulConnection standardXAStatefulConnection = this.xaDataSource.getConnection(xid, true);
            this.dataSource.log.debug("StandardXAConnection:commit case(state)");
            switch (standardXAStatefulConnection.getState()) {
                case 7: {
                    break;
                }
                case 2: {
                    try {
                        this.dataSource.log.debug("StandardXAConnection:commit try to commit a connection (STATUS_PREPARED)");
                        standardXAStatefulConnection.con.commit();
                        this.dataSource.log.debug("StandardXAConnection:commit commit is ok");
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new XAException(100);
                    }
                }
                case 0: 
                case 3: {
                    if (!bl) {
                        throw new XAException(-6);
                    }
                    try {
                        this.dataSource.log.debug("StandardXAConnection:commit try to commit a connection (STATUS_ACTIVE)");
                        standardXAStatefulConnection.con.commit();
                        this.dataSource.log.debug("StandardXAConnection:commit commit is ok");
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new XAException(100);
                    }
                }
                default: {
                    this.dataSource.log.debug("StandardXAConnection:commit UNKNOWN STATUS!:" + standardXAStatefulConnection.getState());
                    throw new XAException(-6);
                }
            }
            Object var6_7 = null;
            try {
                this.dataSource.log.debug("StandardXAConnection:commit setAutoCommit to '" + this.thisAutoCommit + "'");
                standardXAStatefulConnection.con.setAutoCommit(this.thisAutoCommit);
                break block18;
            }
            catch (SQLException sQLException) {
                this.dataSource.log.debug("StandardXAConnection:commit setAutoCommit problem");
            }
            {
                break block18;
                catch (XAException xAException) {
                    throw xAException;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.dataSource.log.debug("StandardXAConnection:commit setAutoCommit to '" + this.thisAutoCommit + "'");
                    standardXAStatefulConnection.con.setAutoCommit(this.thisAutoCommit);
                }
                catch (SQLException sQLException) {
                    this.dataSource.log.debug("StandardXAConnection:commit setAutoCommit problem");
                }
                this.xaDataSource.freeConnection(xid, false);
                throw throwable;
            }
        }
        this.xaDataSource.freeConnection(xid, false);
    }

    /*
     * Loose catch block
     */
    public synchronized void rollback(Xid xid) throws XAException {
        block14: {
            this.dataSource.log.debug("StandardXAConnection:rollback");
            if (xid == null) {
                throw new XAException(-5);
            }
            StandardXAStatefulConnection standardXAStatefulConnection = this.xaDataSource.getConnection(xid, true);
            switch (standardXAStatefulConnection.getState()) {
                case 7: {
                    throw new XAException(7);
                }
                case 0: 
                case 2: 
                case 9: {
                    try {
                        this.dataSource.log.debug("StandardXAConnection:rollback try to perform the rollback operation");
                        standardXAStatefulConnection.con.rollback();
                        this.dataSource.log.debug("StandardXAConnection:rollback performed the rollback");
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new XAException(100);
                    }
                }
                default: {
                    throw new XAException(-6);
                }
            }
            Object var5_5 = null;
            try {
                this.dataSource.log.debug("StandardXAConnection:rollback setAutoCommit to '" + this.thisAutoCommit + "'");
                standardXAStatefulConnection.con.setAutoCommit(this.thisAutoCommit);
                break block14;
            }
            catch (SQLException sQLException) {
                this.dataSource.log.debug("StandardXAConnection:rollback setAutoCommit problem");
            }
            {
                break block14;
                catch (XAException xAException) {
                    throw xAException;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.dataSource.log.debug("StandardXAConnection:rollback setAutoCommit to '" + this.thisAutoCommit + "'");
                    standardXAStatefulConnection.con.setAutoCommit(this.thisAutoCommit);
                }
                catch (SQLException sQLException) {
                    this.dataSource.log.debug("StandardXAConnection:rollback setAutoCommit problem");
                }
                this.xaDataSource.freeConnection(xid, false);
                throw throwable;
            }
        }
        this.xaDataSource.freeConnection(xid, false);
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:isSameRM");
        if (this.equals(xAResource)) {
            this.dataSource.log.debug("StandardXAConnection:isSameRM isSameRM");
            return true;
        }
        if (!(xAResource instanceof StandardXAConnection)) {
            this.dataSource.log.debug("StandardXAConnection:isSameRM not isSameRM");
            return false;
        }
        StandardXAConnection standardXAConnection = (StandardXAConnection)xAResource;
        if (this.dataSource.equals(standardXAConnection.dataSource)) {
            this.dataSource.log.debug("StandardXAConnection:isSameRM isSameRM (equal datasource)");
            return true;
        }
        this.dataSource.log.debug("StandardXAConnection:isSameRM not isSameRM (not equal datasource)");
        return false;
    }

    public void forget(Xid xid) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:forget forget with Xid");
        if (xid == null) {
            throw new XAException(-5);
        }
        this.xaDataSource.freeConnection(xid, false);
    }

    public Xid[] recover(int n) throws XAException {
        this.dataSource.log.debug("StandardXAConnection:recover recover flag=" + n);
        if (n != 0x1000000 && n != 0x800000 && n != 0) {
            throw new XAException(-5);
        }
        Xid[] xidArray = null;
        xidArray = this.xaDataSource.recover();
        return xidArray;
    }

    public boolean setTransactionTimeout(int n) {
        this.timeoutSecs = n;
        return false;
    }

    public int getTransactionTimeout() {
        return this.timeoutSecs;
    }

    public void setCommitOnPrepare(boolean bl) {
        this.commitOnPrepare = bl;
    }

    public boolean getCommitOnPrepare() {
        return this.commitOnPrepare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                StandardXAConnection standardXAConnection = this;
                synchronized (standardXAConnection) {
                    while (this.nextTimeout == 0L) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isClosed) {
                return;
            }
            try {
                Thread.sleep(this.timeoutPeriod);
                if (this.isClosed) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            long l = System.currentTimeMillis();
            if (l < this.nextTimeout) continue;
            try {
                this.nextTimeout = this.xaDataSource.checkTimeouts(l);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Reference getReference() throws NamingException {
        this.dataSource.log.debug("StandardXAConnection:getReference return a reference of the object");
        Reference reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        reference.add(new StringRefAddr("commitOnPrepare", String.valueOf(this.getCommitOnPrepare())));
        reference.add(new StringRefAddr("timeoutSecs", Integer.toString(this.getTransactionTimeout())));
        return reference;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardXAConnection:\n");
        stringBuffer.append("     commit on prepare =<" + this.commitOnPrepare + ">\n");
        stringBuffer.append("     is closed =<" + this.isClosed + ">\n");
        stringBuffer.append("     this autoCommit =<" + this.thisAutoCommit + ">\n");
        stringBuffer.append("     listeners size =<" + this.listeners.size() + ">\n");
        stringBuffer.append("     next timeOut =<" + this.nextTimeout + ">\n");
        stringBuffer.append("     timeOut period =<" + this.timeoutPeriod + ">\n");
        stringBuffer.append("     timeOut secs =<" + this.timeoutSecs + ">\n");
        stringBuffer.append("     transaction manager=<" + this.transactionManager + ">\n");
        stringBuffer.append(this.xaDataSource.toString());
        stringBuffer.append(this.dataSource.toString());
        if (this.curCon != null) {
            stringBuffer.append(this.curCon.toString());
        }
        if (this.connectionHandle != null) {
            stringBuffer.append(this.connectionHandle.toString());
        }
        stringBuffer.append(this.con.toString());
        return stringBuffer.toString();
    }
}

