/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.enhydra.jdbc.core.CoreCallableStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXACallableStatement
extends CoreCallableStatement {
    private StandardXAConnectionHandle con;
    private boolean closed;
    private String sql;
    private int resultSetType;
    private int resultSetConcurrency;
    private int resultSetHoldability;

    StandardXACallableStatement(StandardXAConnectionHandle standardXAConnectionHandle, String string, int n, int n2, int n3) throws SQLException {
        this.con = standardXAConnectionHandle;
        this.sql = string;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.log = standardXAConnectionHandle.log;
    }

    private CallableStatement newStatement() throws SQLException {
        if (this.resultSetType == 0 && this.resultSetConcurrency == 0 && this.resultSetHoldability == 0) {
            return this.con.con.prepareCall(this.sql);
        }
        if (this.resultSetHoldability == 0) {
            return this.con.con.prepareCall(this.sql, this.resultSetType, this.resultSetConcurrency);
        }
        return this.con.con.prepareCall(this.sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.closed = true;
    }

    public synchronized void preInvoke() throws SQLException {
        block10: {
            if (this.closed) {
                throw new SQLException("Prepare Statement is closed");
            }
            Transaction transaction = null;
            if (this.con.tx == null) {
                try {
                    try {
                        Transaction transaction2 = transaction = this.con.transactionManager != null ? this.con.transactionManager.getTransaction() : null;
                        if (transaction == null) break block10;
                        this.con.tx = transaction;
                        this.con.xacon.thisAutoCommit = this.con.getAutoCommit();
                        this.con.setAutoCommit(false);
                        try {
                            this.con.tx.enlistResource(this.con.xacon.getXAResource());
                            if (this.cs != null) {
                                this.cs.close();
                                this.cs = null;
                            }
                        }
                        catch (RollbackException rollbackException) {
                            throw new SQLException("StandardXAStatement:preInvoke enlistResource exception: " + rollbackException.toString());
                        }
                    }
                    catch (SystemException systemException) {
                        throw new SQLException("StandardXAStatement:preInvoke getTransaction exception: " + systemException.toString());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw new SQLException("StandardXAStatement:preInvoke should not be used outside an EJBServer: " + nullPointerException.toString());
                }
            }
        }
        if (this.cs == null) {
            this.cs = this.newStatement();
        }
    }

    public void catchInvoke(SQLException sQLException) throws SQLException {
        throw sQLException;
    }
}

