/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.enhydra.jdbc.standard.StandardConnectionHandle;
import org.enhydra.jdbc.standard.StandardConnectionPoolDataSource;
import org.enhydra.jdbc.util.Logger;

public class StandardPooledConnection
implements PooledConnection {
    protected StandardConnectionPoolDataSource dataSource;
    public Connection con;
    public StandardConnectionHandle connectionHandle;
    Vector listeners;
    boolean isClosed;
    public Logger log;

    public StandardPooledConnection(StandardConnectionPoolDataSource standardConnectionPoolDataSource, String string, String string2) throws SQLException {
        this.dataSource = standardConnectionPoolDataSource;
        this.con = standardConnectionPoolDataSource.getConnection(string, string2);
        this.listeners = new Vector(5, 5);
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connectionHandle != null && !this.connectionHandle.isClosed()) {
            this.connectionHandle.close();
        }
        this.newConnectionHandle();
        return this.connectionHandle;
    }

    protected void newConnectionHandle() {
        this.log.debug("StandardPooledConnection:newConnectionHandle");
        this.connectionHandle = new StandardConnectionHandle(this, this.dataSource.getMasterPrepStmtCache(), this.dataSource.getPreparedStmtCacheSize());
    }

    public void close() throws SQLException {
        this.con.close();
        this.dataSource.getMasterPrepStmtCache().remove(this.con.toString());
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.removeElement(connectionEventListener);
    }

    void closeEvent() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.elementAt(i);
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)e;
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.elementAt(i);
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)e;
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    public Connection getPhysicalConnection() {
        return this.con;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardPooledConnection:\n");
        stringBuffer.append("     is closed =<" + this.isClosed + ">\n");
        stringBuffer.append("     connection =<" + this.con + ">\n");
        return stringBuffer.toString();
    }
}

