/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.core.CoreDataSource;
import org.enhydra.jdbc.util.Logger;

public class StandardDataSource
extends CoreDataSource
implements DataSource {
    transient Driver driver = null;
    String driverName = "";
    String url = "";
    private int transIsolation = -1;
    private boolean loadedFromCCL = false;

    public StandardDataSource() {
        this.setLogger(new Logger(LogFactory.getLog((String)"org.enhydra.jdbc.xapool")));
    }

    protected StandardDataSource(Driver driver) throws SQLException {
        this();
        this.driver = driver;
        this.driverName = driver.getClass().getName();
        this.setLogger(new Logger(LogFactory.getLog((String)"org.enhydra.jdbc.xapool")));
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDriverName(String string) throws SQLException {
        if (!this.driverName.equals(string)) {
            this.driverName = string;
            this.driver = null;
        }
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setTransactionIsolation(int n) {
        this.transIsolation = n;
    }

    public int getTransactionIsolation() {
        return this.transIsolation;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        Connection connection = null;
        Properties properties = new Properties();
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("password", string2);
        }
        if (this.url != null) {
            if (this.driver == null) {
                try {
                    this.driver = (Driver)Class.forName(this.driverName).newInstance();
                    this.loadedFromCCL = false;
                    this.log.debug("StandardDataSource:getConnection a new driver instance is created");
                }
                catch (Exception exception) {
                    try {
                        this.driver = (Driver)Class.forName(this.driverName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                        this.loadedFromCCL = true;
                    }
                    catch (Exception exception2) {
                        throw new SQLException("Error trying to load driver: " + this.driverName + " : " + exception2.getMessage());
                    }
                }
            }
            try {
                connection = this.loadedFromCCL ? this.driver.connect(this.url, properties) : DriverManager.getConnection(this.url, properties);
                int n = this.getTransactionIsolation();
                if (n >= 0) {
                    connection.setTransactionIsolation(n);
                }
                this.log.debug("StandardDataSource:getConnection Connection from DriverManager is returned");
            }
            catch (SQLException sQLException) {
                throw new SQLException("Cannot get connection for URL " + this.url + " : " + sQLException.getMessage());
            }
        }
        return connection;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        reference.add(new StringRefAddr("driverName", this.getDriverName()));
        reference.add(new StringRefAddr("url", this.getUrl()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.getLoginTimeout())));
        reference.add(new StringRefAddr("transIsolation", Integer.toString(this.getTransactionIsolation())));
        this.log.debug("StandardDataSource:getReference object returned");
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        this.setDriverName((String)reference.get("driverName").getContent());
        this.setUrl((String)reference.get("url").getContent());
        this.setUser((String)reference.get("user").getContent());
        this.setPassword((String)reference.get("password").getContent());
        this.setDescription((String)reference.get("description").getContent());
        this.setLoginTimeout(Integer.parseInt((String)reference.get("loginTimeout").getContent()));
        this.setTransactionIsolation(Integer.parseInt((String)reference.get("transIsolation").getContent()));
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardDataSource:\n");
        stringBuffer.append("     driver=<" + this.driver + ">\n");
        stringBuffer.append("     url=<" + this.url + ">\n");
        stringBuffer.append("     user=<" + this.user + ">\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

