/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.enhydra.jdbc.core.CoreConnection;
import org.enhydra.jdbc.standard.PreparedStatementCache;
import org.enhydra.jdbc.standard.StandardPooledConnection;
import org.enhydra.jdbc.standard.StandardPreparedStatement;
import org.enhydra.jdbc.util.LRUCache;

public class StandardConnectionHandle
extends CoreConnection {
    StandardPooledConnection pooledCon;
    protected Hashtable masterPrepStmtCache;
    int preparedStmtCacheSize;
    protected LRUCache preparedStatementCache = null;
    public Hashtable inUse;
    private boolean closed;
    public boolean isReallyUsed = false;

    public StandardConnectionHandle(StandardPooledConnection standardPooledConnection, Hashtable hashtable, int n) {
        super(standardPooledConnection.getPhysicalConnection());
        this.pooledCon = standardPooledConnection;
        this.masterPrepStmtCache = hashtable;
        this.preparedStmtCacheSize = n;
        this.log = standardPooledConnection.dataSource.log;
        this.setupPreparedStatementCache();
        this.inUse = new Hashtable(10, 0.5f);
        this.log.debug("StandardConnectionHandle:new StandardConnectionHandle with " + n + " prepared statement");
    }

    protected void setupPreparedStatementCache() {
        this.log.debug("StandardConnectionHandle:setupPreparedStatementCache start");
        if (this.preparedStmtCacheSize == 0) {
            this.log.debug("StandardConnectionHandle:setupPreparedStatementCache return with 0");
            this.preparedStatementCache = null;
            return;
        }
        if (this.con == null) {
            this.log.warn("Connection is null");
        } else {
            this.preparedStatementCache = (LRUCache)this.masterPrepStmtCache.get(this.con.toString());
            if (this.preparedStatementCache == null) {
                this.preparedStatementCache = new PreparedStatementCache(this.preparedStmtCacheSize);
                this.preparedStatementCache.setLogger(this.log);
                this.masterPrepStmtCache.put(this.con.toString(), this.preparedStatementCache);
                this.log.debug("StandardConnectionHandle:setupPreparedStatementCache preparedStatementCache.size(lru)='" + this.preparedStatementCache.LRUSize() + "' " + "preparedStatementCache.size(cache)='" + this.preparedStatementCache.cacheSize() + "' " + "masterPrepStmtCache.size='" + this.masterPrepStmtCache.size() + "' ");
            } else {
                this.preparedStatementCache.setLogger(this.log);
            }
        }
        this.log.debug("StandardConnectionHandle:setupPreparedStatementCache end");
    }

    public void preInvoke() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed");
        }
    }

    public void catchInvoke(SQLException sQLException) throws SQLException {
        throw sQLException;
    }

    public synchronized void close() throws SQLException {
        this.log.debug("StandardConnectionHandle:close");
        this.closed = true;
        Enumeration enumeration = this.inUse.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.returnToCache(k);
        }
        this.pooledCon.closeEvent();
        if (this.preparedStatementCache != null) {
            this.preparedStatementCache.cleanupAll();
        }
        if (this.preparedStatementCache != null && this.masterPrepStmtCache != null && this.log != null) {
            this.log.debug("StandardConnectionHandle:close preparedStatementCache.size(lru)='" + this.preparedStatementCache.LRUSize() + "' " + "preparedStatementCache.size(cache)='" + this.preparedStatementCache.cacheSize() + "' " + "masterPrepStmtCache.size='" + this.masterPrepStmtCache.size() + "' ");
        }
    }

    void returnToCache(Object object, Connection connection) {
        Object v = this.inUse.remove(object);
        if (v != null) {
            LRUCache lRUCache = (LRUCache)this.masterPrepStmtCache.get(connection.toString());
            lRUCache.put(object, v);
        }
    }

    void returnToCache(Object object) {
        this.returnToCache(object, this.con);
    }

    synchronized PreparedStatement checkPreparedCache(String string, int n, int n2, int n3) throws SQLException {
        this.log.debug("StandardConnectionHandle:checkPreparedCache sql='" + string + "'");
        PreparedStatement preparedStatement = null;
        String string2 = string + n + n2;
        if (this.preparedStatementCache != null) {
            Object object = this.preparedStatementCache.get(string2);
            if (object != null) {
                preparedStatement = (PreparedStatement)object;
                try {
                    preparedStatement.clearParameters();
                }
                catch (SQLException sQLException) {
                    preparedStatement = this.createPreparedStatement(string, n, n2, n3);
                }
                this.preparedStatementCache.remove(string2);
                this.inUse.put(string2, preparedStatement);
            } else {
                preparedStatement = this.createPreparedStatement(string, n, n2, n3);
                this.inUse.put(string2, preparedStatement);
            }
        } else {
            preparedStatement = this.createPreparedStatement(string, n, n2, n3);
        }
        preparedStatement = new StandardPreparedStatement(this, preparedStatement, string2);
        return preparedStatement;
    }

    synchronized PreparedStatement checkPreparedCache(String string, int n) throws SQLException {
        this.log.debug("StandardConnectionHandle:checkPreparedCache sql='" + string + "'");
        PreparedStatement preparedStatement = null;
        String string2 = string + n;
        if (this.preparedStatementCache != null) {
            Object object = this.preparedStatementCache.get(string2);
            if (object != null) {
                preparedStatement = (PreparedStatement)object;
                try {
                    preparedStatement.clearParameters();
                }
                catch (SQLException sQLException) {
                    preparedStatement = this.createPreparedStatement(string, n);
                }
                this.preparedStatementCache.remove(string2);
                this.inUse.put(string2, preparedStatement);
            } else {
                preparedStatement = this.createPreparedStatement(string, n);
                this.inUse.put(string2, preparedStatement);
            }
        } else {
            preparedStatement = this.createPreparedStatement(string, n);
        }
        preparedStatement = new StandardPreparedStatement(this, preparedStatement, string2);
        return preparedStatement;
    }

    protected PreparedStatement createPreparedStatement(String string, int n, int n2, int n3) throws SQLException {
        this.log.debug("StandardConnectionHandle:createPreparedStatement type ='" + n + "'");
        if (n == 0 && n3 == 0) {
            return this.con.prepareStatement(string);
        }
        if (n3 == 0) {
            return this.con.prepareStatement(string, n, n2);
        }
        return this.con.prepareStatement(string, n, n2, n3);
    }

    protected PreparedStatement createPreparedStatement(String string, int n) throws SQLException {
        this.log.debug("StandardConnectionHandle:createPreparedStatement autogeneratedkeys ='" + n + "'");
        return this.con.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.log.debug("StandardConnectionHandle:prepareStatement sql='" + string + "'");
        this.preInvoke();
        try {
            return this.checkPreparedCache(string, 0, 0, 0);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.preInvoke();
        try {
            return this.checkPreparedCache(string, n, n2, 0);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.preInvoke();
        try {
            return this.checkPreparedCache(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }
}

