/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.StandardPoolDataSource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXADataSource;

public class StandardXAPoolDataSource
extends StandardPoolDataSource {
    public XADataSource xads;
    public TransactionManager transactionManager;
    public Log glog = LogFactory.getLog((String)"org.enhydra.jdbc.xapool");

    public StandardXAPoolDataSource() {
    }

    public StandardXAPoolDataSource(int n) {
        super(n);
    }

    public StandardXAPoolDataSource(StandardXADataSource standardXADataSource) {
        super(standardXADataSource);
        this.setDataSource(standardXADataSource);
    }

    public StandardXAPoolDataSource(StandardXADataSource standardXADataSource, int n) {
        super(standardXADataSource, n);
        this.setDataSource(standardXADataSource);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.log.debug("StandardXAPoolDataSource:setTransactionManager");
        this.transactionManager = transactionManager;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        Object object = connectionEvent.getSource();
        this.log.debug("StandardXAPoolDataSource:connectionClosed");
        XAConnection xAConnection = (XAConnection)object;
        Transaction transaction = null;
        try {
            if (this.transactionManager == null) {
                TransactionManager transactionManager = ((StandardXADataSource)this.xads).getTransactionManager();
                if (transactionManager == null) {
                    throw new NullPointerException("TM is null");
                }
                transaction = transactionManager.getTransaction();
            } else {
                transaction = this.transactionManager.getTransaction();
            }
            this.log.debug("StandardXAPoolDataSource:connectionClosed get a transaction");
        }
        catch (NullPointerException nullPointerException) {
            this.log.error("StandardXAPoolDataSource:connectionClosed should not be used outside an EJBServer");
        }
        catch (SystemException systemException) {
            this.log.error("StandardXAPoolDataSource:connectionClosed getTransaction failed:" + (Object)((Object)systemException));
        }
        if (transaction != null && ((StandardXAConnection)xAConnection).connectionHandle.isReallyUsed) {
            try {
                transaction.delistResource(xAConnection.getXAResource(), 0x4000000);
                this.log.debug("StandardXAPoolDataSource:connectionClosed the resourse is delisted");
            }
            catch (Exception exception) {
                this.log.error("StandardXAPoolDataSource:connectionClosed Exception in connectionClosed:" + exception);
            }
        }
        this.log.debug("StandardXAPoolDataSource:connectionClosed checkIn an object to the pool");
        this.pool.checkIn(object);
    }

    public GenerationObject create(String string, String string2) throws SQLException {
        XAConnection xAConnection = this.xads.getXAConnection(string, string2);
        xAConnection.addConnectionEventListener(this);
        this.log.debug("StandardXAPoolDataSource:create create a object for the pool");
        GenerationObject generationObject = new GenerationObject(xAConnection, this.pool.getGeneration(), string, string2);
        return generationObject;
    }

    public Reference getReference() throws NamingException {
        this.log.debug("StandardXAPoolDataSource:getReference return a reference of the object");
        Reference reference = super.getReference();
        reference.add(new StringRefAddr("transactionManagerName", "TransactionManager"));
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        super.getObjectInstance(object, name, context, hashtable);
        Reference reference = (Reference)object;
        InitialContext initialContext = new InitialContext(hashtable);
        this.setTransactionManager((TransactionManager)initialContext.lookup("javax.transaction.TransactionManager"));
        this.setDataSource((XADataSource)initialContext.lookup(this.dataSourceName));
        this.log.debug("StandardPoolDataSource:getObjectInstance: instance created");
        return this;
    }

    public XADataSource getDataSource() {
        return this.xads;
    }

    public void setDataSource(XADataSource xADataSource) {
        this.xads = xADataSource;
        if (this.transactionManager != null) {
            ((StandardXADataSource)xADataSource).setTransactionManager(this.transactionManager);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardXAPoolDataSource:\n");
        if (this.transactionManager != null) {
            stringBuffer.append("     transaction manager=<" + this.transactionManager.toString() + ">\n");
        }
        if (this.xads != null) {
            stringBuffer.append(this.xads.toString());
        }
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testThisObject(Object object) {
        boolean bl3;
        Connection connection = null;
        this.log.debug("StandardPoolDataSource:testThisObject verify the current object");
        Transaction transaction = null;
        try {
            try {
                boolean bl2;
                Transaction transaction2;
                Transaction transaction3 = transaction2 = this.transactionManager == null ? null : this.transactionManager.getTransaction();
                boolean bl = transaction2 == null ? false : (bl2 = transaction2.getStatus() == 0);
                if (bl2) {
                    transaction = this.transactionManager.suspend();
                }
                PooledConnection pooledConnection = (PooledConnection)object;
                connection = pooledConnection.getConnection();
                Statement statement = connection.createStatement();
                statement.execute(this.jdbcTestStmt);
                statement.close();
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    this.log.error("StandardPoolDataSource:checkThisObject can't closed the connection: " + exception);
                }
                bl3 = true;
                Object var10_14 = null;
                if (transaction == null) return bl3;
            }
            catch (SQLException sQLException) {
                this.log.error("StandardXAPoolDataSource:checkThisObject Error java.sql.SQLException in StandardXAPoolDataSource:testThisObject");
                boolean bl4 = false;
                Object var10_15 = null;
                if (transaction == null) return bl4;
                try {
                    this.transactionManager.resume(transaction);
                    return bl4;
                }
                catch (Exception exception) {
                    this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
                    return false;
                }
            }
            catch (SystemException systemException) {
                this.log.error("StandardXAPoolDataSource:checkThisObject Error java.sql.SystemException in StandardXAPoolDataSource:testThisObject");
                boolean bl5 = false;
                Object var10_16 = null;
                if (transaction == null) return bl5;
                try {}
                catch (Exception exception) {
                    this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
                    return false;
                }
                this.transactionManager.resume(transaction);
                return bl5;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (transaction == null) throw throwable;
            try {}
            catch (Exception exception) {
                this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
                return false;
            }
            this.transactionManager.resume(transaction);
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            this.log.error("StandardXAPoolDataSource:checkThisObject Error Exception in StandardXAPoolDataSource:testThisObject");
            return false;
        }
        this.transactionManager.resume(transaction);
        return bl3;
    }
}

