/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.core.CoreDataSource;
import org.enhydra.jdbc.core.JdbcThreadFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.GenericPool;
import org.enhydra.jdbc.pool.PoolHelper;
import org.enhydra.jdbc.util.Logger;

public class StandardPoolDataSource
extends CoreDataSource
implements DataSource,
PoolHelper,
ConnectionEventListener {
    public ConnectionPoolDataSource cpds;
    public GenericPool pool;
    public String dataSourceName;
    public String jdbcTestStmt;
    public boolean onOff;
    public Context ictx;
    public Log glog = LogFactory.getLog((String)"org.enhydra.jdbc.xapool");

    public StandardPoolDataSource() {
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this);
        this.pool.setLogger(this.log);
        this.onOff = false;
        this.dataSourceName = null;
    }

    public StandardPoolDataSource(int n) {
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this, n);
        this.pool.setLogger(this.log);
        this.onOff = false;
        this.dataSourceName = null;
    }

    public StandardPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this.cpds = connectionPoolDataSource;
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this);
        this.pool.setLogger(this.log);
        try {
            this.cpds.setLogWriter(this.log);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.onOff = false;
        this.dataSourceName = null;
    }

    public StandardPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource, int n) {
        this.cpds = connectionPoolDataSource;
        this.log = new Logger(this.glog);
        super.setLogWriter(this.log);
        this.pool = new GenericPool(this, n);
        this.pool.setLogger(this.log);
        this.onOff = false;
        this.dataSourceName = null;
    }

    public void setDataSourceName(String string) {
        this.log.debug("StandardPoolDataSource:setDataSourceName");
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String string, String string2) throws SQLException {
        this.log.debug("StandardPoolDataSource:getConnection");
        Connection connection = null;
        PooledConnection pooledConnection = null;
        StandardPoolDataSource standardPoolDataSource = this;
        synchronized (standardPoolDataSource) {
            if (!this.onOff) {
                this.log.debug("StandardPoolDataSource:getConnection must configure the pool...");
                this.pool.start();
                this.onOff = true;
                this.log.debug("StandardPoolDataSource:getConnection pool config : \n" + this.pool.toString());
            }
        }
        try {
            try {
                this.log.debug("StandardPoolDataSource:getConnection Try to give a connection (checkOut)");
                pooledConnection = (PooledConnection)this.pool.checkOut(string, string2);
                this.log.debug("StandardPoolDataSource:getConnection checkOut returna new connection");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.log.debug("StandardPoolDataSource:getConnection SQLException in StandardPoolDataSource:getConnection" + exception);
                throw new SQLException("SQLException in StandardPoolDataSource:getConnection no connection available " + exception);
            }
            connection = pooledConnection.getConnection();
        }
        catch (Exception exception) {
            this.log.debug("StandardPoolDataSource:getConnection exception" + exception);
            exception.printStackTrace();
            SQLException sQLException = new SQLException("SQLException in StandardPoolDataSource:getConnection exception: " + exception);
            if (exception instanceof SQLException) {
                sQLException.setNextException((SQLException)exception);
            }
            if (pooledConnection != null) {
                this.pool.checkIn(pooledConnection);
            }
            throw sQLException;
        }
        this.log.debug("StandardPoolDataSource:getConnection return a connection");
        return connection;
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        Object object = connectionEvent.getSource();
        PooledConnection pooledConnection = (PooledConnection)object;
        this.pool.nextGeneration(pooledConnection);
        this.pool.removeLockedObject(pooledConnection);
        this.expire(pooledConnection);
        this.log.debug("StandardXAPoolDataSource:connectionErrorOccurred remove the object from the pool");
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.log.debug("StandardPoolDataSource:connectionClosed close the connection");
        Object object = connectionEvent.getSource();
        this.pool.checkIn(object);
    }

    public void expire(Object object) {
        this.log.debug("StandardPoolDataSource:expire expire a connection, remove from the pool");
        if (object == null) {
            return;
        }
        try {
            PooledConnection pooledConnection = (PooledConnection)object;
            pooledConnection.close();
            pooledConnection.removeConnectionEventListener(this);
            this.log.debug("StandardPoolDataSource:expire close the connection");
        }
        catch (SQLException sQLException) {
            this.log.error("StandardPoolDataSource:expire Error java.sql.SQLException in StandardPoolDataSource:expire");
        }
    }

    public boolean checkThisObject(Object object) {
        this.log.debug("StandardPoolDataSource:checkThisObject verify the current object");
        try {
            PooledConnection pooledConnection = (PooledConnection)object;
            Connection connection = pooledConnection.getConnection();
            if (connection.isClosed()) {
                return false;
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                this.log.error("StandardPoolDataSource:checkThisObject can't closed the connection: " + exception);
            }
            return true;
        }
        catch (SQLException sQLException) {
            this.log.error("StandardPoolDataSource:checkThisObject Error java.sql.SQLException in StandardPoolDataSource:checkThisObject");
            return false;
        }
    }

    public boolean testThisObject(Object object) {
        Connection connection = null;
        this.log.debug("StandardPoolDataSource:testThisObject verify the current object");
        try {
            PooledConnection pooledConnection = (PooledConnection)object;
            connection = pooledConnection.getConnection();
            Statement statement = connection.createStatement();
            statement.execute(this.jdbcTestStmt);
            statement.close();
            try {
                connection.close();
            }
            catch (Exception exception) {
                this.log.error("StandardPoolDataSource:checkThisObject can't closed the connection: " + exception);
            }
            return true;
        }
        catch (SQLException sQLException) {
            this.log.error("StandardPoolDataSource:checkThisObject Error java.sql.SQLException in StandardPoolDataSource:testThisObject");
            return false;
        }
    }

    public GenerationObject create() throws SQLException {
        return this.create(this.getUser(), this.getPassword());
    }

    public GenerationObject create(String string, String string2) throws SQLException {
        this.log.debug("StandardPoolDataSource:create create a connection for the pool");
        PooledConnection pooledConnection = this.cpds.getPooledConnection(string, string2);
        pooledConnection.addConnectionEventListener(this);
        this.log.debug("StandardPoolDataSource:create create a object for the pool");
        GenerationObject generationObject = new GenerationObject(pooledConnection, this.pool.getGeneration(), string, string2);
        return generationObject;
    }

    public void stopPool() {
        this.pool.stop();
        this.onOff = false;
        this.log.debug("StandardPoolDataSource:stopPool stop now the pool");
    }

    public void shutdown(boolean bl) {
        this.stopPool();
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.pool.setLogger(this.log);
        super.setLogger(this.log);
    }

    public void setDebug(boolean bl) {
        super.setDebug(bl);
        this.pool.setDebug(bl);
    }

    public void setMinSize(int n) throws Exception {
        this.pool.setMinSize(n);
    }

    public void setMaxSize(int n) throws Exception {
        this.pool.setMaxSize(n);
    }

    public void setLifeTime(long l) {
        this.pool.setLifeTime(l);
    }

    public void setSleepTime(long l) {
        this.pool.setSleepTime(l);
    }

    public void setGC(boolean bl) {
        this.pool.setGC(bl);
    }

    public void setCheckLevelObject(int n) {
        this.pool.setCheckLevelObject(n);
    }

    public void setJdbcTestStmt(String string) {
        this.jdbcTestStmt = string;
    }

    public void setGeneration(int n) {
        this.pool.setGeneration(n);
    }

    public void setDeadLockMaxWait(long l) {
        this.pool.setDeadLockMaxWait(l);
    }

    public void setDeadLockRetryWait(long l) {
        this.pool.setDeadLockRetryWait(l);
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public int getMinSize() {
        return this.pool.getMinSize();
    }

    public int getMaxSize() {
        return this.pool.getMaxSize();
    }

    public long getLifeTime() {
        return this.pool.getLifeTime();
    }

    public long getSleepTime() {
        return this.pool.getSleepTime();
    }

    public int getGeneration() {
        return this.pool.generation;
    }

    public boolean isGC() {
        return this.pool.isGC();
    }

    public int getLockedObjectCount() {
        return this.pool.getLockedObjectCount();
    }

    public int getUnlockedObjectCount() {
        return this.pool.getUnlockedObjectCount();
    }

    public int getCheckLevelObject() {
        return this.pool.getCheckLevelObject();
    }

    public String getJdbcTestStmt() {
        return this.jdbcTestStmt;
    }

    public long getDeadLockMaxWait() {
        return this.pool.getDeadLockMaxWait();
    }

    public long getDeadLockRetryWait() {
        return this.pool.getDeadLockRetryWait();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardPoolDataSource:\n");
        stringBuffer.append("     data source name=<" + this.dataSourceName + ">\n");
        stringBuffer.append("     jdbc test stmt=<" + this.jdbcTestStmt + ">\n");
        stringBuffer.append("     user=<" + this.user + ">\n");
        if (this.cpds != null) {
            stringBuffer.append(this.cpds.toString());
        }
        stringBuffer.append(this.pool.toString());
        return stringBuffer.toString();
    }

    public Reference getReference() throws NamingException {
        this.log.debug("StandardPoolDataSource:getReference return a reference of the object");
        Reference reference = super.getReference();
        reference.add(new StringRefAddr("checkLevelObject", Integer.toString(this.getCheckLevelObject())));
        reference.add(new StringRefAddr("lifeTime", Long.toString(this.getLifeTime())));
        reference.add(new StringRefAddr("jdbcTestStmt", this.getJdbcTestStmt()));
        reference.add(new StringRefAddr("maxSize", Integer.toString(this.getMaxSize())));
        reference.add(new StringRefAddr("minSize", Integer.toString(this.getMinSize())));
        reference.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        super.getObjectInstance(object, name, context, hashtable);
        Reference reference = (Reference)object;
        this.setLifeTime(Long.parseLong((String)reference.get("lifeTime").getContent()));
        this.setJdbcTestStmt((String)reference.get("jdbcTestStmt").getContent());
        this.setMaxSize(Integer.parseInt((String)reference.get("maxSize").getContent()));
        this.setMinSize(Integer.parseInt((String)reference.get("minSize").getContent()));
        this.setDataSourceName((String)reference.get("dataSourceName").getContent());
        InitialContext initialContext = new InitialContext(hashtable);
        this.cpds = (ConnectionPoolDataSource)initialContext.lookup(this.dataSourceName);
        return this;
    }

    public void setThreadFactory(JdbcThreadFactory jdbcThreadFactory) {
        super.setThreadFactory(jdbcThreadFactory);
        this.pool.setThreadFactory(jdbcThreadFactory);
    }
}

