/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.enhydra.jdbc.core.JdbcThreadFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.PoolHelper;
import org.enhydra.jdbc.pool.PoolKeeper;
import org.enhydra.jdbc.util.Logger;

public class GenericPool {
    private long lifeTime;
    private Hashtable locked;
    private Hashtable unlocked;
    private Vector hitList;
    private JdbcThreadFactory threadFactory = null;
    private int minSize;
    private int maxSize;
    private PoolHelper poolHelper;
    private int count;
    private boolean gc;
    private boolean debug;
    private long deadLockMaxWait;
    private long deadLockRetryWait;
    private Logger log;
    private int checkLevelObject;
    protected Thread keeper;
    protected PoolKeeper poolKeeper;
    private long sleepTime;
    protected int generation = 1;
    public static final long DEFAULT_EXPIRATION = 600000L;
    public static final long DEFAULT_SLEEPTIME = 300000L;
    public static final int DEFAULT_MINSIZE = 2;
    public static final int DEFAULT_MAXSIZE = 50;
    public static final int DEFAULT_DEADLOCKMAXWAIT = 300000;
    public static final int DEFAULT_DEADLOCKRETRYWAIT = 10000;

    public GenericPool(PoolHelper poolHelper) {
        this(poolHelper, 2, 50, 600000L, 300000L);
    }

    public GenericPool(PoolHelper poolHelper, int n) {
        this(poolHelper, 2, n, 600000L, 300000L);
    }

    public GenericPool(PoolHelper poolHelper, int n, int n2, long l, long l2) {
        this.lifeTime = l;
        this.minSize = n;
        this.maxSize = n2;
        this.poolHelper = poolHelper;
        this.sleepTime = l2;
        this.checkLevelObject = 0;
        this.deadLockMaxWait = 300000L;
        this.deadLockRetryWait = 10000L;
    }

    public synchronized void start() {
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
        this.hitList = new Vector();
        this.count = 0;
        this.gc = false;
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.minSize; ++i) {
            try {
                GenerationObject generationObject = this.poolHelper.create();
                this.unlocked.put(generationObject, new Long(l));
            }
            catch (Exception exception) {
                this.log.error("Error Exception in GenericPool:start " + exception);
            }
            ++this.count;
        }
        if (this.threadFactory != null) {
            try {
                this.poolKeeper = new PoolKeeper(this.sleepTime, this);
                this.keeper = this.threadFactory.getThread(this.poolKeeper);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage());
            }
        } else {
            this.poolKeeper = new PoolKeeper(this.sleepTime, this);
            this.keeper = new Thread(this.poolKeeper);
        }
        this.keeper.start();
        this.log.debug("GenericPool:start pool started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromPool(String string, String string2) throws Exception {
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        if (this.getUnlockedObjectCount() > 0) {
            GenerationObject generationObject = null;
            object2 = null;
            object = null;
            Enumeration enumeration = this.unlocked.keys();
            while (enumeration.hasMoreElements()) {
                GenericPool genericPool = this;
                synchronized (genericPool) {
                    if (!enumeration.hasMoreElements()) {
                        break;
                    }
                    generationObject = (GenerationObject)enumeration.nextElement();
                    object = (Long)this.unlocked.get(generationObject);
                    this.unlocked.remove(generationObject);
                    object2 = generationObject.getObj();
                }
                if (l - (Long)object > this.lifeTime) {
                    this.log.debug("GenericPool:getFromPool an object has expired");
                    this.removeUnlockedObject(generationObject);
                    continue;
                }
                this.log.debug("GenericPool:getFromPool check the owner of the connection");
                if (this.checkOwner(generationObject, string, string2)) {
                    this.log.debug("GenericPool:getFromPool owner is verified");
                    if (this.checkLevelObject == 0 || this.checkLevelObject == 1 && this.poolHelper.checkThisObject(object2) || this.checkLevelObject == 2 && this.poolHelper.testThisObject(object2)) {
                        this.locked.put(generationObject, new Long(l));
                        this.log.debug("GenericPool:getFromPool return an object (after verification if needed)");
                        return generationObject.getObj();
                    }
                    this.log.debug("GenericPool:getFromPool kill an object from the pool");
                    this.removeUnlockedObject(generationObject);
                    continue;
                }
                this.log.debug("GenericPool:getFromPool owner is FALSE");
            }
        }
        boolean bl = false;
        object2 = this;
        synchronized (object2) {
            if (this.count < this.maxSize) {
                bl = true;
                ++this.count;
            }
        }
        if (bl) {
            this.log.debug("GenericPool:getFromPool no objects available, create a new one");
            try {
                object2 = this.poolHelper.create(string, string2);
                this.locked.put(object2, new Long(l));
                return ((GenerationObject)object2).getObj();
            }
            catch (Exception exception) {
                object = this;
                synchronized (object) {
                    --this.count;
                }
                this.log.error("GenericPool:getFromPool Error Exception in GenericPool:getFromPool");
                throw exception;
            }
        }
        return null;
    }

    public synchronized boolean checkOwner(GenerationObject generationObject, String string, String string2) {
        return this.equals(string, generationObject.getUser()) && this.equals(string2, generationObject.getPassword());
    }

    JdbcThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    void setThreadFactory(JdbcThreadFactory jdbcThreadFactory) {
        this.threadFactory = jdbcThreadFactory;
    }

    private boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return string == null;
        }
        return string.equals(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object checkOut(String string, String string2) throws Exception {
        this.log.debug("GenericPool:checkOut an object");
        long l = System.currentTimeMillis();
        this.log.debug("GenericPool:checkOut UnlockedObjectCount=" + this.getUnlockedObjectCount());
        this.log.debug("GenericPool:checkOut LockedObjectCount=" + this.getLockedObjectCount());
        this.log.debug("GenericPool:checkOut count=" + this.count + " maxSize=" + this.maxSize);
        if (this.getUnlockedObjectCount() > 0 && (this.checkLevelObject == 3 || this.checkLevelObject == 4)) {
            Enumeration enumeration = this.unlocked.keys();
            while (enumeration.hasMoreElements()) {
                GenerationObject generationObject = (GenerationObject)enumeration.nextElement();
                Object object = generationObject.getObj();
                if (l - (Long)this.unlocked.get(generationObject) > this.lifeTime) {
                    this.log.debug("GenericPool:checkOut an object has expired");
                    this.removeUnlockedObject(generationObject);
                    continue;
                }
                this.log.debug("GenericPool:checkOut check the owner of the connection");
                if (!this.checkOwner(generationObject, string, string2) || (this.checkLevelObject != 3 || this.poolHelper.checkThisObject(object)) && (this.checkLevelObject != 4 || this.poolHelper.testThisObject(object))) continue;
                this.log.debug("GenericPool:checkOut remove object checkLevelObject=" + this.checkLevelObject);
                this.removeUnlockedObject(generationObject);
            }
        }
        int n = 0;
        Object object = this.getFromPool(string, string2);
        while (object == null && (long)n < this.getDeadLockMaxWait()) {
            this.log.info("GenericPool:checkOut waiting for an object :" + ((Object)this.poolHelper).toString());
            try {
                GenericPool genericPool = this;
                synchronized (genericPool) {
                    this.wait(this.getDeadLockRetryWait());
                }
            }
            catch (InterruptedException interruptedException) {
                this.log.error("GenericPool:checkOut ERROR Failed while waiting for an object: " + interruptedException);
            }
            n = (int)((long)n + this.getDeadLockRetryWait());
            object = this.getFromPool(string, string2);
        }
        if (object == null) {
            throw new Exception("GenericPool:checkOut ERROR  impossible to obtain a new object from the pool");
        }
        return object;
    }

    public synchronized void minimumObject() {
        this.minimumObject(null, null);
    }

    public synchronized void minimumObject(String string, String string2) {
        this.log.debug("GenericPool:minimumObject create object if there are less than minSize objects in the pool count =" + this.count);
        if (this.count < this.minSize && this.unlocked != null) {
            long l = System.currentTimeMillis();
            for (int i = this.count; i < this.minSize; ++i) {
                try {
                    GenerationObject generationObject = string != null && string2 != null ? this.poolHelper.create() : this.poolHelper.create(string, string2);
                    this.unlocked.put(generationObject, new Long(l));
                    continue;
                }
                catch (Exception exception) {
                    this.log.error("GenericPool:minimumObject Error Exception in GenericPool:minimumObject");
                }
            }
            this.log.debug("GenericPool:minimumObject count=" + this.count + " Unlocked=" + this.getUnlockedObjectCount() + " locked=" + this.getLockedObjectCount());
            this.count = this.minSize;
        }
    }

    public synchronized void checkIn(Object object) {
        this.log.debug("GenericPool:checkIn return an object to the pool");
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject generationObject = (GenerationObject)enumeration.nextElement();
            if (!generationObject.getObj().equals(object)) continue;
            this.locked.remove(generationObject);
            this.unlocked.put(generationObject, new Long(System.currentTimeMillis()));
            int n = generationObject.getGeneration();
            if (this.generation > n && !this.poolHelper.checkThisObject(generationObject.getObj())) {
                this.removeUnlockedObject(generationObject);
            }
            this.notifyAll();
        }
        if (this.count > this.maxSize) {
            this.log.info("GenericPool:checkIn more than maxSize object in the pool");
            enumeration = this.unlocked.keys();
            for (int i = this.maxSize; i < this.count; ++i) {
                if (this.getUnlockedObjectCount() <= 0) continue;
                GenerationObject generationObject = (GenerationObject)enumeration.nextElement();
                this.removeUnlockedObject(generationObject);
            }
            this.count = this.getUnlockedObjectCount() + this.getLockedObjectCount();
            if (this.count > this.maxSize) {
                this.log.warn("GenericPool:checkIn Be careful, the maximum size of the pool does not correspond to your data. When objects will be check in, the pool will decrease");
            }
        }
    }

    private synchronized void removeUnlockedObject(GenerationObject generationObject) {
        --this.count;
        this.notifyAll();
        this.unlocked.remove(generationObject);
        this.hitList.add(generationObject);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public synchronized void setMinSize(int n) throws Exception {
        if (n < 0) {
            throw new Exception("GenericPool:setMinSize Minimum size of the pool can't be lesser than 0");
        }
        if (n > this.maxSize) {
            throw new Exception("GenericPool:setMinSize Minimum size of the pool can't be greater than the maxSize (" + this.maxSize + ")");
        }
        this.minSize = n;
    }

    public synchronized void setMaxSize(int n) throws Exception {
        if (n < 0) {
            throw new Exception("GenericPool:setMaxSize Maximum size of the pool can't be lesser than 0");
        }
        if (n < this.minSize) {
            throw new Exception("GenericPool:setMaxSize Maximum size of the pool can't be lesser than the minSize (" + this.minSize + ")");
        }
        this.maxSize = n;
        if (this.count > n) {
            this.log.info("GenericPool:setMaxSize pool has more than max element");
            Enumeration enumeration = this.unlocked.keys();
            for (int i = n; i < this.count; ++i) {
                if (this.getUnlockedObjectCount() <= 0) continue;
                GenerationObject generationObject = (GenerationObject)enumeration.nextElement();
                this.removeUnlockedObject(generationObject);
            }
            this.count = this.getUnlockedObjectCount() + this.getLockedObjectCount();
            if (this.count > n) {
                this.log.warn("GenericPool:setMaxSize Be careful, the maximum size of the pool does not correspond to your data. When objects will be check in, the pool will decrease");
            }
        }
    }

    public void setLifeTime(long l) {
        this.lifeTime = l;
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    public void setGeneration(int n) {
        this.generation = n;
        this.log.debug("GenericPool:setGeneration Be careful, it is very dangerous to change the generation number, many objects could be destroyed");
    }

    public void setGC(boolean bl) {
        this.gc = bl;
    }

    public void setCheckLevelObject(int n) {
        if (n > 0 && n <= 4) {
            this.checkLevelObject = n;
        }
    }

    public void setDeadLockMaxWait(long l) {
        this.deadLockMaxWait = l;
    }

    public void setDeadLockRetryWait(long l) {
        this.deadLockRetryWait = l;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public boolean isGC() {
        return this.gc;
    }

    public int getCount() {
        return this.count;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getCheckLevelObject() {
        return this.checkLevelObject;
    }

    public void stop() {
        this.log.debug("GenericPool:stop start to stop the pool");
        if (this.getLockedObjectCount() != 0 || this.getUnlockedObjectCount() != 0) {
            this.expireAll();
            if (this.poolKeeper != null) {
                this.poolKeeper.stop();
            }
            this.keeper.interrupt();
            this.locked.clear();
            this.unlocked.clear();
            this.locked = null;
            this.unlocked = null;
            this.count = 0;
        }
        this.log.debug("GenericPool:stop pool stopped");
    }

    public int getLockedObjectCount() {
        if (this.locked != null) {
            return this.locked.size();
        }
        return 0;
    }

    public int getUnlockedObjectCount() {
        if (this.unlocked != null) {
            return this.unlocked.size();
        }
        return 0;
    }

    public long getDeadLockMaxWait() {
        return this.deadLockMaxWait;
    }

    public long getDeadLockRetryWait() {
        return this.deadLockRetryWait;
    }

    public String toString() {
        GenerationObject generationObject;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GenericPool:\n");
        stringBuffer.append("     num of element =<" + this.count + ">\n");
        stringBuffer.append("     minSize =<" + this.minSize + ">\n");
        stringBuffer.append("     maxSize =<" + this.maxSize + ">\n");
        stringBuffer.append("     lifeTime =<" + this.lifeTime + ">\n");
        stringBuffer.append("     ngeneration =<" + this.generation + ">\n");
        stringBuffer.append("     getLockedObjectCount() =<" + this.getLockedObjectCount() + ">\n");
        stringBuffer.append("     getUnlockedObjectCount() =<" + this.getUnlockedObjectCount() + ">\n");
        stringBuffer.append("     getDeadLockMaxWait() =<" + this.getDeadLockMaxWait() + ">\n");
        stringBuffer.append("     getDeadLockRetryWait() =<" + this.getDeadLockRetryWait() + ">\n");
        if (this.unlocked != null) {
            stringBuffer.append("Unlocked pool:\n");
            enumeration = this.unlocked.keys();
            while (enumeration.hasMoreElements()) {
                generationObject = (GenerationObject)enumeration.nextElement();
                stringBuffer.append(generationObject.getObj().toString());
            }
        }
        if (this.locked != null) {
            stringBuffer.append("Locked pool:\n");
            enumeration = this.unlocked.keys();
            while (enumeration.hasMoreElements()) {
                generationObject = (GenerationObject)enumeration.nextElement();
                stringBuffer.append(generationObject.getObj().toString());
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object;
        Object object2;
        GenericPool genericPool = this;
        synchronized (genericPool) {
            if (this.unlocked == null) {
                return;
            }
        }
        long l = System.currentTimeMillis();
        Object object3 = this;
        synchronized (object3) {
            object2 = this.unlocked.keys();
            while (object2.hasMoreElements()) {
                object = (GenerationObject)object2.nextElement();
                long l2 = (Long)this.unlocked.get(object);
                if (l - l2 <= this.lifeTime) continue;
                this.log.debug("GenericPool:cleanUp clean up the pool");
                this.removeUnlockedObject((GenerationObject)object);
            }
        }
        while (this.hitList.size() > 0) {
            object3 = (GenerationObject)this.hitList.remove(0);
            this.log.debug("GenericPool:cleanUp killing an object");
            this.poolHelper.expire(((GenerationObject)object3).getObj());
            ((GenerationObject)object3).killObject();
        }
        if (this.isGC()) {
            System.gc();
        }
        boolean bl = false;
        object2 = this;
        synchronized (object2) {
            bl = this.count < this.minSize;
        }
        if (bl) {
            this.log.info("GenericPool:cleanUp less than minSize objects in the pool min=" + this.minSize + " max=" + this.maxSize + " count=" + this.count);
            while (true) {
                try {
                    object2 = this.poolHelper.create();
                    object = this;
                    synchronized (object) {
                        this.unlocked.put(object2, new Long(l));
                        ++this.count;
                        this.notifyAll();
                        if (this.count >= this.minSize) {
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    this.log.error("GenericPool:cleanUp Error Exception in GenericPool:cleanUp");
                }
                object2 = this;
                synchronized (object2) {
                    this.notifyAll();
                }
            }
            this.log.info("GenericPool:cleanUp done min=" + this.minSize + " max=" + this.maxSize + " count=" + this.count);
        }
    }

    void expireAll() {
        GenerationObject generationObject;
        this.log.debug("GenericPool:expireAll close all object in the unlocked and locked structures");
        Enumeration enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            generationObject = (GenerationObject)enumeration.nextElement();
            this.poolHelper.expire(generationObject.getObj());
            generationObject.killObject();
            generationObject = null;
        }
        enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            generationObject = (GenerationObject)enumeration.nextElement();
            this.poolHelper.expire(generationObject.getObj());
            generationObject.killObject();
            generationObject = null;
        }
    }

    public void nextGeneration(Object object) {
        GenerationObject generationObject;
        this.log.debug("GenericPool:nextGeneration");
        int n = 0;
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            generationObject = (GenerationObject)enumeration.nextElement();
            if (!generationObject.getObj().equals(object)) continue;
            n = generationObject.getGeneration();
        }
        enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            generationObject = (GenerationObject)enumeration.nextElement();
            if (generationObject.getGeneration() > n || this.poolHelper.checkThisObject(generationObject.getObj())) continue;
            this.removeUnlockedObject(generationObject);
        }
        ++this.generation;
    }

    public synchronized void removeLockedObject(Object object) {
        this.log.debug("GenericPool:removeObject remove an object");
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject generationObject = (GenerationObject)enumeration.nextElement();
            if (!generationObject.getObj().equals(object)) continue;
            this.locked.remove(generationObject);
            --this.count;
            generationObject.killObject();
            generationObject = null;
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public Hashtable getLockedObject() {
        return this.locked;
    }
}

