/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.oracle;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXAResource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXADataSource;

public final class OracleXAConnection
extends StandardXAConnection {
    private XAResource xarsrc = null;
    private static Hashtable txctxs = new Hashtable();

    public OracleXAConnection(StandardXADataSource standardXADataSource, String string, String string2) throws SQLException {
        super(standardXADataSource, string, string2);
    }

    private OracleXid getOracleXid(Xid xid) throws XAException {
        if (!(xid instanceof OracleXid)) {
            byte[] byArray = (byte[])txctxs.get(xid);
            this.dataSource.log.debug("txctx is " + byArray);
            OracleXid oracleXid = new OracleXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), byArray);
            return oracleXid;
        }
        return (OracleXid)xid;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this.dataSource.log.debug("commit:" + xid.getGlobalTransactionId());
        this.xarsrc.commit((Xid)this.getOracleXid(xid), bl);
        this.xaDataSource.freeConnection(xid, false);
        txctxs.remove(xid);
    }

    public void end(Xid xid, int n) throws XAException {
        this.dataSource.log.debug("end:" + xid.getFormatId() + ":" + xid.getGlobalTransactionId() + ":" + xid.getBranchQualifier() + ":" + n);
        this.xarsrc.end((Xid)this.getOracleXid(xid), n);
    }

    public void forget(Xid xid) throws XAException {
        this.dataSource.log.debug("forget:" + xid.getGlobalTransactionId());
        this.xarsrc.forget((Xid)this.getOracleXid(xid));
        this.xaDataSource.freeConnection(xid, false);
        txctxs.remove(xid);
    }

    public int prepare(Xid xid) throws XAException {
        this.dataSource.log.debug("prepare:" + xid.getGlobalTransactionId());
        int n = this.xarsrc.prepare((Xid)this.getOracleXid(xid));
        if (n == 3) {
            this.xaDataSource.freeConnection(xid, false);
            txctxs.remove(xid);
        }
        return n;
    }

    public void rollback(Xid xid) throws XAException {
        this.dataSource.log.debug("rollback:" + xid.getGlobalTransactionId());
        this.xarsrc.rollback((Xid)this.getOracleXid(xid));
        this.xaDataSource.freeConnection(xid, false);
        txctxs.remove(xid);
    }

    public void start(Xid xid, int n) throws XAException {
        this.dataSource.log.debug("start:" + xid.getFormatId() + ":" + xid.getGlobalTransactionId() + ":" + xid.getBranchQualifier() + ":" + n);
        this.doStart(xid, n);
        this.xarsrc = new OracleXAResource(this.curCon.con);
        OracleXid oracleXid = this.getOracleXid(xid);
        this.xarsrc.start((Xid)oracleXid, n);
        txctxs.put(xid, oracleXid.getTxContext());
        this.curCon = null;
        this.con = null;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof OracleXAConnection)) {
            this.dataSource.log.debug("isSameRM returning false");
            return false;
        }
        OracleXAConnection oracleXAConnection = (OracleXAConnection)xAResource;
        if (oracleXAConnection.xarsrc.isSameRM(this.xarsrc)) {
            this.dataSource.log.debug("isSameRM returning true");
            return true;
        }
        this.dataSource.log.debug("isSameRM returning false");
        return false;
    }
}

