/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.instantdb;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.enhydra.instantdb.jdbc.ConnectionExtensions;
import org.enhydra.jdbc.instantdb.IdbXADataSource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.enhydra.jdbc.standard.StandardXAStatefulConnection;

public final class IdbXAConnection
extends StandardXAConnection {
    public IdbXAConnection(StandardXADataSource standardXADataSource, String string, String string2) throws SQLException {
        super(standardXADataSource, string, string2);
    }

    public void start(Xid xid, int n) throws XAException {
        this.doStart(xid, n);
        this.curCon.commitOnPrepare = false;
        ConnectionExtensions connectionExtensions = (ConnectionExtensions)this.curCon.con;
        connectionExtensions.startGlobalTransaction(xid);
        this.curCon = null;
        this.con = null;
    }

    public int prepare(Xid xid) throws XAException {
        StandardXAStatefulConnection standardXAStatefulConnection = this.checkPreparedState(xid);
        ConnectionExtensions connectionExtensions = (ConnectionExtensions)standardXAStatefulConnection.con;
        int n = connectionExtensions.prepare();
        if (n == 3) {
            this.xaDataSource.freeConnection(xid, false);
        }
        return n;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (super.isSameRM(xAResource)) {
            return true;
        }
        if (xAResource instanceof IdbXAConnection) {
            IdbXAConnection idbXAConnection = (IdbXAConnection)xAResource;
            IdbXADataSource idbXADataSource = (IdbXADataSource)idbXAConnection.dataSource;
            IdbXADataSource idbXADataSource2 = (IdbXADataSource)this.dataSource;
            if (idbXADataSource2.databaseId.equals(idbXADataSource.databaseId)) {
                return true;
            }
        }
        return false;
    }
}

